/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet.socket;

import android.net.Network;
import com.ustadmobile.meshrabiya.ext.InetAddressExtKt;
import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.vnet.VirtualRouter;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketExtKt;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketInitRequest;
import com.ustadmobile.meshrabiya.vnet.socket.ChainSocketNextHop;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocket;", "Ljava/net/Socket;", "virtualRouter", "Lcom/ustadmobile/meshrabiya/vnet/VirtualRouter;", "logger", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "(Lcom/ustadmobile/meshrabiya/vnet/VirtualRouter;Lcom/ustadmobile/meshrabiya/log/MNetLogger;)V", "logPrefix", "", "connect", "", "endpoint", "Ljava/net/SocketAddress;", "timeout", "", "lib-meshrabiya_debug"})
public final class ChainSocket
extends Socket {
    @NotNull
    private final VirtualRouter virtualRouter;
    @NotNull
    private final MNetLogger logger;
    @NotNull
    private final String logPrefix;

    public ChainSocket(@NotNull VirtualRouter virtualRouter, @NotNull MNetLogger logger) {
        Intrinsics.checkNotNullParameter((Object)virtualRouter, (String)"virtualRouter");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.virtualRouter = virtualRouter;
        this.logger = logger;
        this.logPrefix = "[ChainSocket for " + this.virtualRouter.getAddress() + "]";
    }

    @Override
    public void connect(@NotNull SocketAddress endpoint, int timeout) {
        InetAddress address;
        InetSocketAddress endpointInetAddr;
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        InetSocketAddress inetSocketAddress = endpointInetAddr = endpoint instanceof InetSocketAddress ? (InetSocketAddress)endpoint : null;
        InetAddress inetAddress = address = inetSocketAddress != null ? inetSocketAddress.getAddress() : null;
        boolean bl = inetAddress != null ? InetAddressExtKt.prefixMatches(inetAddress, this.virtualRouter.getNetworkPrefixLength(), this.virtualRouter.getAddress()) : false;
        if (bl) {
            InetAddress inetAddress2 = endpointInetAddr.getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress2, (String)"getAddress(...)");
            ChainSocketNextHop nextHop = this.virtualRouter.lookupNextHopForChainSocket(inetAddress2, ((InetSocketAddress)endpoint).getPort());
            Network network = nextHop.getNetwork();
            if (network != null) {
                MNetLogger.invoke$default(this.logger, 3, this.logPrefix + " binding socket to network " + network + " to connect to " + endpoint, null, 4, null);
                network.bindSocket((Socket)this);
            }
            try {
                super.connect(new InetSocketAddress(nextHop.getAddress(), nextHop.getPort()));
                ChainSocketExtKt.initializeChainIfNotFinalDest(this, new ChainSocketInitRequest(address, endpointInetAddr.getPort(), this.virtualRouter.getAddress(), 0, 8, null), nextHop);
                MNetLogger.invoke$default(this.logger, 4, this.logPrefix + " created socket to " + address + ":" + this.getPort() + " nexthop = " + nextHop.getAddress() + ":" + nextHop.getPort(), null, 4, null);
            }
            catch (Exception e) {
                this.logger.invoke(6, this.logPrefix + " Exception connecting to " + endpoint + " nexthop=" + nextHop.getAddress() + ":" + nextHop.getPort() + " (finalDest=" + nextHop.isFinalDest() + ")", e);
                throw e;
            }
        } else {
            super.connect(endpoint, timeout);
        }
    }
}

