/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet.socket;

import com.ustadmobile.meshrabiya.ext.ByteBufferExtKt;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketInitRequest;", "", "virtualDestAddr", "Ljava/net/InetAddress;", "virtualDestPort", "", "fromAddr", "hopCount", "", "(Ljava/net/InetAddress;ILjava/net/InetAddress;B)V", "getFromAddr", "()Ljava/net/InetAddress;", "getHopCount", "()B", "getVirtualDestAddr", "getVirtualDestPort", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toBytes", "", "toString", "", "Companion", "lib-meshrabiya_debug"})
public final class ChainSocketInitRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InetAddress virtualDestAddr;
    private final int virtualDestPort;
    @NotNull
    private final InetAddress fromAddr;
    private final byte hopCount;
    public static final int MESSAGE_SIZE = 13;

    public ChainSocketInitRequest(@NotNull InetAddress virtualDestAddr, int virtualDestPort, @NotNull InetAddress fromAddr, byte hopCount) {
        Intrinsics.checkNotNullParameter((Object)virtualDestAddr, (String)"virtualDestAddr");
        Intrinsics.checkNotNullParameter((Object)fromAddr, (String)"fromAddr");
        this.virtualDestAddr = virtualDestAddr;
        this.virtualDestPort = virtualDestPort;
        this.fromAddr = fromAddr;
        this.hopCount = hopCount;
    }

    public /* synthetic */ ChainSocketInitRequest(InetAddress inetAddress, int n, InetAddress inetAddress2, byte by, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            by = 0;
        }
        this(inetAddress, n, inetAddress2, by);
    }

    @NotNull
    public final InetAddress getVirtualDestAddr() {
        return this.virtualDestAddr;
    }

    public final int getVirtualDestPort() {
        return this.virtualDestPort;
    }

    @NotNull
    public final InetAddress getFromAddr() {
        return this.fromAddr;
    }

    public final byte getHopCount() {
        return this.hopCount;
    }

    @NotNull
    public final byte[] toBytes() {
        byte[] byteArr = new byte[13];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArr).order(ByteOrder.BIG_ENDIAN);
        Intrinsics.checkNotNull((Object)byteBuffer);
        ByteBufferExtKt.putInet4Address(byteBuffer, this.virtualDestAddr);
        byteBuffer.putInt(this.virtualDestPort);
        ByteBufferExtKt.putInet4Address(byteBuffer, this.fromAddr);
        byteBuffer.put(this.hopCount);
        return byteArr;
    }

    @NotNull
    public final InetAddress component1() {
        return this.virtualDestAddr;
    }

    public final int component2() {
        return this.virtualDestPort;
    }

    @NotNull
    public final InetAddress component3() {
        return this.fromAddr;
    }

    public final byte component4() {
        return this.hopCount;
    }

    @NotNull
    public final ChainSocketInitRequest copy(@NotNull InetAddress virtualDestAddr, int virtualDestPort, @NotNull InetAddress fromAddr, byte hopCount) {
        Intrinsics.checkNotNullParameter((Object)virtualDestAddr, (String)"virtualDestAddr");
        Intrinsics.checkNotNullParameter((Object)fromAddr, (String)"fromAddr");
        return new ChainSocketInitRequest(virtualDestAddr, virtualDestPort, fromAddr, hopCount);
    }

    public static /* synthetic */ ChainSocketInitRequest copy$default(ChainSocketInitRequest chainSocketInitRequest, InetAddress inetAddress, int n, InetAddress inetAddress2, byte by, int n2, Object object) {
        if ((n2 & 1) != 0) {
            inetAddress = chainSocketInitRequest.virtualDestAddr;
        }
        if ((n2 & 2) != 0) {
            n = chainSocketInitRequest.virtualDestPort;
        }
        if ((n2 & 4) != 0) {
            inetAddress2 = chainSocketInitRequest.fromAddr;
        }
        if ((n2 & 8) != 0) {
            by = chainSocketInitRequest.hopCount;
        }
        return chainSocketInitRequest.copy(inetAddress, n, inetAddress2, by);
    }

    @NotNull
    public String toString() {
        return "ChainSocketInitRequest(virtualDestAddr=" + this.virtualDestAddr + ", virtualDestPort=" + this.virtualDestPort + ", fromAddr=" + this.fromAddr + ", hopCount=" + this.hopCount + ")";
    }

    public int hashCode() {
        int result = this.virtualDestAddr.hashCode();
        result = result * 31 + Integer.hashCode(this.virtualDestPort);
        result = result * 31 + this.fromAddr.hashCode();
        result = result * 31 + Byte.hashCode(this.hopCount);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ChainSocketInitRequest)) {
            return false;
        }
        ChainSocketInitRequest chainSocketInitRequest = (ChainSocketInitRequest)other;
        if (!Intrinsics.areEqual((Object)this.virtualDestAddr, (Object)chainSocketInitRequest.virtualDestAddr)) {
            return false;
        }
        if (this.virtualDestPort != chainSocketInitRequest.virtualDestPort) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fromAddr, (Object)chainSocketInitRequest.fromAddr)) {
            return false;
        }
        return this.hopCount == chainSocketInitRequest.hopCount;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketInitRequest$Companion;", "", "()V", "MESSAGE_SIZE", "", "fromBytes", "Lcom/ustadmobile/meshrabiya/vnet/socket/ChainSocketInitRequest;", "byteArray", "", "offset", "lib-meshrabiya_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChainSocketInitRequest fromBytes(@NotNull byte[] byteArray, int offset) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            ByteBuffer byteBuf = ByteBuffer.wrap(byteArray, offset, 13).order(ByteOrder.BIG_ENDIAN);
            Intrinsics.checkNotNull((Object)byteBuf);
            InetAddress virtualDestADdr = ByteBufferExtKt.getInet4Address(byteBuf);
            int virtualDestPort = byteBuf.getInt();
            InetAddress fromAddr = ByteBufferExtKt.getInet4Address(byteBuf);
            byte hopCount = byteBuf.get();
            return new ChainSocketInitRequest(virtualDestADdr, virtualDestPort, fromAddr, hopCount);
        }

        public static /* synthetic */ ChainSocketInitRequest fromBytes$default(Companion companion, byte[] byArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.fromBytes(byArray, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

