/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet;

import com.ustadmobile.meshrabiya.ext.ByteArrayExtKt;
import com.ustadmobile.meshrabiya.ext.InetAddressExtKt;
import com.ustadmobile.meshrabiya.portforward.ReturnPathSocketFactory;
import com.ustadmobile.meshrabiya.vnet.VirtualNode;
import java.net.DatagramSocket;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/VirtualNodeReturnPathSocketFactory;", "Lcom/ustadmobile/meshrabiya/portforward/ReturnPathSocketFactory;", "node", "Lcom/ustadmobile/meshrabiya/vnet/VirtualNode;", "(Lcom/ustadmobile/meshrabiya/vnet/VirtualNode;)V", "createSocket", "Ljava/net/DatagramSocket;", "destAddress", "Ljava/net/InetAddress;", "port", "", "lib-meshrabiya_release"})
@SourceDebugExtension(value={"SMAP\nVirtualNodeReturnPathSocketFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualNodeReturnPathSocketFactory.kt\ncom/ustadmobile/meshrabiya/vnet/VirtualNodeReturnPathSocketFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
public final class VirtualNodeReturnPathSocketFactory
implements ReturnPathSocketFactory {
    @NotNull
    private final VirtualNode node;

    public VirtualNodeReturnPathSocketFactory(@NotNull VirtualNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
    }

    @Override
    @NotNull
    public DatagramSocket createSocket(@NotNull InetAddress destAddress, int port) {
        Intrinsics.checkNotNullParameter((Object)destAddress, (String)"destAddress");
        byte[] byArray = destAddress.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getAddress(...)");
        int n = this.node.getNetworkPrefixLength();
        byte[] byArray2 = this.node.getAddress().getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getAddress(...)");
        if (!ByteArrayExtKt.prefixMatches(byArray, n, byArray2)) {
            InetAddress bindAddress;
            InetAddress inetAddress = bindAddress = InetAddressExtKt.findLocalInetAddressForDestinationAddress(destAddress);
            if (inetAddress == null) {
                throw new IllegalArgumentException("Could not find network interface with subnet mask for dest address " + destAddress);
            }
            InetAddress it = inetAddress;
            boolean bl = false;
            return new DatagramSocket(0, it);
        }
        return this.node.createBoundDatagramSocket(0);
    }
}

