/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.ustadmobile.meshrabiya.MeshrabiyaConstants;
import com.ustadmobile.meshrabiya.UuidUtilKt;
import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.log.MNetLoggerStdout;
import com.ustadmobile.meshrabiya.server.OnUuidAllocatedListener;
import com.ustadmobile.meshrabiya.vnet.bluetooth.VirtualNodeGattServer;
import java.io.Closeable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0085\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006*\u0001\u001e\u0018\u00002\u00020\u0001:\u00010B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0002J\b\u0010-\u001a\u00020+H\u0002J\u0006\u0010.\u001a\u00020+J\u0006\u0010/\u001a\u00020+R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\n )*\u0004\u0018\u00010(0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/bluetooth/VirtualNodeGattServer;", "Ljava/io/Closeable;", "appContext", "Landroid/content/Context;", "allocationServiceUuid", "Ljava/util/UUID;", "allocationCharacteristicUuid", "vNetLogger", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "maxSimultaneousClients", "", "onUuidAllocated", "Lcom/ustadmobile/meshrabiya/server/OnUuidAllocatedListener;", "(Landroid/content/Context;Ljava/util/UUID;Ljava/util/UUID;Lcom/ustadmobile/meshrabiya/log/MNetLogger;ILcom/ustadmobile/meshrabiya/server/OnUuidAllocatedListener;)V", "allocatedUuidLock", "Ljava/util/concurrent/locks/ReentrantLock;", "allocatedUuids", "Ljava/util/concurrent/ConcurrentHashMap;", "Landroid/bluetooth/BluetoothDevice;", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "bluetoothManager", "Landroid/bluetooth/BluetoothManager;", "broadcastReceiver", "Landroid/content/BroadcastReceiver;", "characteristic", "Landroid/bluetooth/BluetoothGattCharacteristic;", "gattServer", "Landroid/bluetooth/BluetoothGattServer;", "gattServerCallback", "com/ustadmobile/meshrabiya/vnet/bluetooth/VirtualNodeGattServer$gattServerCallback$1", "Lcom/ustadmobile/meshrabiya/vnet/bluetooth/VirtualNodeGattServer$gattServerCallback$1;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "receiverRegistered", "", "service", "Landroid/bluetooth/BluetoothGattService;", "started", "useUuidExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "close", "", "closeGattServer", "openGattServer", "start", "stop", "DataAcceptRunnable", "lib-meshrabiya_debug"})
@SourceDebugExtension(value={"SMAP\nVirtualNodeGattServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualNodeGattServer.kt\ncom/ustadmobile/meshrabiya/vnet/bluetooth/VirtualNodeGattServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,260:1\n1#2:261\n*E\n"})
public final class VirtualNodeGattServer
implements Closeable {
    @NotNull
    private final Context appContext;
    @NotNull
    private final UUID allocationCharacteristicUuid;
    @NotNull
    private final MNetLogger vNetLogger;
    private final int maxSimultaneousClients;
    @NotNull
    private final OnUuidAllocatedListener onUuidAllocated;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final BluetoothGattService service;
    @NotNull
    private final BluetoothGattCharacteristic characteristic;
    @NotNull
    private final BluetoothManager bluetoothManager;
    @Nullable
    private final BluetoothAdapter bluetoothAdapter;
    @NotNull
    private final ConcurrentHashMap<UUID, BluetoothDevice> allocatedUuids;
    @NotNull
    private final ReentrantLock allocatedUuidLock;
    @Nullable
    private volatile BluetoothGattServer gattServer;
    private final ExecutorService useUuidExecutor;
    private boolean started;
    private boolean receiverRegistered;
    @NotNull
    private final gattServerCallback.1 gattServerCallback;
    @NotNull
    private final BroadcastReceiver broadcastReceiver;

    public VirtualNodeGattServer(@NotNull Context appContext, @NotNull UUID allocationServiceUuid, @NotNull UUID allocationCharacteristicUuid, @NotNull MNetLogger vNetLogger, int maxSimultaneousClients, @NotNull OnUuidAllocatedListener onUuidAllocated) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)allocationServiceUuid, (String)"allocationServiceUuid");
        Intrinsics.checkNotNullParameter((Object)allocationCharacteristicUuid, (String)"allocationCharacteristicUuid");
        Intrinsics.checkNotNullParameter((Object)vNetLogger, (String)"vNetLogger");
        Intrinsics.checkNotNullParameter((Object)onUuidAllocated, (String)"onUuidAllocated");
        this.appContext = appContext;
        this.allocationCharacteristicUuid = allocationCharacteristicUuid;
        this.vNetLogger = vNetLogger;
        this.maxSimultaneousClients = maxSimultaneousClients;
        this.onUuidAllocated = onUuidAllocated;
        this.isClosed = new AtomicBoolean(false);
        this.service = new BluetoothGattService(allocationServiceUuid, 0);
        this.characteristic = new BluetoothGattCharacteristic(this.allocationCharacteristicUuid, 10, 17);
        Object object = this.appContext.getSystemService(BluetoothManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getSystemService(...)");
        this.bluetoothManager = (BluetoothManager)object;
        this.bluetoothAdapter = this.bluetoothManager.getAdapter();
        this.allocatedUuids = new ConcurrentHashMap();
        this.allocatedUuidLock = new ReentrantLock();
        this.useUuidExecutor = Executors.newFixedThreadPool(this.maxSimultaneousClients);
        this.gattServerCallback = new BluetoothGattServerCallback(this){
            final /* synthetic */ VirtualNodeGattServer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onServiceAdded(int status, @Nullable BluetoothGattService service) {
                Object object;
                super.onServiceAdded(status, service);
                BluetoothGattService bluetoothGattService = service;
                Log.d((String)"Meshrabiya", (String)("Service added: " + (bluetoothGattService != null ? bluetoothGattService.getUuid() : null) + " characteristics = " + ((object = service) != null && (object = object.getCharacteristics()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), null, null, null, (int)0, null, (Function1)gattServerCallback.onServiceAdded.1.INSTANCE, (int)31, null) : null)));
            }

            public void onConnectionStateChange(@Nullable BluetoothDevice device, int status, int newState) {
                super.onConnectionStateChange(device, status, newState);
                BluetoothDevice bluetoothDevice = device;
                Log.d((String)"Meshrabiya", (String)("onConnectionChanged: " + (bluetoothDevice != null ? bluetoothDevice.getAddress() : null) + ": status = " + newState));
                if (status == 2 && device != null) {
                    try {
                        Log.i((String)"Meshrabiya", (String)("onConnectionChanged: connecting to " + device.getAddress()));
                        BluetoothGattServer bluetoothGattServer = VirtualNodeGattServer.access$getGattServer$p(this.this$0);
                        if (bluetoothGattServer != null) {
                            bluetoothGattServer.connect(device, false);
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                } else if (status == 0) {
                    try {
                        BluetoothDevice bluetoothDevice2 = device;
                        if (bluetoothDevice2 != null) {
                            BluetoothDevice e = bluetoothDevice2;
                            VirtualNodeGattServer virtualNodeGattServer = this.this$0;
                            BluetoothDevice it = e;
                            boolean bl = false;
                            BluetoothGattServer bluetoothGattServer = VirtualNodeGattServer.access$getGattServer$p(virtualNodeGattServer);
                            if (bluetoothGattServer != null) {
                                bluetoothGattServer.cancelConnection(it);
                            }
                            Log.d((String)"Meshrabiya", (String)"onConnectionChange: disconnected. cancelConnection called.");
                        }
                    }
                    catch (SecurityException e) {
                        Log.e((String)"Meshrabiya", (String)"Security exception on cancelConnection: permission revoked?", (Throwable)e);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCharacteristicReadRequest(@NotNull BluetoothDevice device, int requestId, int offset, @NotNull BluetoothGattCharacteristic characteristic) {
                Intrinsics.checkNotNullParameter((Object)device, (String)"device");
                Intrinsics.checkNotNullParameter((Object)characteristic, (String)"characteristic");
                if (Intrinsics.areEqual((Object)characteristic.getUuid(), (Object)VirtualNodeGattServer.access$getAllocationCharacteristicUuid$p(this.this$0))) {
                    try {
                        Boolean responseSent;
                        UUID uUID;
                        Lock lock = VirtualNodeGattServer.access$getAllocatedUuidLock$p(this.this$0);
                        VirtualNodeGattServer virtualNodeGattServer = this.this$0;
                        lock.lock();
                        try {
                            UUID uUID2;
                            boolean bl = false;
                            if (VirtualNodeGattServer.access$getAllocatedUuids$p(virtualNodeGattServer).size() < VirtualNodeGattServer.access$getMaxSimultaneousClients$p(virtualNodeGattServer)) {
                                UUID uUID3;
                                UUID it = uUID3 = UUID.randomUUID();
                                boolean bl2 = false;
                                Map map2 = VirtualNodeGattServer.access$getAllocatedUuids$p(virtualNodeGattServer);
                                Intrinsics.checkNotNull((Object)it);
                                map2.put(it, device);
                                uUID2 = uUID3;
                            } else {
                                uUID2 = MeshrabiyaConstants.INSTANCE.getUUID_BUSY();
                            }
                            uUID = uUID2;
                        }
                        finally {
                            lock.unlock();
                        }
                        UUID allocatedUuid = uUID;
                        BluetoothGattServer bluetoothGattServer = VirtualNodeGattServer.access$getGattServer$p(this.this$0);
                        if (bluetoothGattServer != null) {
                            Intrinsics.checkNotNull((Object)allocatedUuid);
                            v3 = bluetoothGattServer.sendResponse(device, requestId, 0, 0, UuidUtilKt.toBytes(allocatedUuid));
                        } else {
                            v3 = responseSent = null;
                        }
                        if (!Intrinsics.areEqual((Object)allocatedUuid, (Object)MeshrabiyaConstants.INSTANCE.getUUID_BUSY()) && Intrinsics.areEqual((Object)responseSent, (Object)true)) {
                            ExecutorService executorService = VirtualNodeGattServer.access$getUseUuidExecutor$p(this.this$0);
                            Intrinsics.checkNotNull((Object)allocatedUuid);
                            executorService.submit(this.this$0.new DataAcceptRunnable(allocatedUuid, VirtualNodeGattServer.access$getOnUuidAllocated$p(this.this$0)));
                            Log.i((String)"Meshrabiya", (String)("Send allocated uuid " + allocatedUuid + " to " + device.getAddress() + " : sent=" + responseSent));
                        } else if (!Intrinsics.areEqual((Object)allocatedUuid, (Object)MeshrabiyaConstants.INSTANCE.getUUID_BUSY()) && !Intrinsics.areEqual((Object)responseSent, (Object)true)) {
                            VirtualNodeGattServer.access$getAllocatedUuids$p(this.this$0).remove(allocatedUuid);
                        }
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                } else {
                    Log.d((String)"Meshrabiya", (String)"onCharacteristicReadRequest: not our service");
                }
            }
        };
        this.broadcastReceiver = new BroadcastReceiver(this){
            final /* synthetic */ VirtualNodeGattServer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                if (intent != null && Intrinsics.areEqual((Object)intent.getAction(), (Object)"android.bluetooth.adapter.action.STATE_CHANGED")) {
                    int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                    switch (state) {
                        case 12: {
                            if (!VirtualNodeGattServer.access$getStarted$p(this.this$0)) break;
                            VirtualNodeGattServer.access$openGattServer(this.this$0);
                            break;
                        }
                        case 10: {
                            if (!VirtualNodeGattServer.access$getStarted$p(this.this$0)) break;
                            VirtualNodeGattServer.access$closeGattServer(this.this$0);
                        }
                    }
                }
            }
        };
        this.service.addCharacteristic(this.characteristic);
    }

    public /* synthetic */ VirtualNodeGattServer(Context context, UUID uUID, UUID uUID2, MNetLogger mNetLogger, int n, OnUuidAllocatedListener onUuidAllocatedListener, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            mNetLogger = new MNetLoggerStdout(0, 1, null);
        }
        if ((n2 & 0x10) != 0) {
            n = 4;
        }
        this(context, uUID, uUID2, mNetLogger, n, onUuidAllocatedListener);
    }

    public final void start() {
        Context context;
        this.started = true;
        this.openGattServer();
        Context it = context = this.appContext;
        boolean bl = false;
        Object object = !this.receiverRegistered ? context : null;
        if (object != null) {
            object.registerReceiver(this.broadcastReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
        }
        this.receiverRegistered = true;
    }

    private final void openGattServer() {
        if (this.isClosed.get()) {
            throw new IllegalStateException("Cannot start/open gatt server: UuidAllocationServer closed!");
        }
        if (this.gattServer == null) {
            BluetoothAdapter bluetoothAdapter2 = this.bluetoothAdapter;
            boolean bl = bluetoothAdapter2 != null ? bluetoothAdapter2.isEnabled() : false;
            if (bl) {
                try {
                    BluetoothGattServer bluetoothGattServer;
                    BluetoothGattServer it = bluetoothGattServer = this.bluetoothManager.openGattServer(this.appContext, (BluetoothGattServerCallback)this.gattServerCallback);
                    boolean bl2 = false;
                    Log.d((String)"Meshrabiya", (String)"Opened Gatt server");
                    if (it.addService(this.service)) {
                        this.gattServer = it;
                        Log.d((String)"Meshrabiya", (String)"Add service request submitted");
                    } else {
                        Log.e((String)"Meshrabiya", (String)"Add service request submission failed, close");
                        it.close();
                    }
                }
                catch (SecurityException e) {
                    Log.e((String)"Meshrabiya", (String)"Security exception opening gatt server. No permission?", (Throwable)e);
                }
                catch (Exception e) {
                    Log.e((String)"Meshrabiya", (String)"Other exception opening gatt server.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeGattServer() {
        block7: {
            BluetoothGattServer bluetoothGattServer;
            BluetoothGattServer bluetoothGattServer2 = this.gattServer;
            if (bluetoothGattServer2 == null) break block7;
            BluetoothGattServer server = bluetoothGattServer = bluetoothGattServer2;
            boolean bl = false;
            try {
                server.close();
                Log.d((String)"Meshrabiya", (String)"Uuid Allocation gatt server closed");
                this.allocatedUuids.clear();
            }
            catch (SecurityException e) {
                Log.e((String)"Meshrabiya", (String)"Security exception closing gatt server. No permission?", (Throwable)e);
            }
            catch (Exception e) {
                Log.e((String)"Meshrabiya", (String)"Other exception closing gatt server.", (Throwable)e);
            }
            finally {
                this.gattServer = null;
            }
        }
    }

    public final void stop() {
        Context context;
        this.started = false;
        this.closeGattServer();
        Context it = context = this.appContext;
        boolean bl = false;
        Object object = this.receiverRegistered ? context : null;
        if (object != null) {
            object.unregisterReceiver(this.broadcastReceiver);
        }
        this.receiverRegistered = false;
    }

    @Override
    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            this.stop();
            this.useUuidExecutor.shutdown();
        }
    }

    public static final /* synthetic */ BluetoothGattServer access$getGattServer$p(VirtualNodeGattServer $this) {
        return $this.gattServer;
    }

    public static final /* synthetic */ UUID access$getAllocationCharacteristicUuid$p(VirtualNodeGattServer $this) {
        return $this.allocationCharacteristicUuid;
    }

    public static final /* synthetic */ ReentrantLock access$getAllocatedUuidLock$p(VirtualNodeGattServer $this) {
        return $this.allocatedUuidLock;
    }

    public static final /* synthetic */ ExecutorService access$getUseUuidExecutor$p(VirtualNodeGattServer $this) {
        return $this.useUuidExecutor;
    }

    public static final /* synthetic */ OnUuidAllocatedListener access$getOnUuidAllocated$p(VirtualNodeGattServer $this) {
        return $this.onUuidAllocated;
    }

    public static final /* synthetic */ int access$getMaxSimultaneousClients$p(VirtualNodeGattServer $this) {
        return $this.maxSimultaneousClients;
    }

    public static final /* synthetic */ boolean access$getStarted$p(VirtualNodeGattServer $this) {
        return $this.started;
    }

    public static final /* synthetic */ void access$openGattServer(VirtualNodeGattServer $this) {
        $this.openGattServer();
    }

    public static final /* synthetic */ void access$closeGattServer(VirtualNodeGattServer $this) {
        $this.closeGattServer();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/bluetooth/VirtualNodeGattServer$DataAcceptRunnable;", "Ljava/lang/Runnable;", "allocatedUuid", "Ljava/util/UUID;", "useUuid", "Lcom/ustadmobile/meshrabiya/server/OnUuidAllocatedListener;", "(Lcom/ustadmobile/meshrabiya/vnet/bluetooth/VirtualNodeGattServer;Ljava/util/UUID;Lcom/ustadmobile/meshrabiya/server/OnUuidAllocatedListener;)V", "run", "", "lib-meshrabiya_debug"})
    private final class DataAcceptRunnable
    implements Runnable {
        @NotNull
        private final UUID allocatedUuid;
        @NotNull
        private final OnUuidAllocatedListener useUuid;

        public DataAcceptRunnable(@NotNull UUID allocatedUuid, OnUuidAllocatedListener useUuid) {
            Intrinsics.checkNotNullParameter((Object)allocatedUuid, (String)"allocatedUuid");
            Intrinsics.checkNotNullParameter((Object)useUuid, (String)"useUuid");
            this.allocatedUuid = allocatedUuid;
            this.useUuid = useUuid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Log.d((String)"Meshrabiya", (String)("Run allocated UUID runnable for " + this.allocatedUuid));
                this.useUuid.invoke(this.allocatedUuid);
            }
            finally {
                VirtualNodeGattServer.this.allocatedUuids.remove(this.allocatedUuid);
            }
        }
    }
}

