/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.meshrabiya.vnet.datagram;

import androidx.core.util.Pools;
import com.ustadmobile.meshrabiya.ext.InetAddressExtKt;
import com.ustadmobile.meshrabiya.ext.IntExtKt;
import com.ustadmobile.meshrabiya.log.MNetLogger;
import com.ustadmobile.meshrabiya.vnet.Protocol;
import com.ustadmobile.meshrabiya.vnet.VirtualPacket;
import com.ustadmobile.meshrabiya.vnet.VirtualPacketHeader;
import com.ustadmobile.meshrabiya.vnet.VirtualRouter;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000 >2\u00020\u0001:\u0001>B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0014J\b\u0010 \u001a\u00020\u001aH\u0014J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020%H\u0015J\b\u0010&\u001a\u00020\u0005H\u0014J\u0012\u0010'\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010\u001eH\u0014J\u001c\u0010)\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0014J\u0012\u0010-\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010\u001eH\u0014J\u001c\u0010.\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0014J\u0015\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b2J\u0010\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u001eH\u0014J\u0012\u00105\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010\u0017H\u0014J\u0010\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u0017H\u0016J\u0010\u00108\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u0017H\u0016J\u001a\u00109\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u00052\b\u0010;\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010<\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020%H\u0015J\u0010\u0010=\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u0005H\u0014R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/datagram/VirtualDatagramSocketImpl;", "Ljava/net/DatagramSocketImpl;", "router", "Lcom/ustadmobile/meshrabiya/vnet/VirtualRouter;", "localVirtualAddress", "", "logger", "Lcom/ustadmobile/meshrabiya/log/MNetLogger;", "(Lcom/ustadmobile/meshrabiya/vnet/VirtualRouter;ILcom/ustadmobile/meshrabiya/log/MNetLogger;)V", "boundPort", "getBoundPort", "()I", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logPrefix", "", "getLogPrefix", "()Ljava/lang/String;", "receiveBufferPool", "Landroidx/core/util/Pools$SynchronizedPool;", "", "receiveQueue", "Ljava/util/concurrent/LinkedBlockingDeque;", "Ljava/net/DatagramPacket;", "sendBufferPool", "assertNotClosed", "", "bind", "lport", "laddr", "Ljava/net/InetAddress;", "close", "create", "getOption", "", "optId", "getTTL", "", "getTimeToLive", "join", "p0", "joinGroup", "Ljava/net/SocketAddress;", "p1", "Ljava/net/NetworkInterface;", "leave", "leaveGroup", "onIncomingPacket", "virtualPacket", "Lcom/ustadmobile/meshrabiya/vnet/VirtualPacket;", "onIncomingPacket$lib_meshrabiya_debug", "peek", "i", "peekData", "receive", "p", "send", "setOption", "optID", "value", "setTTL", "setTimeToLive", "Companion", "lib-meshrabiya_debug"})
public class VirtualDatagramSocketImpl
extends DatagramSocketImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualRouter router;
    private final int localVirtualAddress;
    @NotNull
    private final MNetLogger logger;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final LinkedBlockingDeque<DatagramPacket> receiveQueue;
    @NotNull
    private final Pools.SynchronizedPool<byte[]> receiveBufferPool;
    @NotNull
    private final Pools.SynchronizedPool<byte[]> sendBufferPool;
    public static final int RECEIVE_BUFFER_SIZE = 512;
    public static final int SEND_BUFFER_SIZE = 512;

    public VirtualDatagramSocketImpl(@NotNull VirtualRouter router, int localVirtualAddress, @NotNull MNetLogger logger) {
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.router = router;
        this.localVirtualAddress = localVirtualAddress;
        this.logger = logger;
        this.closed = new AtomicBoolean(false);
        this.receiveQueue = new LinkedBlockingDeque();
        this.receiveBufferPool = new Pools.SynchronizedPool(512);
        this.sendBufferPool = new Pools.SynchronizedPool(512);
    }

    private final String getLogPrefix() {
        return "[VirtualDatagramSocketImpl] ";
    }

    public final int getBoundPort() {
        return this.localPort;
    }

    private final void assertNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("VirtualDatagramSocket assertNotClosed fail: " + this.localPort + " is closed!");
        }
    }

    public final void onIncomingPacket$lib_meshrabiya_debug(@NotNull VirtualPacket virtualPacket) {
        Intrinsics.checkNotNullParameter((Object)virtualPacket, (String)"virtualPacket");
        if (this.closed.get()) {
            return;
        }
        MNetLogger.invoke$default(this.logger, 2, (Function0)new Function0<String>(this, virtualPacket){
            final /* synthetic */ VirtualDatagramSocketImpl this$0;
            final /* synthetic */ VirtualPacket $virtualPacket;
            {
                this.this$0 = $receiver;
                this.$virtualPacket = $virtualPacket;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return VirtualDatagramSocketImpl.access$getLogPrefix(this.this$0) + " incoming virtual packet=" + this.$virtualPacket.getDatagramPacketSize() + " bytes from " + IntExtKt.addressToDotNotation(this.$virtualPacket.getHeader().getFromAddr()) + ":" + this.$virtualPacket.getHeader().getFromPort() + " ";
            }
        }, null, 4, null);
        byte[] byArray = (byte[])this.receiveBufferPool.acquire();
        if (byArray == null) {
            byArray = new byte[1520];
        }
        byte[] buffer = byArray;
        System.arraycopy(virtualPacket.getData(), virtualPacket.getPayloadOffset(), buffer, 20, virtualPacket.getHeader().getPayloadSize());
        DatagramPacket datagramPacket = new DatagramPacket(buffer, 20, virtualPacket.getHeader().getPayloadSize());
        datagramPacket.setAddress(InetAddress.getByAddress(IntExtKt.addressToByteArray(virtualPacket.getHeader().getFromAddr())));
        datagramPacket.setPort(virtualPacket.getHeader().getFromPort());
        datagramPacket.setLength(virtualPacket.getHeader().getPayloadSize());
        this.receiveQueue.put(datagramPacket);
    }

    @Override
    public void setOption(int optID, @Nullable Object value) {
    }

    @Override
    @Nullable
    public Object getOption(int optId) {
        return null;
    }

    @Override
    protected void create() {
    }

    @Override
    public void bind(int lport, @NotNull InetAddress laddr) {
        Intrinsics.checkNotNullParameter((Object)laddr, (String)"laddr");
        MNetLogger.invoke$default(this.logger, 2, (Function0)new Function0<String>(this, laddr, lport){
            final /* synthetic */ VirtualDatagramSocketImpl this$0;
            final /* synthetic */ InetAddress $laddr;
            final /* synthetic */ int $lport;
            {
                this.this$0 = $receiver;
                this.$laddr = $laddr;
                this.$lport = $lport;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return VirtualDatagramSocketImpl.access$getLogPrefix(this.this$0) + " bind laddr=" + this.$laddr + " lport=" + this.$lport;
            }
        }, null, 4, null);
        this.localPort = this.router.allocateUdpPortOrThrow(this, lport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(@NotNull DatagramPacket p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.assertNotClosed();
        MNetLogger.invoke$default(this.logger, 2, (Function0)new Function0<String>(this, p){
            final /* synthetic */ VirtualDatagramSocketImpl this$0;
            final /* synthetic */ DatagramPacket $p;
            {
                this.this$0 = $receiver;
                this.$p = $p;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return VirtualDatagramSocketImpl.access$getLogPrefix(this.this$0) + " send packet size=" + this.$p.getLength() + " bytes to " + this.$p.getAddress() + ":" + this.$p.getPort();
            }
        }, null, 4, null);
        byte[] byArray = (byte[])this.sendBufferPool.acquire();
        if (byArray == null) {
            byArray = new byte[1520];
        }
        byte[] buffer = byArray;
        try {
            System.arraycopy(p.getData(), p.getOffset(), buffer, 20, p.getLength());
            InetAddress inetAddress = p.getAddress();
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"getAddress(...)");
            VirtualPacket virtualPacket = VirtualPacket.Companion.fromHeaderAndPayloadData$default(VirtualPacket.Companion, new VirtualPacketHeader(InetAddressExtKt.requireAddressAsInt(inetAddress), p.getPort(), this.localVirtualAddress, this.localPort, 0, 0, 5, p.getLength()), buffer, 20, false, 8, null);
            VirtualRouter.DefaultImpls.route$default(this.router, virtualPacket, null, null, 6, null);
        }
        finally {
            this.sendBufferPool.release((Object)buffer);
        }
    }

    @Override
    protected int peek(@NotNull InetAddress i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        throw new NotImplementedError(null, 1, null);
    }

    @Override
    protected int peekData(@Nullable DatagramPacket p0) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(@NotNull DatagramPacket p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.assertNotClosed();
        DatagramPacket bufferPacket = this.receiveQueue.take();
        try {
            System.arraycopy(bufferPacket.getData(), bufferPacket.getOffset(), p.getData(), p.getOffset(), bufferPacket.getLength());
            p.setLength(bufferPacket.getLength());
            p.setAddress(bufferPacket.getAddress());
            p.setPort(bufferPacket.getPort());
        }
        finally {
            this.receiveBufferPool.release((Object)bufferPacket.getData());
        }
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    protected void setTTL(byte p0) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    protected byte getTTL() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    protected void setTimeToLive(int p0) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    protected int getTimeToLive() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    protected void join(@Nullable InetAddress p0) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    protected void leave(@Nullable InetAddress p0) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    protected void joinGroup(@Nullable SocketAddress p0, @Nullable NetworkInterface p1) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    protected void leaveGroup(@Nullable SocketAddress p0, @Nullable NetworkInterface p1) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    protected void close() {
        if (!this.closed.getAndSet(true)) {
            this.router.deallocatePort(Protocol.UDP, this.localPort);
        }
    }

    public static final /* synthetic */ String access$getLogPrefix(VirtualDatagramSocketImpl $this) {
        return $this.getLogPrefix();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ustadmobile/meshrabiya/vnet/datagram/VirtualDatagramSocketImpl$Companion;", "", "()V", "RECEIVE_BUFFER_SIZE", "", "SEND_BUFFER_SIZE", "lib-meshrabiya_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

