/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.username;

import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.PersonDao;
import com.ustadmobile.core.domain.filterusername.FilterUsernameUseCase;
import com.ustadmobile.core.username.helper.UsernameErrorException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0086\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/ustadmobile/core/username/UsernameSuggestionUseCase;", "", "filterUsernameUseCase", "Lcom/ustadmobile/core/domain/filterusername/FilterUsernameUseCase;", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "(Lcom/ustadmobile/core/domain/filterusername/FilterUsernameUseCase;Lcom/ustadmobile/core/db/UmAppDatabase;)V", "invoke", "", "name", "Companion", "core_release"})
public final class UsernameSuggestionUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FilterUsernameUseCase filterUsernameUseCase;
    @NotNull
    private final UmAppDatabase db;
    private static final int MAX_ATTEMPTS = 1000;

    public UsernameSuggestionUseCase(@NotNull FilterUsernameUseCase filterUsernameUseCase, @NotNull UmAppDatabase db) {
        Intrinsics.checkNotNullParameter((Object)filterUsernameUseCase, (String)"filterUsernameUseCase");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.filterUsernameUseCase = filterUsernameUseCase;
        this.db = db;
    }

    @NotNull
    public final String invoke(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        PersonDao personDao = this.db.personDao();
        String baseUsername = this.filterUsernameUseCase.invoke(name, "");
        String suggestedUsername = null;
        for (int index = 0; index < 1000; ++index) {
            String string2 = suggestedUsername = index == 0 ? baseUsername : baseUsername + index;
            if (personDao.findByUsername(suggestedUsername) != null) continue;
            return suggestedUsername;
        }
        throw new UsernameErrorException("Unable to generate a unique username");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/core/username/UsernameSuggestionUseCase$Companion;", "", "()V", "MAX_ATTEMPTS", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

