/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.util.ext;

import com.ustadmobile.core.util.ext.InstantExtKt;
import com.ustadmobile.lib.db.entities.DateRangeMoment;
import com.ustadmobile.lib.db.entities.Moment;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.Clock;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.Instant;
import kotlinx.datetime.InstantJvmKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0003\u001a\u0016\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007*\u00020\u0002\u00a8\u0006\b"}, d2={"toDisplayString", "", "Lcom/ustadmobile/lib/db/entities/DateRangeMoment;", "Lcom/ustadmobile/lib/db/entities/Moment;", "toFixedDate", "", "toFixedDatePair", "Lkotlin/Pair;", "core_release"})
public final class DateRangeMomentExtKt {
    @NotNull
    public static final Pair<Long, Long> toFixedDatePair(@NotNull DateRangeMoment $this$toFixedDatePair) {
        Intrinsics.checkNotNullParameter((Object)$this$toFixedDatePair, (String)"<this>");
        long fromDate = DateRangeMomentExtKt.toFixedDate($this$toFixedDatePair.getFromMoment());
        long toDate = DateRangeMomentExtKt.toFixedDate($this$toFixedDatePair.getToMoment());
        return new Pair((Object)fromDate, (Object)toDate);
    }

    public static final long toFixedDate(@NotNull Moment $this$toFixedDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toFixedDate, (String)"<this>");
        if ($this$toFixedDate.getTypeFlag() == 0) {
            return $this$toFixedDate.getFixedTime();
        }
        if ($this$toFixedDate.getRelUnit() == 1 && $this$toFixedDate.getRelOffSet() == 0) {
            return InstantExtKt.toLocalMidnight(Clock.System.INSTANCE.now(), TimeZone.Companion.currentSystemDefault()).toEpochMilliseconds();
        }
        DateTimeUnit.DateBased dateTimeUnit = switch ($this$toFixedDate.getRelUnit()) {
            case 1 -> (DateTimeUnit.DateBased)DateTimeUnit.Companion.getDAY();
            case 3 -> (DateTimeUnit.DateBased)DateTimeUnit.Companion.getMONTH();
            case 2 -> (DateTimeUnit.DateBased)DateTimeUnit.Companion.getWEEK();
            case 4 -> (DateTimeUnit.DateBased)DateTimeUnit.Companion.getYEAR();
            default -> throw new IllegalArgumentException("relUnit not a valid Moment. REL UNIT constnat");
        };
        return InstantJvmKt.minus((Instant)Clock.System.INSTANCE.now(), (int)$this$toFixedDate.getRelOffSet(), (DateTimeUnit)((DateTimeUnit)dateTimeUnit), (TimeZone)TimeZone.Companion.currentSystemDefault()).toEpochMilliseconds();
    }

    @NotNull
    public static final String toDisplayString(@NotNull DateRangeMoment $this$toDisplayString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDisplayString, (String)"<this>");
        Object str = "Custom range: from ";
        str = (String)str + DateRangeMomentExtKt.toDisplayString($this$toDisplayString.getFromMoment());
        str = (String)str + " until " + DateRangeMomentExtKt.toDisplayString($this$toDisplayString.getToMoment());
        return str;
    }

    @NotNull
    public static final String toDisplayString(@NotNull Moment $this$toDisplayString) {
        Intrinsics.checkNotNullParameter((Object)$this$toDisplayString, (String)"<this>");
        Object str = "";
        block0 : switch ($this$toDisplayString.getTypeFlag()) {
            case 0: {
                LocalDateTime dateTime = TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds($this$toDisplayString.getFixedTime()), (TimeZone)TimeZone.Companion.currentSystemDefault());
                str = (String)str + dateTime.getDayOfMonth() + "/" + dateTime.getMonthNumber() + "/" + dateTime.getYear();
                break;
            }
            case 1: {
                if ($this$toDisplayString.getRelUnit() == 1 && $this$toDisplayString.getRelOffSet() == 0) {
                    str = (String)str + "now";
                    break;
                }
                str = (String)str + Math.abs($this$toDisplayString.getRelOffSet());
                switch ($this$toDisplayString.getRelUnit()) {
                    case 1: {
                        str = (String)str + " days ago";
                        break block0;
                    }
                    case 3: {
                        str = (String)str + " months ago";
                        break block0;
                    }
                    case 2: {
                        str = (String)str + " weeks ago";
                        break block0;
                    }
                    case 4: {
                        str = (String)str + " years ago";
                    }
                }
            }
        }
        return str;
    }
}

