/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.domain.backup;

import android.content.Context;
import android.net.Uri;
import com.ustadmobile.core.domain.backup.CommonJvmUnzipFileUseCase;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/core/domain/backup/AndroidUnzipFileUseCase;", "Lcom/ustadmobile/core/domain/backup/CommonJvmUnzipFileUseCase;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getOutputDirectory", "", "openInputStream", "Ljava/io/InputStream;", "path", "core_debug"})
public final class AndroidUnzipFileUseCase
extends CommonJvmUnzipFileUseCase {
    @NotNull
    private final Context context;

    public AndroidUnzipFileUseCase(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @NotNull
    protected InputStream openInputStream(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Uri uri = Uri.parse((String)path);
        InputStream inputStream = this.context.getContentResolver().openInputStream(uri);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to open input stream for URI: " + path);
        }
        return inputStream;
    }

    @Override
    @NotNull
    protected String getOutputDirectory() {
        String string2;
        String string3;
        File file = this.context.getExternalFilesDir(null);
        String string4 = string3 = file != null ? file.getAbsolutePath() : null;
        if (string3 == null) {
            String string5 = this.context.getFilesDir().getAbsolutePath();
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAbsolutePath(...)");
        } else {
            string2 = string3;
        }
        return string2;
    }
}

