package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.ActorUidEtagAndLastMod;
import com.ustadmobile.lib.db.entities.xapi.ActorEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ActorDao_Impl extends ActorDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ActorEntity> __insertionAdapterOfActorEntity;

  private final EntityInsertionAdapter<ActorEntity> __insertionAdapterOfActorEntity_1;

  private final SharedSQLiteStatement __preparedStmtOfUpdateIfNameChanged;

  public ActorDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfActorEntity = new EntityInsertionAdapter<ActorEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `ActorEntity` (`actorUid`,`actorPersonUid`,`actorName`,`actorMbox`,`actorMbox_sha1sum`,`actorOpenid`,`actorAccountName`,`actorAccountHomePage`,`actorEtag`,`actorLct`,`actorObjectType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ActorEntity entity) {
        statement.bindLong(1, entity.getActorUid());
        statement.bindLong(2, entity.getActorPersonUid());
        if (entity.getActorName() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getActorName());
        }
        if (entity.getActorMbox() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getActorMbox());
        }
        if (entity.getActorMbox_sha1sum() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getActorMbox_sha1sum());
        }
        if (entity.getActorOpenid() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getActorOpenid());
        }
        if (entity.getActorAccountName() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getActorAccountName());
        }
        if (entity.getActorAccountHomePage() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getActorAccountHomePage());
        }
        statement.bindLong(9, entity.getActorEtag());
        statement.bindLong(10, entity.getActorLct());
        statement.bindLong(11, entity.getActorObjectType());
      }
    };
    this.__insertionAdapterOfActorEntity_1 = new EntityInsertionAdapter<ActorEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `ActorEntity` (`actorUid`,`actorPersonUid`,`actorName`,`actorMbox`,`actorMbox_sha1sum`,`actorOpenid`,`actorAccountName`,`actorAccountHomePage`,`actorEtag`,`actorLct`,`actorObjectType`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ActorEntity entity) {
        statement.bindLong(1, entity.getActorUid());
        statement.bindLong(2, entity.getActorPersonUid());
        if (entity.getActorName() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getActorName());
        }
        if (entity.getActorMbox() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getActorMbox());
        }
        if (entity.getActorMbox_sha1sum() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getActorMbox_sha1sum());
        }
        if (entity.getActorOpenid() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getActorOpenid());
        }
        if (entity.getActorAccountName() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getActorAccountName());
        }
        if (entity.getActorAccountHomePage() == null) {
          statement.bindNull(8);
        } else {
          statement.bindString(8, entity.getActorAccountHomePage());
        }
        statement.bindLong(9, entity.getActorEtag());
        statement.bindLong(10, entity.getActorLct());
        statement.bindLong(11, entity.getActorObjectType());
      }
    };
    this.__preparedStmtOfUpdateIfNameChanged = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE ActorEntity\n"
                + "           SET actorName = ?,\n"
                + "               actorLct = ?\n"
                + "         WHERE actorUid = ?\n"
                + "           AND ActorEntity.actorName != ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnoreListAsync(final List<ActorEntity> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfActorEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertListAsync(final List<ActorEntity> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfActorEntity_1.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateIfNameChanged(final long uid, final String name, final long updateTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateIfNameChanged.acquire();
        int _argIndex = 1;
        if (name == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, name);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, updateTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, uid);
        _argIndex = 4;
        if (name == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, name);
        }
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateIfNameChanged.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super ActorEntity> $completion) {
    final String _sql = "\n"
            + "        SELECT ActorEntity.*\n"
            + "          FROM ActorEntity\n"
            + "         WHERE ActorEntity.actorUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ActorEntity>() {
      @Override
      @Nullable
      public ActorEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorUid");
          final int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorPersonUid");
          final int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorName");
          final int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox");
          final int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox_sha1sum");
          final int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorOpenid");
          final int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountName");
          final int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountHomePage");
          final int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "actorEtag");
          final int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow(_cursor, "actorLct");
          final int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "actorObjectType");
          final ActorEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpActorUid;
            _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
            final long _tmpActorPersonUid;
            _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
            final String _tmpActorName;
            if (_cursor.isNull(_cursorIndexOfActorName)) {
              _tmpActorName = null;
            } else {
              _tmpActorName = _cursor.getString(_cursorIndexOfActorName);
            }
            final String _tmpActorMbox;
            if (_cursor.isNull(_cursorIndexOfActorMbox)) {
              _tmpActorMbox = null;
            } else {
              _tmpActorMbox = _cursor.getString(_cursorIndexOfActorMbox);
            }
            final String _tmpActorMbox_sha1sum;
            if (_cursor.isNull(_cursorIndexOfActorMboxSha1sum)) {
              _tmpActorMbox_sha1sum = null;
            } else {
              _tmpActorMbox_sha1sum = _cursor.getString(_cursorIndexOfActorMboxSha1sum);
            }
            final String _tmpActorOpenid;
            if (_cursor.isNull(_cursorIndexOfActorOpenid)) {
              _tmpActorOpenid = null;
            } else {
              _tmpActorOpenid = _cursor.getString(_cursorIndexOfActorOpenid);
            }
            final String _tmpActorAccountName;
            if (_cursor.isNull(_cursorIndexOfActorAccountName)) {
              _tmpActorAccountName = null;
            } else {
              _tmpActorAccountName = _cursor.getString(_cursorIndexOfActorAccountName);
            }
            final String _tmpActorAccountHomePage;
            if (_cursor.isNull(_cursorIndexOfActorAccountHomePage)) {
              _tmpActorAccountHomePage = null;
            } else {
              _tmpActorAccountHomePage = _cursor.getString(_cursorIndexOfActorAccountHomePage);
            }
            final long _tmpActorEtag;
            _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
            final long _tmpActorLct;
            _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
            final int _tmpActorObjectType;
            _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
            _result = new ActorEntity(_tmpActorUid,_tmpActorPersonUid,_tmpActorName,_tmpActorMbox,_tmpActorMbox_sha1sum,_tmpActorOpenid,_tmpActorAccountName,_tmpActorAccountHomePage,_tmpActorEtag,_tmpActorLct,_tmpActorObjectType);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAndPersonUidAsync(final long actorUid, final long accountPersonUid,
      final Continuation<? super ActorEntity> $completion) {
    final String _sql = "\n"
            + "        SELECT ActorEntity.*\n"
            + "          FROM ActorEntity\n"
            + "         WHERE ActorEntity.actorUid = ?\n"
            + "           AND ActorEntity.actorPersonUid = ?  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ActorEntity>() {
      @Override
      @Nullable
      public ActorEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorUid");
          final int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorPersonUid");
          final int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorName");
          final int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox");
          final int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox_sha1sum");
          final int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorOpenid");
          final int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountName");
          final int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountHomePage");
          final int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "actorEtag");
          final int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow(_cursor, "actorLct");
          final int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "actorObjectType");
          final ActorEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpActorUid;
            _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
            final long _tmpActorPersonUid;
            _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
            final String _tmpActorName;
            if (_cursor.isNull(_cursorIndexOfActorName)) {
              _tmpActorName = null;
            } else {
              _tmpActorName = _cursor.getString(_cursorIndexOfActorName);
            }
            final String _tmpActorMbox;
            if (_cursor.isNull(_cursorIndexOfActorMbox)) {
              _tmpActorMbox = null;
            } else {
              _tmpActorMbox = _cursor.getString(_cursorIndexOfActorMbox);
            }
            final String _tmpActorMbox_sha1sum;
            if (_cursor.isNull(_cursorIndexOfActorMboxSha1sum)) {
              _tmpActorMbox_sha1sum = null;
            } else {
              _tmpActorMbox_sha1sum = _cursor.getString(_cursorIndexOfActorMboxSha1sum);
            }
            final String _tmpActorOpenid;
            if (_cursor.isNull(_cursorIndexOfActorOpenid)) {
              _tmpActorOpenid = null;
            } else {
              _tmpActorOpenid = _cursor.getString(_cursorIndexOfActorOpenid);
            }
            final String _tmpActorAccountName;
            if (_cursor.isNull(_cursorIndexOfActorAccountName)) {
              _tmpActorAccountName = null;
            } else {
              _tmpActorAccountName = _cursor.getString(_cursorIndexOfActorAccountName);
            }
            final String _tmpActorAccountHomePage;
            if (_cursor.isNull(_cursorIndexOfActorAccountHomePage)) {
              _tmpActorAccountHomePage = null;
            } else {
              _tmpActorAccountHomePage = _cursor.getString(_cursorIndexOfActorAccountHomePage);
            }
            final long _tmpActorEtag;
            _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
            final long _tmpActorLct;
            _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
            final int _tmpActorObjectType;
            _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
            _result = new ActorEntity(_tmpActorUid,_tmpActorPersonUid,_tmpActorName,_tmpActorMbox,_tmpActorMbox_sha1sum,_tmpActorOpenid,_tmpActorAccountName,_tmpActorAccountHomePage,_tmpActorEtag,_tmpActorLct,_tmpActorObjectType);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findUidAndEtagByListAsync(final List<Long> uidList,
      final Continuation<? super List<ActorUidEtagAndLastMod>> $completion) {
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT ActorEntity.actorUid, ActorEntity.actorEtag, ActorEntity.actorLct");
    _stringBuilder.append("\n");
    _stringBuilder.append("          FROM ActorEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("         WHERE ActorEntity.actorUid IN (");
    final int _inputSize = uidList.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (long _item : uidList) {
      _statement.bindLong(_argIndex, _item);
      _argIndex++;
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ActorUidEtagAndLastMod>>() {
      @Override
      @NonNull
      public List<ActorUidEtagAndLastMod> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfActorUid = 0;
          final int _cursorIndexOfActorEtag = 1;
          final int _cursorIndexOfActorLct = 2;
          final List<ActorUidEtagAndLastMod> _result = new ArrayList<ActorUidEtagAndLastMod>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ActorUidEtagAndLastMod _item_1;
            final long _tmpActorUid;
            _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
            final long _tmpActorEtag;
            _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
            final long _tmpActorLct;
            _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
            _item_1 = new ActorUidEtagAndLastMod(_tmpActorUid,_tmpActorEtag,_tmpActorLct);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findGroupMembers(final long groupActorUid,
      final Continuation<? super List<ActorEntity>> $completion) {
    final String _sql = "\n"
            + "        SELECT ActorEntity.*\n"
            + "          FROM ActorEntity\n"
            + "         WHERE ActorEntity.actorUid IN (\n"
            + "               SELECT GroupMemberActorJoin.gmajMemberActorUid\n"
            + "                 FROM GroupMemberActorJoin\n"
            + "                WHERE GroupMemberActorJoin.gmajGroupActorUid = ?\n"
            + "                  AND GroupMemberActorJoin.gmajLastMod = (\n"
            + "                      SELECT GroupActorEntity.actorLct\n"
            + "                        FROM ActorEntity GroupActorEntity\n"
            + "                       WHERE GroupActorEntity.actorUid = ?)\n"
            + "              ) \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, groupActorUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, groupActorUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ActorEntity>>() {
      @Override
      @NonNull
      public List<ActorEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorUid");
          final int _cursorIndexOfActorPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorPersonUid");
          final int _cursorIndexOfActorName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorName");
          final int _cursorIndexOfActorMbox = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox");
          final int _cursorIndexOfActorMboxSha1sum = CursorUtil.getColumnIndexOrThrow(_cursor, "actorMbox_sha1sum");
          final int _cursorIndexOfActorOpenid = CursorUtil.getColumnIndexOrThrow(_cursor, "actorOpenid");
          final int _cursorIndexOfActorAccountName = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountName");
          final int _cursorIndexOfActorAccountHomePage = CursorUtil.getColumnIndexOrThrow(_cursor, "actorAccountHomePage");
          final int _cursorIndexOfActorEtag = CursorUtil.getColumnIndexOrThrow(_cursor, "actorEtag");
          final int _cursorIndexOfActorLct = CursorUtil.getColumnIndexOrThrow(_cursor, "actorLct");
          final int _cursorIndexOfActorObjectType = CursorUtil.getColumnIndexOrThrow(_cursor, "actorObjectType");
          final List<ActorEntity> _result = new ArrayList<ActorEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ActorEntity _item;
            final long _tmpActorUid;
            _tmpActorUid = _cursor.getLong(_cursorIndexOfActorUid);
            final long _tmpActorPersonUid;
            _tmpActorPersonUid = _cursor.getLong(_cursorIndexOfActorPersonUid);
            final String _tmpActorName;
            if (_cursor.isNull(_cursorIndexOfActorName)) {
              _tmpActorName = null;
            } else {
              _tmpActorName = _cursor.getString(_cursorIndexOfActorName);
            }
            final String _tmpActorMbox;
            if (_cursor.isNull(_cursorIndexOfActorMbox)) {
              _tmpActorMbox = null;
            } else {
              _tmpActorMbox = _cursor.getString(_cursorIndexOfActorMbox);
            }
            final String _tmpActorMbox_sha1sum;
            if (_cursor.isNull(_cursorIndexOfActorMboxSha1sum)) {
              _tmpActorMbox_sha1sum = null;
            } else {
              _tmpActorMbox_sha1sum = _cursor.getString(_cursorIndexOfActorMboxSha1sum);
            }
            final String _tmpActorOpenid;
            if (_cursor.isNull(_cursorIndexOfActorOpenid)) {
              _tmpActorOpenid = null;
            } else {
              _tmpActorOpenid = _cursor.getString(_cursorIndexOfActorOpenid);
            }
            final String _tmpActorAccountName;
            if (_cursor.isNull(_cursorIndexOfActorAccountName)) {
              _tmpActorAccountName = null;
            } else {
              _tmpActorAccountName = _cursor.getString(_cursorIndexOfActorAccountName);
            }
            final String _tmpActorAccountHomePage;
            if (_cursor.isNull(_cursorIndexOfActorAccountHomePage)) {
              _tmpActorAccountHomePage = null;
            } else {
              _tmpActorAccountHomePage = _cursor.getString(_cursorIndexOfActorAccountHomePage);
            }
            final long _tmpActorEtag;
            _tmpActorEtag = _cursor.getLong(_cursorIndexOfActorEtag);
            final long _tmpActorLct;
            _tmpActorLct = _cursor.getLong(_cursorIndexOfActorLct);
            final int _tmpActorObjectType;
            _tmpActorObjectType = _cursor.getInt(_cursorIndexOfActorObjectType);
            _item = new ActorEntity(_tmpActorUid,_tmpActorPersonUid,_tmpActorName,_tmpActorMbox,_tmpActorMbox_sha1sum,_tmpActorOpenid,_tmpActorAccountName,_tmpActorAccountHomePage,_tmpActorEtag,_tmpActorLct,_tmpActorObjectType);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
