package com.ustadmobile.core.db.dao.xapi

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.xapi.ActivityEntity
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.collections.List

@Dao
public actual abstract class ActivityEntityDao {
  @Insert(
    onConflict = 5,
    entity = Any::class,
  )
  public actual abstract suspend fun insertOrIgnoreAsync(entities: List<ActivityEntity>)

  @Query(`value` =
      "\n        UPDATE ActivityEntity\n           SET actMoreInfo = :actMoreInfo,\n               actLct = :actLct\n        WHERE actUid = :activityUid\n          AND actMoreInfo != :actMoreInfo      \n    ")
  public actual abstract suspend fun updateIfMoreInfoChanged(
    activityUid: Long,
    actMoreInfo: String?,
    actLct: Long,
  )

  @Query(`value` =
      "\n        UPDATE ActivityEntity\n           SET actType = :actType,\n               actMoreInfo = :actMoreInfo,\n               actInteractionType = :actInteractionType,\n               actCorrectResponsePatterns = :actCorrectResponsePatterns,\n               actLct = :actLct\n         WHERE actUid = :actUid\n           AND (SELECT ActivityEntityInternal.actType \n                  FROM ActivityEntity ActivityEntityInternal \n                 WHERE ActivityEntityInternal.actUid = :actUid) IS NULL\n           AND (SELECT ActivityEntityInternal.actInteractionType \n                  FROM ActivityEntity ActivityEntityInternal \n                 WHERE ActivityEntityInternal.actUid = :actUid) = 0\n           AND (SELECT ActivityEntityInternal.actCorrectResponsePatterns \n                  FROM ActivityEntity ActivityEntityInternal \n                 WHERE ActivityEntityInternal.actUid = :actUid) IS NULL      \n    ")
  public actual abstract suspend fun updateIfNotYetDefined(
    actUid: Long,
    actType: String?,
    actMoreInfo: String?,
    actInteractionType: Int,
    actCorrectResponsePatterns: String?,
    actLct: Long,
  )

  @Query(`value` =
      "\n        SELECT ActivityEntity.*\n          FROM ActivityEntity\n         WHERE ActivityEntity.actUid = :activityUid \n    ")
  public actual abstract suspend fun findByUidAsync(activityUid: Long): ActivityEntity?
}
