package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CacheLockJoin;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CacheLockJoinDao_Impl extends CacheLockJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CacheLockJoin> __insertionAdapterOfCacheLockJoin;

  private final EntityDeletionOrUpdateAdapter<CacheLockJoin> __deletionAdapterOfCacheLockJoin;

  private final SharedSQLiteStatement __preparedStmtOfUpdateLockIdAndStatus;

  public CacheLockJoinDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCacheLockJoin = new EntityInsertionAdapter<CacheLockJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `CacheLockJoin` (`cljId`,`cljTableId`,`cljEntityUid`,`cljUrl`,`cljLockId`,`cljStatus`,`cljType`,`cljOiUid`) VALUES (nullif(?, 0),?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CacheLockJoin entity) {
        statement.bindLong(1, entity.getCljId());
        statement.bindLong(2, entity.getCljTableId());
        statement.bindLong(3, entity.getCljEntityUid());
        if (entity.getCljUrl() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getCljUrl());
        }
        statement.bindLong(5, entity.getCljLockId());
        statement.bindLong(6, entity.getCljStatus());
        statement.bindLong(7, entity.getCljType());
        statement.bindLong(8, entity.getCljOiUid());
      }
    };
    this.__deletionAdapterOfCacheLockJoin = new EntityDeletionOrUpdateAdapter<CacheLockJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "DELETE FROM `CacheLockJoin` WHERE `cljId` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CacheLockJoin entity) {
        statement.bindLong(1, entity.getCljId());
      }
    };
    this.__preparedStmtOfUpdateLockIdAndStatus = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE CacheLockJoin\n"
                + "           SET cljLockId = ?,\n"
                + "               cljStatus = ?\n"
                + "         WHERE cljId = ?   \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertListAsync(final List<CacheLockJoin> list,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCacheLockJoin.insert(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object deleteListAsync(final List<CacheLockJoin> list,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __deletionAdapterOfCacheLockJoin.handleMultiple(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateLockIdAndStatus(final int uid, final long lockId, final int status,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateLockIdAndStatus.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, lockId);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, status);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, uid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateLockIdAndStatus.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findPendingLocks(final Continuation<? super List<CacheLockJoin>> $completion) {
    final String _sql = "\n"
            + "        SELECT CacheLockJoin.*\n"
            + "          FROM CacheLockJoin\n"
            + "         WHERE CacheLockJoin.cljStatus = 1 \n"
            + "            OR CacheLockJoin.cljStatus = 3\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CacheLockJoin>>() {
      @Override
      @NonNull
      public List<CacheLockJoin> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCljId = CursorUtil.getColumnIndexOrThrow(_cursor, "cljId");
          final int _cursorIndexOfCljTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "cljTableId");
          final int _cursorIndexOfCljEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cljEntityUid");
          final int _cursorIndexOfCljUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "cljUrl");
          final int _cursorIndexOfCljLockId = CursorUtil.getColumnIndexOrThrow(_cursor, "cljLockId");
          final int _cursorIndexOfCljStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cljStatus");
          final int _cursorIndexOfCljType = CursorUtil.getColumnIndexOrThrow(_cursor, "cljType");
          final int _cursorIndexOfCljOiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cljOiUid");
          final List<CacheLockJoin> _result = new ArrayList<CacheLockJoin>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CacheLockJoin _item;
            final int _tmpCljId;
            _tmpCljId = _cursor.getInt(_cursorIndexOfCljId);
            final int _tmpCljTableId;
            _tmpCljTableId = _cursor.getInt(_cursorIndexOfCljTableId);
            final long _tmpCljEntityUid;
            _tmpCljEntityUid = _cursor.getLong(_cursorIndexOfCljEntityUid);
            final String _tmpCljUrl;
            if (_cursor.isNull(_cursorIndexOfCljUrl)) {
              _tmpCljUrl = null;
            } else {
              _tmpCljUrl = _cursor.getString(_cursorIndexOfCljUrl);
            }
            final long _tmpCljLockId;
            _tmpCljLockId = _cursor.getLong(_cursorIndexOfCljLockId);
            final int _tmpCljStatus;
            _tmpCljStatus = _cursor.getInt(_cursorIndexOfCljStatus);
            final int _tmpCljType;
            _tmpCljType = _cursor.getInt(_cursorIndexOfCljType);
            final long _tmpCljOiUid;
            _tmpCljOiUid = _cursor.getLong(_cursorIndexOfCljOiUid);
            _item = new CacheLockJoin(_tmpCljId,_tmpCljTableId,_tmpCljEntityUid,_tmpCljUrl,_tmpCljLockId,_tmpCljStatus,_tmpCljType,_tmpCljOiUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByTableIdAndEntityUid(final int tableId, final long entityUid,
      final Continuation<? super List<CacheLockJoin>> $completion) {
    final String _sql = "\n"
            + "        SELECT CacheLockJoin.*\n"
            + "          FROM CacheLockJoin\n"
            + "         WHERE CacheLockJoin.cljTableId = ?\n"
            + "           AND CacheLockJoin.cljEntityUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, tableId);
    _argIndex = 2;
    _statement.bindLong(_argIndex, entityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<CacheLockJoin>>() {
      @Override
      @NonNull
      public List<CacheLockJoin> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfCljId = CursorUtil.getColumnIndexOrThrow(_cursor, "cljId");
          final int _cursorIndexOfCljTableId = CursorUtil.getColumnIndexOrThrow(_cursor, "cljTableId");
          final int _cursorIndexOfCljEntityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cljEntityUid");
          final int _cursorIndexOfCljUrl = CursorUtil.getColumnIndexOrThrow(_cursor, "cljUrl");
          final int _cursorIndexOfCljLockId = CursorUtil.getColumnIndexOrThrow(_cursor, "cljLockId");
          final int _cursorIndexOfCljStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "cljStatus");
          final int _cursorIndexOfCljType = CursorUtil.getColumnIndexOrThrow(_cursor, "cljType");
          final int _cursorIndexOfCljOiUid = CursorUtil.getColumnIndexOrThrow(_cursor, "cljOiUid");
          final List<CacheLockJoin> _result = new ArrayList<CacheLockJoin>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final CacheLockJoin _item;
            final int _tmpCljId;
            _tmpCljId = _cursor.getInt(_cursorIndexOfCljId);
            final int _tmpCljTableId;
            _tmpCljTableId = _cursor.getInt(_cursorIndexOfCljTableId);
            final long _tmpCljEntityUid;
            _tmpCljEntityUid = _cursor.getLong(_cursorIndexOfCljEntityUid);
            final String _tmpCljUrl;
            if (_cursor.isNull(_cursorIndexOfCljUrl)) {
              _tmpCljUrl = null;
            } else {
              _tmpCljUrl = _cursor.getString(_cursorIndexOfCljUrl);
            }
            final long _tmpCljLockId;
            _tmpCljLockId = _cursor.getLong(_cursorIndexOfCljLockId);
            final int _tmpCljStatus;
            _tmpCljStatus = _cursor.getInt(_cursorIndexOfCljStatus);
            final int _tmpCljType;
            _tmpCljType = _cursor.getInt(_cursorIndexOfCljType);
            final long _tmpCljOiUid;
            _tmpCljOiUid = _cursor.getLong(_cursorIndexOfCljOiUid);
            _item = new CacheLockJoin(_tmpCljId,_tmpCljTableId,_tmpCljEntityUid,_tmpCljUrl,_tmpCljLockId,_tmpCljStatus,_tmpCljType,_tmpCljOiUid);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
