package com.ustadmobile.core.db.dao;

import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.CourseBlockPicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CourseBlockPictureDao_Impl extends CourseBlockPictureDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<CourseBlockPicture> __insertionAdapterOfCourseBlockPicture;

  public CourseBlockPictureDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfCourseBlockPicture = new EntityInsertionAdapter<CourseBlockPicture>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `CourseBlockPicture` (`cbpUid`,`cbpLct`,`cbpPictureUri`,`cbpThumbnailUri`) VALUES (?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final CourseBlockPicture entity) {
        statement.bindLong(1, entity.getCbpUid());
        statement.bindLong(2, entity.getCbpLct());
        if (entity.getCbpPictureUri() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getCbpPictureUri());
        }
        if (entity.getCbpThumbnailUri() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getCbpThumbnailUri());
        }
      }
    };
  }

  @Override
  public Object upsertListAsync(final List<CourseBlockPicture> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfCourseBlockPicture.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
