package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.ActivityExtensionEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ActivityExtensionDao_Impl extends ActivityExtensionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ActivityExtensionEntity> __insertionAdapterOfActivityExtensionEntity;

  public ActivityExtensionDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfActivityExtensionEntity = new EntityInsertionAdapter<ActivityExtensionEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `ActivityExtensionEntity` (`aeeActivityUid`,`aeeKeyHash`,`aeeKey`,`aeeJson`,`aeeLastMod`,`aeeIsDeleted`) VALUES (?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ActivityExtensionEntity entity) {
        statement.bindLong(1, entity.getAeeActivityUid());
        statement.bindLong(2, entity.getAeeKeyHash());
        if (entity.getAeeKey() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getAeeKey());
        }
        if (entity.getAeeJson() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getAeeJson());
        }
        statement.bindLong(5, entity.getAeeLastMod());
        final int _tmp = entity.getAeeIsDeleted() ? 1 : 0;
        statement.bindLong(6, _tmp);
      }
    };
  }

  @Override
  public Object upsertListAsync(final List<ActivityExtensionEntity> list,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfActivityExtensionEntity.insert(list);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findAllByActivityUid(final long activityUid,
      final Continuation<? super List<ActivityExtensionEntity>> $completion) {
    final String _sql = "\n"
            + "        SELECT ActivityExtensionEntity.*\n"
            + "          FROM ActivityExtensionEntity\n"
            + "         WHERE ActivityExtensionEntity.aeeActivityUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, activityUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<ActivityExtensionEntity>>() {
      @Override
      @NonNull
      public List<ActivityExtensionEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfAeeActivityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "aeeActivityUid");
          final int _cursorIndexOfAeeKeyHash = CursorUtil.getColumnIndexOrThrow(_cursor, "aeeKeyHash");
          final int _cursorIndexOfAeeKey = CursorUtil.getColumnIndexOrThrow(_cursor, "aeeKey");
          final int _cursorIndexOfAeeJson = CursorUtil.getColumnIndexOrThrow(_cursor, "aeeJson");
          final int _cursorIndexOfAeeLastMod = CursorUtil.getColumnIndexOrThrow(_cursor, "aeeLastMod");
          final int _cursorIndexOfAeeIsDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "aeeIsDeleted");
          final List<ActivityExtensionEntity> _result = new ArrayList<ActivityExtensionEntity>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final ActivityExtensionEntity _item;
            final long _tmpAeeActivityUid;
            _tmpAeeActivityUid = _cursor.getLong(_cursorIndexOfAeeActivityUid);
            final long _tmpAeeKeyHash;
            _tmpAeeKeyHash = _cursor.getLong(_cursorIndexOfAeeKeyHash);
            final String _tmpAeeKey;
            if (_cursor.isNull(_cursorIndexOfAeeKey)) {
              _tmpAeeKey = null;
            } else {
              _tmpAeeKey = _cursor.getString(_cursorIndexOfAeeKey);
            }
            final String _tmpAeeJson;
            if (_cursor.isNull(_cursorIndexOfAeeJson)) {
              _tmpAeeJson = null;
            } else {
              _tmpAeeJson = _cursor.getString(_cursorIndexOfAeeJson);
            }
            final long _tmpAeeLastMod;
            _tmpAeeLastMod = _cursor.getLong(_cursorIndexOfAeeLastMod);
            final boolean _tmpAeeIsDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfAeeIsDeleted);
            _tmpAeeIsDeleted = _tmp != 0;
            _item = new ActivityExtensionEntity(_tmpAeeActivityUid,_tmpAeeKeyHash,_tmpAeeKey,_tmpAeeJson,_tmpAeeLastMod,_tmpAeeIsDeleted);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
