package com.ustadmobile.core.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query
import com.ustadmobile.lib.db.entities.CoursePicture
import kotlin.Any
import kotlin.Long
import kotlin.String

@Dao
public actual abstract class CoursePictureDao : ImageDao {
  @Insert(
    onConflict = 1,
    entity = Any::class,
  )
  public actual abstract suspend fun upsertAsync(coursePicture: CoursePicture)

  @Query(`value` =
      "\n        UPDATE CoursePicture\n           SET coursePictureUri = :uri,\n               coursePictureThumbnailUri = :thumbnailUri,\n               coursePictureLct = :time\n        WHERE coursePictureUid = :uid       \n    ")
  actual abstract override suspend fun updateUri(
    uid: Long,
    uri: String?,
    thumbnailUri: String?,
    time: Long,
  )
}
