package com.ustadmobile.core.db.dao

import com.ustadmobile.door.room.RoomDatabase
import com.ustadmobile.door.util.systemTimeInMillis
import com.ustadmobile.lib.db.entities.PersonAuth2
import kotlin.Long
import kotlin.String
import kotlin.collections.List
import kotlinx.coroutines.flow.Flow

public class PersonAuth2Dao_DoorWrapper(
  private val _db: RoomDatabase,
  private val _dao: PersonAuth2Dao,
) : PersonAuth2Dao() {
  override suspend fun insertListAsync(auths: List<PersonAuth2>) {
    val _generatedPks = mutableListOf<Long>()
    auths.iterator().forEach  {
      it.pauthLct = systemTimeInMillis()
    }
    //must set versionid and/or primary key here
    _dao.insertListAsync(auths)
  }

  override suspend fun insertAsync(auth: PersonAuth2): Long {
    auth.pauthLct = systemTimeInMillis()
    //must set versionid and/or primary key here
    return _dao.insertAsync(auth)
  }

  override suspend fun findByPersonUid(personUid: Long): PersonAuth2? =
      _dao.findByPersonUid(personUid)

  override fun findByPersonUidFlow(personUid: Long): Flow<PersonAuth2?> =
      _dao.findByPersonUidFlow(personUid)

  override suspend fun findByUsername(username: String): PersonAuth2? =
      _dao.findByUsername(username)

  override fun findByUsernames(username: String): Flow<PersonAuth2?> =
      _dao.findByUsernames(username)
}
