package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.paging.PagingSource;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.paging.LimitOffsetPagingSource;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.composites.CommentsAndName;
import com.ustadmobile.lib.db.composites.PersonAndPicture;
import com.ustadmobile.lib.db.entities.Comments;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.PersonPicture;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class CommentsDao_Impl extends CommentsDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Comments> __insertionAdapterOfComments;

  private final SharedSQLiteStatement __preparedStmtOfUpdateDeletedByCommentUid;

  public CommentsDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfComments = new EntityInsertionAdapter<Comments>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `Comments` (`commentsUid`,`commentsText`,`commentsEntityUid`,`commentsStatus`,`commentsFromPersonUid`,`commentsForSubmitterUid`,`commentsFromSubmitterUid`,`commentsFlagged`,`commentsDeleted`,`commentsDateTimeAdded`,`commentsLct`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final Comments entity) {
        statement.bindLong(1, entity.getCommentsUid());
        if (entity.getCommentsText() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getCommentsText());
        }
        statement.bindLong(3, entity.getCommentsEntityUid());
        statement.bindLong(4, entity.getCommentsStatus());
        statement.bindLong(5, entity.getCommentsFromPersonUid());
        statement.bindLong(6, entity.getCommentsForSubmitterUid());
        statement.bindLong(7, entity.getCommentsFromSubmitterUid());
        final int _tmp = entity.getCommentsFlagged() ? 1 : 0;
        statement.bindLong(8, _tmp);
        final int _tmp_1 = entity.getCommentsDeleted() ? 1 : 0;
        statement.bindLong(9, _tmp_1);
        statement.bindLong(10, entity.getCommentsDateTimeAdded());
        statement.bindLong(11, entity.getCommentsLct());
      }
    };
    this.__preparedStmtOfUpdateDeletedByCommentUid = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE Comments \n"
                + "           SET commentsDeleted = ?,\n"
                + "               commentsLct = ?\n"
                + "         WHERE Comments.commentsUid = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final Comments comments, final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfComments.insertAndReturnId(comments);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateDeletedByCommentUid(final long uid, final boolean deleted,
      final long changeTime, final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateDeletedByCommentUid.acquire();
        int _argIndex = 1;
        final int _tmp = deleted ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, changeTime);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, uid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateDeletedByCommentUid.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, CommentsAndName> findPrivateCommentsForUserByAssignmentUid(
      final long accountPersonUid, final long assignmentUid, final boolean includeDeleted) {
    final String _sql = "\n"
            + "        SELECT Comments.*,\n"
            + "               Person.firstNames AS firstNames, \n"
            + "               Person.lastName AS lastName,\n"
            + "               PersonPicture.personPictureThumbnailUri AS pictureUri\n"
            + "          FROM Comments\n"
            + "               LEFT JOIN Person \n"
            + "                    ON Person.personUid = Comments.commentsFromPersonUid\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n"
            + "         WHERE Comments.commentsForSubmitterUid = (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    )\n"
            + "           AND Comments.commentsForSubmitterUid != 0\n"
            + "           AND Comments.commentsEntityUid = ?\n"
            + "           AND (CAST(Comments.commentsDeleted AS INTEGER) = 0 OR CAST(? AS INTEGER) = 1) \n"
            + "      ORDER BY Comments.commentsDateTimeAdded DESC     \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 12);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 12;
    final int _tmp = includeDeleted ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    return new LimitOffsetPagingSource<CommentsAndName>(_statement, __db, "Comments", "Person", "PersonPicture", "ClazzAssignment", "ClazzEnrolment", "CourseGroupMember") {
      @Override
      @NonNull
      protected List<CommentsAndName> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsUid");
        final int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow(cursor, "commentsText");
        final int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityUid");
        final int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow(cursor, "commentsStatus");
        final int _cursorIndexOfCommentsFromPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFromPersonUid");
        final int _cursorIndexOfCommentsForSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsForSubmitterUid");
        final int _cursorIndexOfCommentsFromSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFromSubmitterUid");
        final int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFlagged");
        final int _cursorIndexOfCommentsDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDeleted");
        final int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeAdded");
        final int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLct");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "pictureUri");
        final List<CommentsAndName> _result = new ArrayList<CommentsAndName>(cursor.getCount());
        while (cursor.moveToNext()) {
          final CommentsAndName _item;
          final String _tmpFirstNames;
          if (cursor.isNull(_cursorIndexOfFirstNames)) {
            _tmpFirstNames = null;
          } else {
            _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
          }
          final String _tmpLastName;
          if (cursor.isNull(_cursorIndexOfLastName)) {
            _tmpLastName = null;
          } else {
            _tmpLastName = cursor.getString(_cursorIndexOfLastName);
          }
          final String _tmpPictureUri;
          if (cursor.isNull(_cursorIndexOfPictureUri)) {
            _tmpPictureUri = null;
          } else {
            _tmpPictureUri = cursor.getString(_cursorIndexOfPictureUri);
          }
          final Comments _tmpComment;
          final long _tmpCommentsUid;
          _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
          final String _tmpCommentsText;
          if (cursor.isNull(_cursorIndexOfCommentsText)) {
            _tmpCommentsText = null;
          } else {
            _tmpCommentsText = cursor.getString(_cursorIndexOfCommentsText);
          }
          final long _tmpCommentsEntityUid;
          _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
          final int _tmpCommentsStatus;
          _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
          final long _tmpCommentsFromPersonUid;
          _tmpCommentsFromPersonUid = cursor.getLong(_cursorIndexOfCommentsFromPersonUid);
          final long _tmpCommentsForSubmitterUid;
          _tmpCommentsForSubmitterUid = cursor.getLong(_cursorIndexOfCommentsForSubmitterUid);
          final long _tmpCommentsFromSubmitterUid;
          _tmpCommentsFromSubmitterUid = cursor.getLong(_cursorIndexOfCommentsFromSubmitterUid);
          final boolean _tmpCommentsFlagged;
          final int _tmp_1;
          _tmp_1 = cursor.getInt(_cursorIndexOfCommentsFlagged);
          _tmpCommentsFlagged = _tmp_1 != 0;
          final boolean _tmpCommentsDeleted;
          final int _tmp_2;
          _tmp_2 = cursor.getInt(_cursorIndexOfCommentsDeleted);
          _tmpCommentsDeleted = _tmp_2 != 0;
          final long _tmpCommentsDateTimeAdded;
          _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
          final long _tmpCommentsLct;
          _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
          _tmpComment = new Comments(_tmpCommentsUid,_tmpCommentsText,_tmpCommentsEntityUid,_tmpCommentsStatus,_tmpCommentsFromPersonUid,_tmpCommentsForSubmitterUid,_tmpCommentsFromSubmitterUid,_tmpCommentsFlagged,_tmpCommentsDeleted,_tmpCommentsDateTimeAdded,_tmpCommentsLct);
          _item = new CommentsAndName(_tmpComment,_tmpFirstNames,_tmpLastName,_tmpPictureUri);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object findPrivateCommentsForUserByAssignmentUidPersons(final long accountPersonUid,
      final long assignmentUid, final Continuation<? super List<PersonAndPicture>> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE Person.personUid IN\n"
            + "               (SELECT DISTINCT Comments.commentsFromPersonUid\n"
            + "                  FROM Comments\n"
            + "                 WHERE Comments.commentsForSubmitterUid = (\n"
            + "        SELECT CASE\n"
            + "                    -- When assignment is individual then the submitter uid is the personuid if they are enrolled in the course otherwise zero \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) = 0\n"
            + "                         THEN (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    )\n"
            + "                    -- When assignment is by groups but the active user is not an enrolled student then the submitter uid is zero     \n"
            + "                    WHEN (SELECT caGroupUid\n"
            + "                            FROM ClazzAssignment\n"
            + "                           WHERE caUid = ?) != 0\n"
            + "                          AND (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) = 0\n"
            + "                          THEN 0\n"
            + "                    -- When assignment is by groups and the person is an enrolled student the submitter uid is the \n"
            + "                    -- group that they are assigned to. If they are not assigned to a group but are enrolled\n"
            + "                    -- then we submitter uid = SUBMITTER_ENROLLED_BUT_NOT_IN_GROUP\n"
            + "                    ELSE COALESCE(\n"
            + "                          (SELECT CourseGroupMember.cgmGroupNumber\n"
            + "                             FROM CourseGroupMember\n"
            + "                            WHERE (\n"
            + "        SELECT COALESCE(\n"
            + "                (SELECT ClazzEnrolment.clazzEnrolmentPersonUid\n"
            + "                   FROM ClazzEnrolment\n"
            + "                  WHERE ClazzEnrolment.clazzEnrolmentPersonUid = ?\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentRole = 1000\n"
            + "                    AND ClazzEnrolment.clazzEnrolmentClazzUid = \n"
            + "                        (SELECT ClazzAssignment.caClazzUid\n"
            + "                           FROM ClazzAssignment\n"
            + "                          WHERE ClazzAssignment.caUid = ?)\n"
            + "                  LIMIT 1), 0)\n"
            + "    ) > 0\n"
            + "                              AND CourseGroupMember.cgmSetUid = \n"
            + "                                  (SELECT caGroupUid\n"
            + "                                     FROM ClazzAssignment\n"
            + "                                    WHERE caUid = ?)\n"
            + "                              AND CourseGroupMember.cgmPersonUid = ?\n"
            + "                            LIMIT 1), -1)\n"
            + "                    END\n"
            + "    )\n"
            + "                   AND Comments.commentsForSubmitterUid != 0\n"
            + "                   AND Comments.commentsEntityUid = ?\n"
            + "                   AND CAST(Comments.commentsDeleted AS INTEGER) = 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 11);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 7;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 8;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 9;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 10;
    _statement.bindLong(_argIndex, accountPersonUid);
    _argIndex = 11;
    _statement.bindLong(_argIndex, assignmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<PersonAndPicture>>() {
      @Override
      @NonNull
      public List<PersonAndPicture> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
          final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
          final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
          final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
          final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
          final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
          final List<PersonAndPicture> _result = new ArrayList<PersonAndPicture>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final PersonAndPicture _item;
            final Person _tmpPerson;
            if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
              final long _tmpPersonUid;
              _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
              final String _tmpUsername;
              if (_cursor.isNull(_cursorIndexOfUsername)) {
                _tmpUsername = null;
              } else {
                _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
              }
              final String _tmpFirstNames;
              if (_cursor.isNull(_cursorIndexOfFirstNames)) {
                _tmpFirstNames = null;
              } else {
                _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
              }
              final String _tmpLastName;
              if (_cursor.isNull(_cursorIndexOfLastName)) {
                _tmpLastName = null;
              } else {
                _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
              }
              final String _tmpEmailAddr;
              if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
                _tmpEmailAddr = null;
              } else {
                _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
              }
              final String _tmpPhoneNum;
              if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
                _tmpPhoneNum = null;
              } else {
                _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
              }
              final int _tmpGender;
              _tmpGender = _cursor.getInt(_cursorIndexOfGender);
              final boolean _tmpActive;
              final int _tmp;
              _tmp = _cursor.getInt(_cursorIndexOfActive);
              _tmpActive = _tmp != 0;
              final boolean _tmpIsPersonalAccount;
              final int _tmp_1;
              _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
              _tmpIsPersonalAccount = _tmp_1 != 0;
              final long _tmpDateOfBirth;
              _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
              final String _tmpPersonAddress;
              if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
                _tmpPersonAddress = null;
              } else {
                _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
              }
              final String _tmpPersonOrgId;
              if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
                _tmpPersonOrgId = null;
              } else {
                _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
              }
              final long _tmpPersonGroupUid;
              _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
              final long _tmpPersonLct;
              _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
              final String _tmpPersonCountry;
              if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
                _tmpPersonCountry = null;
              } else {
                _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
              }
              final int _tmpPersonType;
              _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
              final long _tmpPersonMasterChangeSeqNum;
              _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
              final long _tmpPersonLocalChangeSeqNum;
              _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
              final int _tmpPersonLastChangedBy;
              _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
              final boolean _tmpAdmin;
              final int _tmp_2;
              _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
              _tmpAdmin = _tmp_2 != 0;
              final String _tmpPersonNotes;
              if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
                _tmpPersonNotes = null;
              } else {
                _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
              }
              final String _tmpFatherName;
              if (_cursor.isNull(_cursorIndexOfFatherName)) {
                _tmpFatherName = null;
              } else {
                _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
              }
              final String _tmpFatherNumber;
              if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
                _tmpFatherNumber = null;
              } else {
                _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
              }
              final String _tmpMotherName;
              if (_cursor.isNull(_cursorIndexOfMotherName)) {
                _tmpMotherName = null;
              } else {
                _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
              }
              final String _tmpMotherNum;
              if (_cursor.isNull(_cursorIndexOfMotherNum)) {
                _tmpMotherNum = null;
              } else {
                _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
              }
              _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            } else {
              _tmpPerson = null;
            }
            final PersonPicture _tmpPicture;
            if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
              final long _tmpPersonPictureUid;
              _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
              final long _tmpPersonPictureLct;
              _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
              final String _tmpPersonPictureUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
                _tmpPersonPictureUri = null;
              } else {
                _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
              }
              final String _tmpPersonPictureThumbnailUri;
              if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
                _tmpPersonPictureThumbnailUri = null;
              } else {
                _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
              }
              final int _tmpFileSize;
              _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
              final boolean _tmpPersonPictureActive;
              final int _tmp_3;
              _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
              _tmpPersonPictureActive = _tmp_3 != 0;
              _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
            } else {
              _tmpPicture = null;
            }
            _item = new PersonAndPicture(_tmpPerson,_tmpPicture);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public PagingSource<Integer, CommentsAndName> findPrivateCommentsForSubmitterByAssignmentUid(
      final long submitterUid, final long assignmentUid, final boolean includeDeleted) {
    final String _sql = "\n"
            + "        SELECT Comments.*,\n"
            + "               Person.firstNames AS firstNames, \n"
            + "               Person.lastName AS lastName,\n"
            + "               PersonPicture.personPictureThumbnailUri AS pictureUri\n"
            + "          FROM Comments\n"
            + "               LEFT JOIN Person \n"
            + "                    ON Person.personUid = Comments.commentsFromPersonUid\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n"
            + "         WHERE Comments.commentsForSubmitterUid = ?\n"
            + "           AND Comments.commentsEntityUid = ?\n"
            + "           AND (NOT Comments.commentsDeleted OR CAST(? AS INTEGER) = 1)\n"
            + "      ORDER BY Comments.commentsDateTimeAdded DESC        \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 3;
    final int _tmp = includeDeleted ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    return new LimitOffsetPagingSource<CommentsAndName>(_statement, __db, "Comments", "Person", "PersonPicture") {
      @Override
      @NonNull
      protected List<CommentsAndName> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsUid");
        final int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow(cursor, "commentsText");
        final int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityUid");
        final int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow(cursor, "commentsStatus");
        final int _cursorIndexOfCommentsFromPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFromPersonUid");
        final int _cursorIndexOfCommentsForSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsForSubmitterUid");
        final int _cursorIndexOfCommentsFromSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFromSubmitterUid");
        final int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFlagged");
        final int _cursorIndexOfCommentsDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDeleted");
        final int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeAdded");
        final int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLct");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "pictureUri");
        final List<CommentsAndName> _result = new ArrayList<CommentsAndName>(cursor.getCount());
        while (cursor.moveToNext()) {
          final CommentsAndName _item;
          final String _tmpFirstNames;
          if (cursor.isNull(_cursorIndexOfFirstNames)) {
            _tmpFirstNames = null;
          } else {
            _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
          }
          final String _tmpLastName;
          if (cursor.isNull(_cursorIndexOfLastName)) {
            _tmpLastName = null;
          } else {
            _tmpLastName = cursor.getString(_cursorIndexOfLastName);
          }
          final String _tmpPictureUri;
          if (cursor.isNull(_cursorIndexOfPictureUri)) {
            _tmpPictureUri = null;
          } else {
            _tmpPictureUri = cursor.getString(_cursorIndexOfPictureUri);
          }
          final Comments _tmpComment;
          final long _tmpCommentsUid;
          _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
          final String _tmpCommentsText;
          if (cursor.isNull(_cursorIndexOfCommentsText)) {
            _tmpCommentsText = null;
          } else {
            _tmpCommentsText = cursor.getString(_cursorIndexOfCommentsText);
          }
          final long _tmpCommentsEntityUid;
          _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
          final int _tmpCommentsStatus;
          _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
          final long _tmpCommentsFromPersonUid;
          _tmpCommentsFromPersonUid = cursor.getLong(_cursorIndexOfCommentsFromPersonUid);
          final long _tmpCommentsForSubmitterUid;
          _tmpCommentsForSubmitterUid = cursor.getLong(_cursorIndexOfCommentsForSubmitterUid);
          final long _tmpCommentsFromSubmitterUid;
          _tmpCommentsFromSubmitterUid = cursor.getLong(_cursorIndexOfCommentsFromSubmitterUid);
          final boolean _tmpCommentsFlagged;
          final int _tmp_1;
          _tmp_1 = cursor.getInt(_cursorIndexOfCommentsFlagged);
          _tmpCommentsFlagged = _tmp_1 != 0;
          final boolean _tmpCommentsDeleted;
          final int _tmp_2;
          _tmp_2 = cursor.getInt(_cursorIndexOfCommentsDeleted);
          _tmpCommentsDeleted = _tmp_2 != 0;
          final long _tmpCommentsDateTimeAdded;
          _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
          final long _tmpCommentsLct;
          _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
          _tmpComment = new Comments(_tmpCommentsUid,_tmpCommentsText,_tmpCommentsEntityUid,_tmpCommentsStatus,_tmpCommentsFromPersonUid,_tmpCommentsForSubmitterUid,_tmpCommentsFromSubmitterUid,_tmpCommentsFlagged,_tmpCommentsDeleted,_tmpCommentsDateTimeAdded,_tmpCommentsLct);
          _item = new CommentsAndName(_tmpComment,_tmpFirstNames,_tmpLastName,_tmpPictureUri);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public List<PersonAndPicture> findPrivateCommentsForSubmitterByAssignmentUidPersons(
      final long submitterUid, final long assignmentUid) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid \n"
            + "         WHERE Person.personUid IN \n"
            + "               (SELECT Comments.commentsFromPersonUid\n"
            + "                  FROM Comments\n"
            + "                 WHERE Comments.commentsForSubmitterUid = ?\n"
            + "                   AND Comments.commentsEntityUid = ?\n"
            + "                   AND NOT Comments.commentsDeleted) \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, submitterUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, assignmentUid);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
      final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
      final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
      final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
      final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
      final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
      final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
      final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
      final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
      final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
      final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
      final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
      final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
      final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
      final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
      final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
      final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
      final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
      final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
      final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
      final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
      final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
      final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
      final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
      final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
      final int _cursorIndexOfPersonPictureUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUid");
      final int _cursorIndexOfPersonPictureLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureLct");
      final int _cursorIndexOfPersonPictureUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureUri");
      final int _cursorIndexOfPersonPictureThumbnailUri = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureThumbnailUri");
      final int _cursorIndexOfFileSize = CursorUtil.getColumnIndexOrThrow(_cursor, "fileSize");
      final int _cursorIndexOfPersonPictureActive = CursorUtil.getColumnIndexOrThrow(_cursor, "personPictureActive");
      final List<PersonAndPicture> _result = new ArrayList<PersonAndPicture>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final PersonAndPicture _item;
        final Person _tmpPerson;
        if (!(_cursor.isNull(_cursorIndexOfPersonUid) && _cursor.isNull(_cursorIndexOfUsername) && _cursor.isNull(_cursorIndexOfFirstNames) && _cursor.isNull(_cursorIndexOfLastName) && _cursor.isNull(_cursorIndexOfEmailAddr) && _cursor.isNull(_cursorIndexOfPhoneNum) && _cursor.isNull(_cursorIndexOfGender) && _cursor.isNull(_cursorIndexOfActive) && _cursor.isNull(_cursorIndexOfIsPersonalAccount) && _cursor.isNull(_cursorIndexOfDateOfBirth) && _cursor.isNull(_cursorIndexOfPersonAddress) && _cursor.isNull(_cursorIndexOfPersonOrgId) && _cursor.isNull(_cursorIndexOfPersonGroupUid) && _cursor.isNull(_cursorIndexOfPersonLct) && _cursor.isNull(_cursorIndexOfPersonCountry) && _cursor.isNull(_cursorIndexOfPersonType) && _cursor.isNull(_cursorIndexOfPersonMasterChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLocalChangeSeqNum) && _cursor.isNull(_cursorIndexOfPersonLastChangedBy) && _cursor.isNull(_cursorIndexOfAdmin) && _cursor.isNull(_cursorIndexOfPersonNotes) && _cursor.isNull(_cursorIndexOfFatherName) && _cursor.isNull(_cursorIndexOfFatherNumber) && _cursor.isNull(_cursorIndexOfMotherName) && _cursor.isNull(_cursorIndexOfMotherNum))) {
          final long _tmpPersonUid;
          _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
          final String _tmpUsername;
          if (_cursor.isNull(_cursorIndexOfUsername)) {
            _tmpUsername = null;
          } else {
            _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
          }
          final String _tmpFirstNames;
          if (_cursor.isNull(_cursorIndexOfFirstNames)) {
            _tmpFirstNames = null;
          } else {
            _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
          }
          final String _tmpLastName;
          if (_cursor.isNull(_cursorIndexOfLastName)) {
            _tmpLastName = null;
          } else {
            _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
          }
          final String _tmpEmailAddr;
          if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
            _tmpEmailAddr = null;
          } else {
            _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
          }
          final String _tmpPhoneNum;
          if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
            _tmpPhoneNum = null;
          } else {
            _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
          }
          final int _tmpGender;
          _tmpGender = _cursor.getInt(_cursorIndexOfGender);
          final boolean _tmpActive;
          final int _tmp;
          _tmp = _cursor.getInt(_cursorIndexOfActive);
          _tmpActive = _tmp != 0;
          final boolean _tmpIsPersonalAccount;
          final int _tmp_1;
          _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
          _tmpIsPersonalAccount = _tmp_1 != 0;
          final long _tmpDateOfBirth;
          _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
          final String _tmpPersonAddress;
          if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
            _tmpPersonAddress = null;
          } else {
            _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
          }
          final String _tmpPersonOrgId;
          if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
            _tmpPersonOrgId = null;
          } else {
            _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
          }
          final long _tmpPersonGroupUid;
          _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
          final long _tmpPersonLct;
          _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
          final String _tmpPersonCountry;
          if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
            _tmpPersonCountry = null;
          } else {
            _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
          }
          final int _tmpPersonType;
          _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
          final long _tmpPersonMasterChangeSeqNum;
          _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
          final long _tmpPersonLocalChangeSeqNum;
          _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
          final int _tmpPersonLastChangedBy;
          _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
          final boolean _tmpAdmin;
          final int _tmp_2;
          _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
          _tmpAdmin = _tmp_2 != 0;
          final String _tmpPersonNotes;
          if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
            _tmpPersonNotes = null;
          } else {
            _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
          }
          final String _tmpFatherName;
          if (_cursor.isNull(_cursorIndexOfFatherName)) {
            _tmpFatherName = null;
          } else {
            _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
          }
          final String _tmpFatherNumber;
          if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
            _tmpFatherNumber = null;
          } else {
            _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
          }
          final String _tmpMotherName;
          if (_cursor.isNull(_cursorIndexOfMotherName)) {
            _tmpMotherName = null;
          } else {
            _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
          }
          final String _tmpMotherNum;
          if (_cursor.isNull(_cursorIndexOfMotherNum)) {
            _tmpMotherNum = null;
          } else {
            _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
          }
          _tmpPerson = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
        } else {
          _tmpPerson = null;
        }
        final PersonPicture _tmpPicture;
        if (!(_cursor.isNull(_cursorIndexOfPersonPictureUid) && _cursor.isNull(_cursorIndexOfPersonPictureLct) && _cursor.isNull(_cursorIndexOfPersonPictureUri) && _cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri) && _cursor.isNull(_cursorIndexOfFileSize) && _cursor.isNull(_cursorIndexOfPersonPictureActive))) {
          final long _tmpPersonPictureUid;
          _tmpPersonPictureUid = _cursor.getLong(_cursorIndexOfPersonPictureUid);
          final long _tmpPersonPictureLct;
          _tmpPersonPictureLct = _cursor.getLong(_cursorIndexOfPersonPictureLct);
          final String _tmpPersonPictureUri;
          if (_cursor.isNull(_cursorIndexOfPersonPictureUri)) {
            _tmpPersonPictureUri = null;
          } else {
            _tmpPersonPictureUri = _cursor.getString(_cursorIndexOfPersonPictureUri);
          }
          final String _tmpPersonPictureThumbnailUri;
          if (_cursor.isNull(_cursorIndexOfPersonPictureThumbnailUri)) {
            _tmpPersonPictureThumbnailUri = null;
          } else {
            _tmpPersonPictureThumbnailUri = _cursor.getString(_cursorIndexOfPersonPictureThumbnailUri);
          }
          final int _tmpFileSize;
          _tmpFileSize = _cursor.getInt(_cursorIndexOfFileSize);
          final boolean _tmpPersonPictureActive;
          final int _tmp_3;
          _tmp_3 = _cursor.getInt(_cursorIndexOfPersonPictureActive);
          _tmpPersonPictureActive = _tmp_3 != 0;
          _tmpPicture = new PersonPicture(_tmpPersonPictureUid,_tmpPersonPictureLct,_tmpPersonPictureUri,_tmpPersonPictureThumbnailUri,_tmpFileSize,_tmpPersonPictureActive);
        } else {
          _tmpPicture = null;
        }
        _item = new PersonAndPicture(_tmpPerson,_tmpPicture);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public PagingSource<Integer, CommentsAndName> findCourseCommentsByAssignmentUid(
      final long assignmentUid, final boolean includeDeleted) {
    final String _sql = "\n"
            + "        SELECT Comments.*,\n"
            + "               Person.firstNames AS firstNames, \n"
            + "               Person.lastName AS lastName,\n"
            + "               PersonPicture.personPictureThumbnailUri AS pictureUri\n"
            + "          FROM Comments\n"
            + "               LEFT JOIN Person \n"
            + "                    ON Person.personUid = Comments.commentsFromPersonUid\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                    ON PersonPicture.personPictureUid = Comments.commentsFromPersonUid\n"
            + "         WHERE Comments.commentsEntityUid = ?\n"
            + "           AND Comments.commentsForSubmitterUid = 0\n"
            + "           AND (CAST(Comments.commentsDeleted AS INTEGER) = 0 OR CAST(? AS INTEGER) = 1)\n"
            + "      ORDER BY Comments.commentsDateTimeAdded DESC     \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    _argIndex = 2;
    final int _tmp = includeDeleted ? 1 : 0;
    _statement.bindLong(_argIndex, _tmp);
    return new LimitOffsetPagingSource<CommentsAndName>(_statement, __db, "Comments", "Person", "PersonPicture") {
      @Override
      @NonNull
      protected List<CommentsAndName> convertRows(@NonNull final Cursor cursor) {
        final int _cursorIndexOfCommentsUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsUid");
        final int _cursorIndexOfCommentsText = CursorUtil.getColumnIndexOrThrow(cursor, "commentsText");
        final int _cursorIndexOfCommentsEntityUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsEntityUid");
        final int _cursorIndexOfCommentsStatus = CursorUtil.getColumnIndexOrThrow(cursor, "commentsStatus");
        final int _cursorIndexOfCommentsFromPersonUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFromPersonUid");
        final int _cursorIndexOfCommentsForSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsForSubmitterUid");
        final int _cursorIndexOfCommentsFromSubmitterUid = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFromSubmitterUid");
        final int _cursorIndexOfCommentsFlagged = CursorUtil.getColumnIndexOrThrow(cursor, "commentsFlagged");
        final int _cursorIndexOfCommentsDeleted = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDeleted");
        final int _cursorIndexOfCommentsDateTimeAdded = CursorUtil.getColumnIndexOrThrow(cursor, "commentsDateTimeAdded");
        final int _cursorIndexOfCommentsLct = CursorUtil.getColumnIndexOrThrow(cursor, "commentsLct");
        final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(cursor, "firstNames");
        final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(cursor, "lastName");
        final int _cursorIndexOfPictureUri = CursorUtil.getColumnIndexOrThrow(cursor, "pictureUri");
        final List<CommentsAndName> _result = new ArrayList<CommentsAndName>(cursor.getCount());
        while (cursor.moveToNext()) {
          final CommentsAndName _item;
          final String _tmpFirstNames;
          if (cursor.isNull(_cursorIndexOfFirstNames)) {
            _tmpFirstNames = null;
          } else {
            _tmpFirstNames = cursor.getString(_cursorIndexOfFirstNames);
          }
          final String _tmpLastName;
          if (cursor.isNull(_cursorIndexOfLastName)) {
            _tmpLastName = null;
          } else {
            _tmpLastName = cursor.getString(_cursorIndexOfLastName);
          }
          final String _tmpPictureUri;
          if (cursor.isNull(_cursorIndexOfPictureUri)) {
            _tmpPictureUri = null;
          } else {
            _tmpPictureUri = cursor.getString(_cursorIndexOfPictureUri);
          }
          final Comments _tmpComment;
          final long _tmpCommentsUid;
          _tmpCommentsUid = cursor.getLong(_cursorIndexOfCommentsUid);
          final String _tmpCommentsText;
          if (cursor.isNull(_cursorIndexOfCommentsText)) {
            _tmpCommentsText = null;
          } else {
            _tmpCommentsText = cursor.getString(_cursorIndexOfCommentsText);
          }
          final long _tmpCommentsEntityUid;
          _tmpCommentsEntityUid = cursor.getLong(_cursorIndexOfCommentsEntityUid);
          final int _tmpCommentsStatus;
          _tmpCommentsStatus = cursor.getInt(_cursorIndexOfCommentsStatus);
          final long _tmpCommentsFromPersonUid;
          _tmpCommentsFromPersonUid = cursor.getLong(_cursorIndexOfCommentsFromPersonUid);
          final long _tmpCommentsForSubmitterUid;
          _tmpCommentsForSubmitterUid = cursor.getLong(_cursorIndexOfCommentsForSubmitterUid);
          final long _tmpCommentsFromSubmitterUid;
          _tmpCommentsFromSubmitterUid = cursor.getLong(_cursorIndexOfCommentsFromSubmitterUid);
          final boolean _tmpCommentsFlagged;
          final int _tmp_1;
          _tmp_1 = cursor.getInt(_cursorIndexOfCommentsFlagged);
          _tmpCommentsFlagged = _tmp_1 != 0;
          final boolean _tmpCommentsDeleted;
          final int _tmp_2;
          _tmp_2 = cursor.getInt(_cursorIndexOfCommentsDeleted);
          _tmpCommentsDeleted = _tmp_2 != 0;
          final long _tmpCommentsDateTimeAdded;
          _tmpCommentsDateTimeAdded = cursor.getLong(_cursorIndexOfCommentsDateTimeAdded);
          final long _tmpCommentsLct;
          _tmpCommentsLct = cursor.getLong(_cursorIndexOfCommentsLct);
          _tmpComment = new Comments(_tmpCommentsUid,_tmpCommentsText,_tmpCommentsEntityUid,_tmpCommentsStatus,_tmpCommentsFromPersonUid,_tmpCommentsForSubmitterUid,_tmpCommentsFromSubmitterUid,_tmpCommentsFlagged,_tmpCommentsDeleted,_tmpCommentsDateTimeAdded,_tmpCommentsLct);
          _item = new CommentsAndName(_tmpComment,_tmpFirstNames,_tmpLastName,_tmpPictureUri);
          _result.add(_item);
        }
        return _result;
      }
    };
  }

  @Override
  public Object findCourseCommentsByAssignmentUidPersons(final long assignmentUid,
      final Continuation<? super List<Person>> $completion) {
    final String _sql = "\n"
            + "        SELECT Person.*, PersonPicture.*\n"
            + "          FROM Person\n"
            + "               LEFT JOIN PersonPicture\n"
            + "                         ON PersonPicture.personPictureUid = Person.personUid\n"
            + "         WHERE Person.personUid IN\n"
            + "               (SELECT DISTINCT Comments.commentsFromPersonUid\n"
            + "                  FROM Comments\n"
            + "                       LEFT JOIN Person \n"
            + "                            ON Person.personUid = Comments.commentsFromPersonUid\n"
            + "                 WHERE Comments.commentsEntityUid = ?\n"
            + "                   AND Comments.commentsForSubmitterUid = 0)\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, assignmentUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<Person>>() {
      @Override
      @NonNull
      public List<Person> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personUid");
          final int _cursorIndexOfUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "username");
          final int _cursorIndexOfFirstNames = CursorUtil.getColumnIndexOrThrow(_cursor, "firstNames");
          final int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow(_cursor, "lastName");
          final int _cursorIndexOfEmailAddr = CursorUtil.getColumnIndexOrThrow(_cursor, "emailAddr");
          final int _cursorIndexOfPhoneNum = CursorUtil.getColumnIndexOrThrow(_cursor, "phoneNum");
          final int _cursorIndexOfGender = CursorUtil.getColumnIndexOrThrow(_cursor, "gender");
          final int _cursorIndexOfActive = CursorUtil.getColumnIndexOrThrow(_cursor, "active");
          final int _cursorIndexOfIsPersonalAccount = CursorUtil.getColumnIndexOrThrow(_cursor, "isPersonalAccount");
          final int _cursorIndexOfDateOfBirth = CursorUtil.getColumnIndexOrThrow(_cursor, "dateOfBirth");
          final int _cursorIndexOfPersonAddress = CursorUtil.getColumnIndexOrThrow(_cursor, "personAddress");
          final int _cursorIndexOfPersonOrgId = CursorUtil.getColumnIndexOrThrow(_cursor, "personOrgId");
          final int _cursorIndexOfPersonGroupUid = CursorUtil.getColumnIndexOrThrow(_cursor, "personGroupUid");
          final int _cursorIndexOfPersonLct = CursorUtil.getColumnIndexOrThrow(_cursor, "personLct");
          final int _cursorIndexOfPersonCountry = CursorUtil.getColumnIndexOrThrow(_cursor, "personCountry");
          final int _cursorIndexOfPersonType = CursorUtil.getColumnIndexOrThrow(_cursor, "personType");
          final int _cursorIndexOfPersonMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personMasterChangeSeqNum");
          final int _cursorIndexOfPersonLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "personLocalChangeSeqNum");
          final int _cursorIndexOfPersonLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "personLastChangedBy");
          final int _cursorIndexOfAdmin = CursorUtil.getColumnIndexOrThrow(_cursor, "admin");
          final int _cursorIndexOfPersonNotes = CursorUtil.getColumnIndexOrThrow(_cursor, "personNotes");
          final int _cursorIndexOfFatherName = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherName");
          final int _cursorIndexOfFatherNumber = CursorUtil.getColumnIndexOrThrow(_cursor, "fatherNumber");
          final int _cursorIndexOfMotherName = CursorUtil.getColumnIndexOrThrow(_cursor, "motherName");
          final int _cursorIndexOfMotherNum = CursorUtil.getColumnIndexOrThrow(_cursor, "motherNum");
          final List<Person> _result = new ArrayList<Person>(_cursor.getCount());
          while (_cursor.moveToNext()) {
            final Person _item;
            final long _tmpPersonUid;
            _tmpPersonUid = _cursor.getLong(_cursorIndexOfPersonUid);
            final String _tmpUsername;
            if (_cursor.isNull(_cursorIndexOfUsername)) {
              _tmpUsername = null;
            } else {
              _tmpUsername = _cursor.getString(_cursorIndexOfUsername);
            }
            final String _tmpFirstNames;
            if (_cursor.isNull(_cursorIndexOfFirstNames)) {
              _tmpFirstNames = null;
            } else {
              _tmpFirstNames = _cursor.getString(_cursorIndexOfFirstNames);
            }
            final String _tmpLastName;
            if (_cursor.isNull(_cursorIndexOfLastName)) {
              _tmpLastName = null;
            } else {
              _tmpLastName = _cursor.getString(_cursorIndexOfLastName);
            }
            final String _tmpEmailAddr;
            if (_cursor.isNull(_cursorIndexOfEmailAddr)) {
              _tmpEmailAddr = null;
            } else {
              _tmpEmailAddr = _cursor.getString(_cursorIndexOfEmailAddr);
            }
            final String _tmpPhoneNum;
            if (_cursor.isNull(_cursorIndexOfPhoneNum)) {
              _tmpPhoneNum = null;
            } else {
              _tmpPhoneNum = _cursor.getString(_cursorIndexOfPhoneNum);
            }
            final int _tmpGender;
            _tmpGender = _cursor.getInt(_cursorIndexOfGender);
            final boolean _tmpActive;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfActive);
            _tmpActive = _tmp != 0;
            final boolean _tmpIsPersonalAccount;
            final int _tmp_1;
            _tmp_1 = _cursor.getInt(_cursorIndexOfIsPersonalAccount);
            _tmpIsPersonalAccount = _tmp_1 != 0;
            final long _tmpDateOfBirth;
            _tmpDateOfBirth = _cursor.getLong(_cursorIndexOfDateOfBirth);
            final String _tmpPersonAddress;
            if (_cursor.isNull(_cursorIndexOfPersonAddress)) {
              _tmpPersonAddress = null;
            } else {
              _tmpPersonAddress = _cursor.getString(_cursorIndexOfPersonAddress);
            }
            final String _tmpPersonOrgId;
            if (_cursor.isNull(_cursorIndexOfPersonOrgId)) {
              _tmpPersonOrgId = null;
            } else {
              _tmpPersonOrgId = _cursor.getString(_cursorIndexOfPersonOrgId);
            }
            final long _tmpPersonGroupUid;
            _tmpPersonGroupUid = _cursor.getLong(_cursorIndexOfPersonGroupUid);
            final long _tmpPersonLct;
            _tmpPersonLct = _cursor.getLong(_cursorIndexOfPersonLct);
            final String _tmpPersonCountry;
            if (_cursor.isNull(_cursorIndexOfPersonCountry)) {
              _tmpPersonCountry = null;
            } else {
              _tmpPersonCountry = _cursor.getString(_cursorIndexOfPersonCountry);
            }
            final int _tmpPersonType;
            _tmpPersonType = _cursor.getInt(_cursorIndexOfPersonType);
            final long _tmpPersonMasterChangeSeqNum;
            _tmpPersonMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonMasterChangeSeqNum);
            final long _tmpPersonLocalChangeSeqNum;
            _tmpPersonLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfPersonLocalChangeSeqNum);
            final int _tmpPersonLastChangedBy;
            _tmpPersonLastChangedBy = _cursor.getInt(_cursorIndexOfPersonLastChangedBy);
            final boolean _tmpAdmin;
            final int _tmp_2;
            _tmp_2 = _cursor.getInt(_cursorIndexOfAdmin);
            _tmpAdmin = _tmp_2 != 0;
            final String _tmpPersonNotes;
            if (_cursor.isNull(_cursorIndexOfPersonNotes)) {
              _tmpPersonNotes = null;
            } else {
              _tmpPersonNotes = _cursor.getString(_cursorIndexOfPersonNotes);
            }
            final String _tmpFatherName;
            if (_cursor.isNull(_cursorIndexOfFatherName)) {
              _tmpFatherName = null;
            } else {
              _tmpFatherName = _cursor.getString(_cursorIndexOfFatherName);
            }
            final String _tmpFatherNumber;
            if (_cursor.isNull(_cursorIndexOfFatherNumber)) {
              _tmpFatherNumber = null;
            } else {
              _tmpFatherNumber = _cursor.getString(_cursorIndexOfFatherNumber);
            }
            final String _tmpMotherName;
            if (_cursor.isNull(_cursorIndexOfMotherName)) {
              _tmpMotherName = null;
            } else {
              _tmpMotherName = _cursor.getString(_cursorIndexOfMotherName);
            }
            final String _tmpMotherNum;
            if (_cursor.isNull(_cursorIndexOfMotherNum)) {
              _tmpMotherNum = null;
            } else {
              _tmpMotherNum = _cursor.getString(_cursorIndexOfMotherNum);
            }
            _item = new Person(_tmpPersonUid,_tmpUsername,_tmpFirstNames,_tmpLastName,_tmpEmailAddr,_tmpPhoneNum,_tmpGender,_tmpActive,_tmpIsPersonalAccount,_tmpDateOfBirth,_tmpPersonAddress,_tmpPersonOrgId,_tmpPersonGroupUid,_tmpPersonLct,_tmpPersonCountry,_tmpPersonType,_tmpPersonMasterChangeSeqNum,_tmpPersonLocalChangeSeqNum,_tmpPersonLastChangedBy,_tmpAdmin,_tmpPersonNotes,_tmpFatherName,_tmpFatherNumber,_tmpMotherName,_tmpMotherNum);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
