package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ContentEntryContentCategoryJoin;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ContentEntryContentCategoryJoinDao_Impl extends ContentEntryContentCategoryJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ContentEntryContentCategoryJoin> __insertionAdapterOfContentEntryContentCategoryJoin;

  private final EntityDeletionOrUpdateAdapter<ContentEntryContentCategoryJoin> __updateAdapterOfContentEntryContentCategoryJoin;

  public ContentEntryContentCategoryJoinDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfContentEntryContentCategoryJoin = new EntityInsertionAdapter<ContentEntryContentCategoryJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ContentEntryContentCategoryJoin` (`ceccjUid`,`ceccjContentEntryUid`,`ceccjContentCategoryUid`,`ceccjLocalChangeSeqNum`,`ceccjMasterChangeSeqNum`,`ceccjLastChangedBy`,`ceccjLct`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntryContentCategoryJoin entity) {
        statement.bindLong(1, entity.getCeccjUid());
        statement.bindLong(2, entity.getCeccjContentEntryUid());
        statement.bindLong(3, entity.getCeccjContentCategoryUid());
        statement.bindLong(4, entity.getCeccjLocalChangeSeqNum());
        statement.bindLong(5, entity.getCeccjMasterChangeSeqNum());
        statement.bindLong(6, entity.getCeccjLastChangedBy());
        statement.bindLong(7, entity.getCeccjLct());
      }
    };
    this.__updateAdapterOfContentEntryContentCategoryJoin = new EntityDeletionOrUpdateAdapter<ContentEntryContentCategoryJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "UPDATE OR ABORT `ContentEntryContentCategoryJoin` SET `ceccjUid` = ?,`ceccjContentEntryUid` = ?,`ceccjContentCategoryUid` = ?,`ceccjLocalChangeSeqNum` = ?,`ceccjMasterChangeSeqNum` = ?,`ceccjLastChangedBy` = ?,`ceccjLct` = ? WHERE `ceccjUid` = ?";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ContentEntryContentCategoryJoin entity) {
        statement.bindLong(1, entity.getCeccjUid());
        statement.bindLong(2, entity.getCeccjContentEntryUid());
        statement.bindLong(3, entity.getCeccjContentCategoryUid());
        statement.bindLong(4, entity.getCeccjLocalChangeSeqNum());
        statement.bindLong(5, entity.getCeccjMasterChangeSeqNum());
        statement.bindLong(6, entity.getCeccjLastChangedBy());
        statement.bindLong(7, entity.getCeccjLct());
        statement.bindLong(8, entity.getCeccjUid());
      }
    };
  }

  @Override
  public long insert(final ContentEntryContentCategoryJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      final long _result = __insertionAdapterOfContentEntryContentCategoryJoin.insertAndReturnId(entity);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public Object insertAsync(final ContentEntryContentCategoryJoin entity,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfContentEntryContentCategoryJoin.insertAndReturnId(entity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public void insertList(final List<? extends ContentEntryContentCategoryJoin> entityList) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __insertionAdapterOfContentEntryContentCategoryJoin.insert(entityList);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void update(final ContentEntryContentCategoryJoin entity) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __updateAdapterOfContentEntryContentCategoryJoin.handle(entity);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public List<ContentEntryContentCategoryJoin> publicContentEntryContentCategoryJoins() {
    final String _sql = "SELECT ContentEntryContentCategoryJoin.* FROM ContentEntryContentCategoryJoin LEFT JOIN ContentEntry ON ContentEntryContentCategoryJoin.ceccjContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntry.publik";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCeccjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjUid");
      final int _cursorIndexOfCeccjContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjContentEntryUid");
      final int _cursorIndexOfCeccjContentCategoryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjContentCategoryUid");
      final int _cursorIndexOfCeccjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjLocalChangeSeqNum");
      final int _cursorIndexOfCeccjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjMasterChangeSeqNum");
      final int _cursorIndexOfCeccjLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjLastChangedBy");
      final int _cursorIndexOfCeccjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjLct");
      final List<ContentEntryContentCategoryJoin> _result = new ArrayList<ContentEntryContentCategoryJoin>(_cursor.getCount());
      while (_cursor.moveToNext()) {
        final ContentEntryContentCategoryJoin _item;
        _item = new ContentEntryContentCategoryJoin();
        final long _tmpCeccjUid;
        _tmpCeccjUid = _cursor.getLong(_cursorIndexOfCeccjUid);
        _item.setCeccjUid(_tmpCeccjUid);
        final long _tmpCeccjContentEntryUid;
        _tmpCeccjContentEntryUid = _cursor.getLong(_cursorIndexOfCeccjContentEntryUid);
        _item.setCeccjContentEntryUid(_tmpCeccjContentEntryUid);
        final long _tmpCeccjContentCategoryUid;
        _tmpCeccjContentCategoryUid = _cursor.getLong(_cursorIndexOfCeccjContentCategoryUid);
        _item.setCeccjContentCategoryUid(_tmpCeccjContentCategoryUid);
        final long _tmpCeccjLocalChangeSeqNum;
        _tmpCeccjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCeccjLocalChangeSeqNum);
        _item.setCeccjLocalChangeSeqNum(_tmpCeccjLocalChangeSeqNum);
        final long _tmpCeccjMasterChangeSeqNum;
        _tmpCeccjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCeccjMasterChangeSeqNum);
        _item.setCeccjMasterChangeSeqNum(_tmpCeccjMasterChangeSeqNum);
        final int _tmpCeccjLastChangedBy;
        _tmpCeccjLastChangedBy = _cursor.getInt(_cursorIndexOfCeccjLastChangedBy);
        _item.setCeccjLastChangedBy(_tmpCeccjLastChangedBy);
        final long _tmpCeccjLct;
        _tmpCeccjLct = _cursor.getLong(_cursorIndexOfCeccjLct);
        _item.setCeccjLct(_tmpCeccjLct);
        _result.add(_item);
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public ContentEntryContentCategoryJoin findJoinByParentChildUuids(final long categoryUid,
      final long contentEntry) {
    final String _sql = "SELECT * from ContentEntryContentCategoryJoin WHERE ceccjContentCategoryUid = ? AND ceccjContentEntryUid = ?";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, categoryUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, contentEntry);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _cursorIndexOfCeccjUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjUid");
      final int _cursorIndexOfCeccjContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjContentEntryUid");
      final int _cursorIndexOfCeccjContentCategoryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjContentCategoryUid");
      final int _cursorIndexOfCeccjLocalChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjLocalChangeSeqNum");
      final int _cursorIndexOfCeccjMasterChangeSeqNum = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjMasterChangeSeqNum");
      final int _cursorIndexOfCeccjLastChangedBy = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjLastChangedBy");
      final int _cursorIndexOfCeccjLct = CursorUtil.getColumnIndexOrThrow(_cursor, "ceccjLct");
      final ContentEntryContentCategoryJoin _result;
      if (_cursor.moveToFirst()) {
        _result = new ContentEntryContentCategoryJoin();
        final long _tmpCeccjUid;
        _tmpCeccjUid = _cursor.getLong(_cursorIndexOfCeccjUid);
        _result.setCeccjUid(_tmpCeccjUid);
        final long _tmpCeccjContentEntryUid;
        _tmpCeccjContentEntryUid = _cursor.getLong(_cursorIndexOfCeccjContentEntryUid);
        _result.setCeccjContentEntryUid(_tmpCeccjContentEntryUid);
        final long _tmpCeccjContentCategoryUid;
        _tmpCeccjContentCategoryUid = _cursor.getLong(_cursorIndexOfCeccjContentCategoryUid);
        _result.setCeccjContentCategoryUid(_tmpCeccjContentCategoryUid);
        final long _tmpCeccjLocalChangeSeqNum;
        _tmpCeccjLocalChangeSeqNum = _cursor.getLong(_cursorIndexOfCeccjLocalChangeSeqNum);
        _result.setCeccjLocalChangeSeqNum(_tmpCeccjLocalChangeSeqNum);
        final long _tmpCeccjMasterChangeSeqNum;
        _tmpCeccjMasterChangeSeqNum = _cursor.getLong(_cursorIndexOfCeccjMasterChangeSeqNum);
        _result.setCeccjMasterChangeSeqNum(_tmpCeccjMasterChangeSeqNum);
        final int _tmpCeccjLastChangedBy;
        _tmpCeccjLastChangedBy = _cursor.getInt(_cursorIndexOfCeccjLastChangedBy);
        _result.setCeccjLastChangedBy(_tmpCeccjLastChangedBy);
        final long _tmpCeccjLct;
        _tmpCeccjLct = _cursor.getLong(_cursorIndexOfCeccjLct);
        _result.setCeccjLct(_tmpCeccjLct);
      } else {
        _result = null;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
