package com.ustadmobile.core.db.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.ExternalAppPermission;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class ExternalAppPermissionDao_Impl extends ExternalAppPermissionDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<ExternalAppPermission> __insertionAdapterOfExternalAppPermission;

  public ExternalAppPermissionDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfExternalAppPermission = new EntityInsertionAdapter<ExternalAppPermission>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `ExternalAppPermission` (`eapUid`,`eapPersonUid`,`eapPackageId`,`eapStartTime`,`eapExpireTime`,`eapAuthToken`,`eapAndroidAccountName`) VALUES (nullif(?, 0),?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final ExternalAppPermission entity) {
        statement.bindLong(1, entity.getEapUid());
        statement.bindLong(2, entity.getEapPersonUid());
        if (entity.getEapPackageId() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getEapPackageId());
        }
        statement.bindLong(4, entity.getEapStartTime());
        statement.bindLong(5, entity.getEapExpireTime());
        if (entity.getEapAuthToken() == null) {
          statement.bindNull(6);
        } else {
          statement.bindString(6, entity.getEapAuthToken());
        }
        if (entity.getEapAndroidAccountName() == null) {
          statement.bindNull(7);
        } else {
          statement.bindString(7, entity.getEapAndroidAccountName());
        }
      }
    };
  }

  @Override
  public Object insertAsync(final ExternalAppPermission externalAppPermission,
      final Continuation<? super Long> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          final Long _result = __insertionAdapterOfExternalAppPermission.insertAndReturnId(externalAppPermission);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object getGrantedAuthToken(final String packageId, final long personUid,
      final long currentTime, final Continuation<? super String> $completion) {
    final String _sql = "\n"
            + "        SELECT ExternalAppPermission.eapAuthToken\n"
            + "          FROM ExternalAppPermission\n"
            + "         WHERE ExternalAppPermission.eapPackageId = ?\n"
            + "           AND ExternalAppPermission.eapPersonUid = ?\n"
            + "           AND ? BETWEEN ExternalAppPermission.eapStartTime AND ExternalAppPermission.eapExpireTime\n"
            + "         LIMIT 1  \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 3);
    int _argIndex = 1;
    _statement.bindString(_argIndex, packageId);
    _argIndex = 2;
    _statement.bindLong(_argIndex, personUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, currentTime);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<String>() {
      @Override
      @Nullable
      public String call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final String _result;
          if (_cursor.moveToFirst()) {
            if (_cursor.isNull(0)) {
              _result = null;
            } else {
              _result = _cursor.getString(0);
            }
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getExternalAccessPermissionByUid(final int eapUid,
      final Continuation<? super ExternalAppPermission> $completion) {
    final String _sql = "\n"
            + "        SELECT *\n"
            + "          FROM ExternalAppPermission\n"
            + "         WHERE eapUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, eapUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<ExternalAppPermission>() {
      @Override
      @Nullable
      public ExternalAppPermission call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfEapUid = CursorUtil.getColumnIndexOrThrow(_cursor, "eapUid");
          final int _cursorIndexOfEapPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "eapPersonUid");
          final int _cursorIndexOfEapPackageId = CursorUtil.getColumnIndexOrThrow(_cursor, "eapPackageId");
          final int _cursorIndexOfEapStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "eapStartTime");
          final int _cursorIndexOfEapExpireTime = CursorUtil.getColumnIndexOrThrow(_cursor, "eapExpireTime");
          final int _cursorIndexOfEapAuthToken = CursorUtil.getColumnIndexOrThrow(_cursor, "eapAuthToken");
          final int _cursorIndexOfEapAndroidAccountName = CursorUtil.getColumnIndexOrThrow(_cursor, "eapAndroidAccountName");
          final ExternalAppPermission _result;
          if (_cursor.moveToFirst()) {
            final int _tmpEapUid;
            _tmpEapUid = _cursor.getInt(_cursorIndexOfEapUid);
            final long _tmpEapPersonUid;
            _tmpEapPersonUid = _cursor.getLong(_cursorIndexOfEapPersonUid);
            final String _tmpEapPackageId;
            if (_cursor.isNull(_cursorIndexOfEapPackageId)) {
              _tmpEapPackageId = null;
            } else {
              _tmpEapPackageId = _cursor.getString(_cursorIndexOfEapPackageId);
            }
            final long _tmpEapStartTime;
            _tmpEapStartTime = _cursor.getLong(_cursorIndexOfEapStartTime);
            final long _tmpEapExpireTime;
            _tmpEapExpireTime = _cursor.getLong(_cursorIndexOfEapExpireTime);
            final String _tmpEapAuthToken;
            if (_cursor.isNull(_cursorIndexOfEapAuthToken)) {
              _tmpEapAuthToken = null;
            } else {
              _tmpEapAuthToken = _cursor.getString(_cursorIndexOfEapAuthToken);
            }
            final String _tmpEapAndroidAccountName;
            if (_cursor.isNull(_cursorIndexOfEapAndroidAccountName)) {
              _tmpEapAndroidAccountName = null;
            } else {
              _tmpEapAndroidAccountName = _cursor.getString(_cursorIndexOfEapAndroidAccountName);
            }
            _result = new ExternalAppPermission(_tmpEapUid,_tmpEapPersonUid,_tmpEapPackageId,_tmpEapStartTime,_tmpEapExpireTime,_tmpEapAuthToken,_tmpEapAndroidAccountName);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object getPersonUidByAuthToken(final String token, final long currentTime,
      final Continuation<? super Long> $completion) {
    final String _sql = "\n"
            + "        SELECT COALESCE(\n"
            + "               (SELECT eapPersonUid\n"
            + "                  FROM ExternalAppPermission\n"
            + "                 WHERE eapAuthToken = ?\n"
            + "                   AND ? BETWEEN eapStartTime AND eapExpireTime\n"
            + "               ),\n"
            + "               0)    \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 2);
    int _argIndex = 1;
    _statement.bindString(_argIndex, token);
    _argIndex = 2;
    _statement.bindLong(_argIndex, currentTime);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<Long>() {
      @Override
      @NonNull
      public Long call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final Long _result;
          if (_cursor.moveToFirst()) {
            final long _tmp;
            _tmp = _cursor.getLong(0);
            _result = _tmp;
          } else {
            _result = 0L;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
