package com.ustadmobile.core.db.dao.xapi;

import androidx.annotation.NonNull;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.SharedSQLiteStatement;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.GroupMemberActorJoin;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class GroupMemberActorJoinDao_Impl extends GroupMemberActorJoinDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<GroupMemberActorJoin> __insertionAdapterOfGroupMemberActorJoin;

  private final EntityInsertionAdapter<GroupMemberActorJoin> __insertionAdapterOfGroupMemberActorJoin_1;

  private final SharedSQLiteStatement __preparedStmtOfUpdateLastModifiedTimeIfNeededAsync;

  public GroupMemberActorJoinDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfGroupMemberActorJoin = new EntityInsertionAdapter<GroupMemberActorJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `GroupMemberActorJoin` (`gmajGroupActorUid`,`gmajMemberActorUid`,`gmajLastMod`) VALUES (?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final GroupMemberActorJoin entity) {
        statement.bindLong(1, entity.getGmajGroupActorUid());
        statement.bindLong(2, entity.getGmajMemberActorUid());
        statement.bindLong(3, entity.getGmajLastMod());
      }
    };
    this.__insertionAdapterOfGroupMemberActorJoin_1 = new EntityInsertionAdapter<GroupMemberActorJoin>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `GroupMemberActorJoin` (`gmajGroupActorUid`,`gmajMemberActorUid`,`gmajLastMod`) VALUES (?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final GroupMemberActorJoin entity) {
        statement.bindLong(1, entity.getGmajGroupActorUid());
        statement.bindLong(2, entity.getGmajMemberActorUid());
        statement.bindLong(3, entity.getGmajLastMod());
      }
    };
    this.__preparedStmtOfUpdateLastModifiedTimeIfNeededAsync = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE GroupMemberActorJoin\n"
                + "           SET gmajLastMod = ?\n"
                + "         WHERE gmajGroupActorUid = ?\n"
                + "           AND gmajMemberActorUid = ?\n"
                + "           AND gmajLastMod != ? \n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertOrIgnoreListAsync(final List<GroupMemberActorJoin> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfGroupMemberActorJoin.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object upsertListAsync(final List<GroupMemberActorJoin> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfGroupMemberActorJoin_1.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateLastModifiedTimeIfNeededAsync(final long gmajGroupActorUid,
      final long gmajMemberActorUid, final long lastModTime,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateLastModifiedTimeIfNeededAsync.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, lastModTime);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, gmajGroupActorUid);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, gmajMemberActorUid);
        _argIndex = 4;
        _stmt.bindLong(_argIndex, lastModTime);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateLastModifiedTimeIfNeededAsync.release(_stmt);
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
