package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.VerbEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class VerbDao_Impl extends VerbDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<VerbEntity> __insertionAdapterOfVerbEntity;

  public VerbDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfVerbEntity = new EntityInsertionAdapter<VerbEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR IGNORE INTO `VerbEntity` (`verbUid`,`verbUrlId`,`verbDeleted`,`verbLct`) VALUES (?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final VerbEntity entity) {
        statement.bindLong(1, entity.getVerbUid());
        if (entity.getVerbUrlId() == null) {
          statement.bindNull(2);
        } else {
          statement.bindString(2, entity.getVerbUrlId());
        }
        final int _tmp = entity.getVerbDeleted() ? 1 : 0;
        statement.bindLong(3, _tmp);
        statement.bindLong(4, entity.getVerbLct());
      }
    };
  }

  @Override
  public Object insertOrIgnoreAsync(final List<VerbEntity> entities,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfVerbEntity.insert(entities);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUid(final long uid, final Continuation<? super VerbEntity> $completion) {
    final String _sql = "\n"
            + "        SELECT VerbEntity.*\n"
            + "        FROM VerbEntity\n"
            + "        WHERE VerbEntity.verbUid = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<VerbEntity>() {
      @Override
      @Nullable
      public VerbEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "verbUid");
          final int _cursorIndexOfVerbUrlId = CursorUtil.getColumnIndexOrThrow(_cursor, "verbUrlId");
          final int _cursorIndexOfVerbDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "verbDeleted");
          final int _cursorIndexOfVerbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "verbLct");
          final VerbEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpVerbUid;
            _tmpVerbUid = _cursor.getLong(_cursorIndexOfVerbUid);
            final String _tmpVerbUrlId;
            if (_cursor.isNull(_cursorIndexOfVerbUrlId)) {
              _tmpVerbUrlId = null;
            } else {
              _tmpVerbUrlId = _cursor.getString(_cursorIndexOfVerbUrlId);
            }
            final boolean _tmpVerbDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfVerbDeleted);
            _tmpVerbDeleted = _tmp != 0;
            final long _tmpVerbLct;
            _tmpVerbLct = _cursor.getLong(_cursorIndexOfVerbLct);
            _result = new VerbEntity(_tmpVerbUid,_tmpVerbUrlId,_tmpVerbDeleted,_tmpVerbLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findByVerbUrl(final String verbUrl,
      final Continuation<? super VerbEntity> $completion) {
    final String _sql = "\n"
            + "        SELECT VerbEntity.*\n"
            + "        FROM VerbEntity\n"
            + "        WHERE VerbEntity.verbUrlId = ? \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, verbUrl);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<VerbEntity>() {
      @Override
      @Nullable
      public VerbEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfVerbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "verbUid");
          final int _cursorIndexOfVerbUrlId = CursorUtil.getColumnIndexOrThrow(_cursor, "verbUrlId");
          final int _cursorIndexOfVerbDeleted = CursorUtil.getColumnIndexOrThrow(_cursor, "verbDeleted");
          final int _cursorIndexOfVerbLct = CursorUtil.getColumnIndexOrThrow(_cursor, "verbLct");
          final VerbEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpVerbUid;
            _tmpVerbUid = _cursor.getLong(_cursorIndexOfVerbUid);
            final String _tmpVerbUrlId;
            if (_cursor.isNull(_cursorIndexOfVerbUrlId)) {
              _tmpVerbUrlId = null;
            } else {
              _tmpVerbUrlId = _cursor.getString(_cursorIndexOfVerbUrlId);
            }
            final boolean _tmpVerbDeleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfVerbDeleted);
            _tmpVerbDeleted = _tmp != 0;
            final long _tmpVerbLct;
            _tmpVerbLct = _cursor.getLong(_cursorIndexOfVerbLct);
            _result = new VerbEntity(_tmpVerbUid,_tmpVerbUrlId,_tmpVerbDeleted,_tmpVerbLct);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
