package com.ustadmobile.core.db.dao.xapi;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.ustadmobile.lib.db.entities.xapi.XapiSessionEntity;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class XapiSessionEntityDao_Impl extends XapiSessionEntityDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<XapiSessionEntity> __insertionAdapterOfXapiSessionEntity;

  private final SharedSQLiteStatement __preparedStmtOfUpdateLatestAsComplete;

  public XapiSessionEntityDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfXapiSessionEntity = new EntityInsertionAdapter<XapiSessionEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR ABORT INTO `XapiSessionEntity` (`xseUid`,`xseLastMod`,`xseRegistrationHi`,`xseRegistrationLo`,`xseUsUid`,`xseAccountPersonUid`,`xseActorUid`,`xseAccountUsername`,`xseClazzUid`,`xseCbUid`,`xseContentEntryUid`,`xseContentEntryVersionUid`,`xseRootActivityId`,`xseRootActivityUid`,`xseStartTime`,`xseExpireTime`,`xseAuth`,`xseCompleted`,`knownActorUidToPersonUids`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final XapiSessionEntity entity) {
        statement.bindLong(1, entity.getXseUid());
        statement.bindLong(2, entity.getXseLastMod());
        statement.bindLong(3, entity.getXseRegistrationHi());
        statement.bindLong(4, entity.getXseRegistrationLo());
        statement.bindLong(5, entity.getXseUsUid());
        statement.bindLong(6, entity.getXseAccountPersonUid());
        statement.bindLong(7, entity.getXseActorUid());
        statement.bindString(8, entity.getXseAccountUsername());
        statement.bindLong(9, entity.getXseClazzUid());
        statement.bindLong(10, entity.getXseCbUid());
        statement.bindLong(11, entity.getXseContentEntryUid());
        statement.bindLong(12, entity.getXseContentEntryVersionUid());
        statement.bindString(13, entity.getXseRootActivityId());
        statement.bindLong(14, entity.getXseRootActivityUid());
        statement.bindLong(15, entity.getXseStartTime());
        statement.bindLong(16, entity.getXseExpireTime());
        if (entity.getXseAuth() == null) {
          statement.bindNull(17);
        } else {
          statement.bindString(17, entity.getXseAuth());
        }
        final int _tmp = entity.getXseCompleted() ? 1 : 0;
        statement.bindLong(18, _tmp);
        statement.bindString(19, entity.getKnownActorUidToPersonUids());
      }
    };
    this.__preparedStmtOfUpdateLatestAsComplete = new SharedSQLiteStatement(__db) {
      @Override
      @NonNull
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE XapiSessionEntity\n"
                + "           SET xseCompleted = ?,\n"
                + "               xseLastMod = ?\n"
                + "         WHERE xseUid = ?\n"
                + "\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insertAsync(final XapiSessionEntity xapiSessionEntity,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfXapiSessionEntity.insert(xapiSessionEntity);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object updateLatestAsComplete(final boolean completed, final long time, final long xseUid,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateLatestAsComplete.acquire();
        int _argIndex = 1;
        final int _tmp = completed ? 1 : 0;
        _stmt.bindLong(_argIndex, _tmp);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, time);
        _argIndex = 3;
        _stmt.bindLong(_argIndex, xseUid);
        try {
          __db.beginTransaction();
          try {
            _stmt.executeUpdateDelete();
            __db.setTransactionSuccessful();
            return Unit.INSTANCE;
          } finally {
            __db.endTransaction();
          }
        } finally {
          __preparedStmtOfUpdateLatestAsComplete.release(_stmt);
        }
      }
    }, $completion);
  }

  @Override
  public Object findByUidAsync(final long uid,
      final Continuation<? super XapiSessionEntity> $completion) {
    final String _sql = "\n"
            + "        SELECT XapiSessionEntity.*\n"
            + "          FROM XapiSessionEntity\n"
            + "         WHERE XapiSessionEntity.xseUid = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, uid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<XapiSessionEntity>() {
      @Override
      @Nullable
      public XapiSessionEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfXseUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseUid");
          final int _cursorIndexOfXseLastMod = CursorUtil.getColumnIndexOrThrow(_cursor, "xseLastMod");
          final int _cursorIndexOfXseRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "xseRegistrationHi");
          final int _cursorIndexOfXseRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "xseRegistrationLo");
          final int _cursorIndexOfXseUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseUsUid");
          final int _cursorIndexOfXseAccountPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseAccountPersonUid");
          final int _cursorIndexOfXseActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseActorUid");
          final int _cursorIndexOfXseAccountUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "xseAccountUsername");
          final int _cursorIndexOfXseClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseClazzUid");
          final int _cursorIndexOfXseCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseCbUid");
          final int _cursorIndexOfXseContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseContentEntryUid");
          final int _cursorIndexOfXseContentEntryVersionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseContentEntryVersionUid");
          final int _cursorIndexOfXseRootActivityId = CursorUtil.getColumnIndexOrThrow(_cursor, "xseRootActivityId");
          final int _cursorIndexOfXseRootActivityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseRootActivityUid");
          final int _cursorIndexOfXseStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "xseStartTime");
          final int _cursorIndexOfXseExpireTime = CursorUtil.getColumnIndexOrThrow(_cursor, "xseExpireTime");
          final int _cursorIndexOfXseAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "xseAuth");
          final int _cursorIndexOfXseCompleted = CursorUtil.getColumnIndexOrThrow(_cursor, "xseCompleted");
          final int _cursorIndexOfKnownActorUidToPersonUids = CursorUtil.getColumnIndexOrThrow(_cursor, "knownActorUidToPersonUids");
          final XapiSessionEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpXseUid;
            _tmpXseUid = _cursor.getLong(_cursorIndexOfXseUid);
            final long _tmpXseLastMod;
            _tmpXseLastMod = _cursor.getLong(_cursorIndexOfXseLastMod);
            final long _tmpXseRegistrationHi;
            _tmpXseRegistrationHi = _cursor.getLong(_cursorIndexOfXseRegistrationHi);
            final long _tmpXseRegistrationLo;
            _tmpXseRegistrationLo = _cursor.getLong(_cursorIndexOfXseRegistrationLo);
            final long _tmpXseUsUid;
            _tmpXseUsUid = _cursor.getLong(_cursorIndexOfXseUsUid);
            final long _tmpXseAccountPersonUid;
            _tmpXseAccountPersonUid = _cursor.getLong(_cursorIndexOfXseAccountPersonUid);
            final long _tmpXseActorUid;
            _tmpXseActorUid = _cursor.getLong(_cursorIndexOfXseActorUid);
            final String _tmpXseAccountUsername;
            _tmpXseAccountUsername = _cursor.getString(_cursorIndexOfXseAccountUsername);
            final long _tmpXseClazzUid;
            _tmpXseClazzUid = _cursor.getLong(_cursorIndexOfXseClazzUid);
            final long _tmpXseCbUid;
            _tmpXseCbUid = _cursor.getLong(_cursorIndexOfXseCbUid);
            final long _tmpXseContentEntryUid;
            _tmpXseContentEntryUid = _cursor.getLong(_cursorIndexOfXseContentEntryUid);
            final long _tmpXseContentEntryVersionUid;
            _tmpXseContentEntryVersionUid = _cursor.getLong(_cursorIndexOfXseContentEntryVersionUid);
            final String _tmpXseRootActivityId;
            _tmpXseRootActivityId = _cursor.getString(_cursorIndexOfXseRootActivityId);
            final long _tmpXseRootActivityUid;
            _tmpXseRootActivityUid = _cursor.getLong(_cursorIndexOfXseRootActivityUid);
            final long _tmpXseStartTime;
            _tmpXseStartTime = _cursor.getLong(_cursorIndexOfXseStartTime);
            final long _tmpXseExpireTime;
            _tmpXseExpireTime = _cursor.getLong(_cursorIndexOfXseExpireTime);
            final String _tmpXseAuth;
            if (_cursor.isNull(_cursorIndexOfXseAuth)) {
              _tmpXseAuth = null;
            } else {
              _tmpXseAuth = _cursor.getString(_cursorIndexOfXseAuth);
            }
            final boolean _tmpXseCompleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfXseCompleted);
            _tmpXseCompleted = _tmp != 0;
            final String _tmpKnownActorUidToPersonUids;
            _tmpKnownActorUidToPersonUids = _cursor.getString(_cursorIndexOfKnownActorUidToPersonUids);
            _result = new XapiSessionEntity(_tmpXseUid,_tmpXseLastMod,_tmpXseRegistrationHi,_tmpXseRegistrationLo,_tmpXseUsUid,_tmpXseAccountPersonUid,_tmpXseActorUid,_tmpXseAccountUsername,_tmpXseClazzUid,_tmpXseCbUid,_tmpXseContentEntryUid,_tmpXseContentEntryVersionUid,_tmpXseRootActivityId,_tmpXseRootActivityUid,_tmpXseStartTime,_tmpXseExpireTime,_tmpXseAuth,_tmpXseCompleted,_tmpKnownActorUidToPersonUids);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @Override
  public Object findMostRecentSessionByActorAndActivity(final long accountPersonUid,
      final long actorUid, final long xseRootActivityUid, final long contentEntryVersionUid,
      final long clazzUid, final Continuation<? super XapiSessionEntity> $completion) {
    final String _sql = "\n"
            + "        SELECT XapiSessionEntity.*\n"
            + "          FROM XapiSessionEntity\n"
            + "         WHERE XapiSessionEntity.xseRootActivityUid = ?\n"
            + "           AND XapiSessionEntity.xseActorUid = ?\n"
            + "           AND XapiSessionEntity.xseContentEntryVersionUid = ?\n"
            + "           AND XapiSessionEntity.xseClazzUid = ?\n"
            + "           AND EXISTS(\n"
            + "               SELECT 1\n"
            + "                 FROM ActorEntity\n"
            + "                WHERE ActorEntity.actorUid = ?\n"
            + "                  AND ActorEntity.actorPersonUid = ?)     \n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 6);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, xseRootActivityUid);
    _argIndex = 2;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 3;
    _statement.bindLong(_argIndex, contentEntryVersionUid);
    _argIndex = 4;
    _statement.bindLong(_argIndex, clazzUid);
    _argIndex = 5;
    _statement.bindLong(_argIndex, actorUid);
    _argIndex = 6;
    _statement.bindLong(_argIndex, accountPersonUid);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<XapiSessionEntity>() {
      @Override
      @Nullable
      public XapiSessionEntity call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfXseUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseUid");
          final int _cursorIndexOfXseLastMod = CursorUtil.getColumnIndexOrThrow(_cursor, "xseLastMod");
          final int _cursorIndexOfXseRegistrationHi = CursorUtil.getColumnIndexOrThrow(_cursor, "xseRegistrationHi");
          final int _cursorIndexOfXseRegistrationLo = CursorUtil.getColumnIndexOrThrow(_cursor, "xseRegistrationLo");
          final int _cursorIndexOfXseUsUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseUsUid");
          final int _cursorIndexOfXseAccountPersonUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseAccountPersonUid");
          final int _cursorIndexOfXseActorUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseActorUid");
          final int _cursorIndexOfXseAccountUsername = CursorUtil.getColumnIndexOrThrow(_cursor, "xseAccountUsername");
          final int _cursorIndexOfXseClazzUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseClazzUid");
          final int _cursorIndexOfXseCbUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseCbUid");
          final int _cursorIndexOfXseContentEntryUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseContentEntryUid");
          final int _cursorIndexOfXseContentEntryVersionUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseContentEntryVersionUid");
          final int _cursorIndexOfXseRootActivityId = CursorUtil.getColumnIndexOrThrow(_cursor, "xseRootActivityId");
          final int _cursorIndexOfXseRootActivityUid = CursorUtil.getColumnIndexOrThrow(_cursor, "xseRootActivityUid");
          final int _cursorIndexOfXseStartTime = CursorUtil.getColumnIndexOrThrow(_cursor, "xseStartTime");
          final int _cursorIndexOfXseExpireTime = CursorUtil.getColumnIndexOrThrow(_cursor, "xseExpireTime");
          final int _cursorIndexOfXseAuth = CursorUtil.getColumnIndexOrThrow(_cursor, "xseAuth");
          final int _cursorIndexOfXseCompleted = CursorUtil.getColumnIndexOrThrow(_cursor, "xseCompleted");
          final int _cursorIndexOfKnownActorUidToPersonUids = CursorUtil.getColumnIndexOrThrow(_cursor, "knownActorUidToPersonUids");
          final XapiSessionEntity _result;
          if (_cursor.moveToFirst()) {
            final long _tmpXseUid;
            _tmpXseUid = _cursor.getLong(_cursorIndexOfXseUid);
            final long _tmpXseLastMod;
            _tmpXseLastMod = _cursor.getLong(_cursorIndexOfXseLastMod);
            final long _tmpXseRegistrationHi;
            _tmpXseRegistrationHi = _cursor.getLong(_cursorIndexOfXseRegistrationHi);
            final long _tmpXseRegistrationLo;
            _tmpXseRegistrationLo = _cursor.getLong(_cursorIndexOfXseRegistrationLo);
            final long _tmpXseUsUid;
            _tmpXseUsUid = _cursor.getLong(_cursorIndexOfXseUsUid);
            final long _tmpXseAccountPersonUid;
            _tmpXseAccountPersonUid = _cursor.getLong(_cursorIndexOfXseAccountPersonUid);
            final long _tmpXseActorUid;
            _tmpXseActorUid = _cursor.getLong(_cursorIndexOfXseActorUid);
            final String _tmpXseAccountUsername;
            _tmpXseAccountUsername = _cursor.getString(_cursorIndexOfXseAccountUsername);
            final long _tmpXseClazzUid;
            _tmpXseClazzUid = _cursor.getLong(_cursorIndexOfXseClazzUid);
            final long _tmpXseCbUid;
            _tmpXseCbUid = _cursor.getLong(_cursorIndexOfXseCbUid);
            final long _tmpXseContentEntryUid;
            _tmpXseContentEntryUid = _cursor.getLong(_cursorIndexOfXseContentEntryUid);
            final long _tmpXseContentEntryVersionUid;
            _tmpXseContentEntryVersionUid = _cursor.getLong(_cursorIndexOfXseContentEntryVersionUid);
            final String _tmpXseRootActivityId;
            _tmpXseRootActivityId = _cursor.getString(_cursorIndexOfXseRootActivityId);
            final long _tmpXseRootActivityUid;
            _tmpXseRootActivityUid = _cursor.getLong(_cursorIndexOfXseRootActivityUid);
            final long _tmpXseStartTime;
            _tmpXseStartTime = _cursor.getLong(_cursorIndexOfXseStartTime);
            final long _tmpXseExpireTime;
            _tmpXseExpireTime = _cursor.getLong(_cursorIndexOfXseExpireTime);
            final String _tmpXseAuth;
            if (_cursor.isNull(_cursorIndexOfXseAuth)) {
              _tmpXseAuth = null;
            } else {
              _tmpXseAuth = _cursor.getString(_cursorIndexOfXseAuth);
            }
            final boolean _tmpXseCompleted;
            final int _tmp;
            _tmp = _cursor.getInt(_cursorIndexOfXseCompleted);
            _tmpXseCompleted = _tmp != 0;
            final String _tmpKnownActorUidToPersonUids;
            _tmpKnownActorUidToPersonUids = _cursor.getString(_cursorIndexOfKnownActorUidToPersonUids);
            _result = new XapiSessionEntity(_tmpXseUid,_tmpXseLastMod,_tmpXseRegistrationHi,_tmpXseRegistrationLo,_tmpXseUsUid,_tmpXseAccountPersonUid,_tmpXseActorUid,_tmpXseAccountUsername,_tmpXseClazzUid,_tmpXseCbUid,_tmpXseContentEntryUid,_tmpXseContentEntryVersionUid,_tmpXseRootActivityId,_tmpXseRootActivityUid,_tmpXseStartTime,_tmpXseExpireTime,_tmpXseAuth,_tmpXseCompleted,_tmpKnownActorUidToPersonUids);
          } else {
            _result = null;
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, $completion);
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
