/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.core.db.dao;

import androidx.paging.PagingSource;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.Update;
import com.ustadmobile.core.db.dao.BaseDao;
import com.ustadmobile.lib.db.composites.ContentEntryAndDetail;
import com.ustadmobile.lib.db.composites.ContentEntryAndLanguage;
import com.ustadmobile.lib.db.composites.ContentEntryAndListDetail;
import com.ustadmobile.lib.db.composites.ContentEntryAndPicture;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.ContentEntryWithLanguage;
import com.ustadmobile.lib.db.entities.UidAndLabel;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\f\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ0\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H'J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H'J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u00a7@\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0012H'J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u0007H'J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001c\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0006\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\n2\u0006\u0010\"\u001a\u00020\u0007H'J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H'J\u0018\u0010$\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\"\u001a\u00020\u0007H'J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\"\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u001c\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\"\u001a\u00020\u0007H'JD\u0010*\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020+0(2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u000200H'J\u001c\u00101\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020+0(2\u0006\u0010\u000f\u001a\u00020\u0007H'J\u0018\u00102\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\"\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005H\u00a7@\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0012H'J\u001c\u00109\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020+0(2\u0006\u0010\u000f\u001a\u00020\u0007H'J\u0016\u0010:\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u0007H\u00a7@\u00a2\u0006\u0002\u0010\bJ\u001c\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u00a7@\u00a2\u0006\u0002\u00106J\u0010\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020\u0002H'J\u0016\u0010@\u001a\u00020)2\u0006\u0010?\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010AJ \u0010B\u001a\u00020<2\u0006\u0010C\u001a\u00020)2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u0007H'J \u0010E\u001a\u00020<2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010F\u001a\u0002002\u0006\u0010D\u001a\u00020\u0007H'J\u0016\u0010G\u001a\u00020<2\u0006\u0010?\u001a\u00020\u0002H\u00a7@\u00a2\u0006\u0002\u0010A\u00a8\u0006H"}, d2={"Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "Lcom/ustadmobile/core/db/dao/BaseDao;", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "()V", "findAllLanguageRelatedEntriesAsync", "", "entryUuid", "", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByContentEntryUidWithDetailsAsFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/ustadmobile/lib/db/composites/ContentEntryAndDetail;", "contentEntryUid", "clazzUid", "courseBlockUid", "accountPersonUid", "findBySourceUrl", "sourceUrl", "", "findBySourceUrlWithContentEntryStatusAsync", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findByTitle", "title", "findByUid", "entryUid", "findByUidAsync", "findByUidWithEditDetails", "Lcom/ustadmobile/lib/db/composites/ContentEntryAndPicture;", "uid", "findByUidWithLanguageAsync", "Lcom/ustadmobile/lib/db/entities/ContentEntryWithLanguage;", "findEntryWithLanguageByEntryIdAsync", "Lcom/ustadmobile/lib/db/composites/ContentEntryAndLanguage;", "findLiveContentEntry", "parentUid", "findSimilarIdEntryForKhan", "findTitleByUidAsync", "getChildrenByAll", "getChildrenByParentAsync", "getChildrenByParentUid", "Landroidx/paging/PagingSource;", "", "getChildrenByParentUidWithCategoryFilterOrderByName", "Lcom/ustadmobile/lib/db/composites/ContentEntryAndListDetail;", "langParam", "categoryParam0", "sortOrder", "includeDeleted", "", "getContentByOwner", "getContentByUuidAsync", "getContentEntryFromUids", "Lcom/ustadmobile/lib/db/entities/UidAndLabel;", "contentEntryUids", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getContentEntryUidFromXapiObjectId", "objectId", "getContentFromMyCourses", "getCountNumberOfChildrenByParentUUidAsync", "insertListAsync", "", "entityList", "update", "entity", "updateAsync", "(Lcom/ustadmobile/lib/db/entities/ContentEntry;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateContentEntryContentFlag", "contentFlag", "changedTime", "updateContentEntryInActive", "ceInactive", "upsertAsync", "lib-database_release"})
@Dao
public abstract class ContentEntryDao
implements BaseDao<ContentEntry> {
    @Insert(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object insertListAsync(@NotNull List<? extends ContentEntry> var1, @NotNull Continuation<? super Unit> var2);

    @Insert(entity=Object.class, onConflict=1)
    @Nullable
    public abstract Object upsertAsync(@NotNull ContentEntry var1, @NotNull Continuation<? super Unit> var2);

    @Query(value="SELECT * FROM ContentEntry WHERE contentEntryUid = :entryUid")
    @Nullable
    public abstract Object findByUidAsync(long var1, @NotNull Continuation<? super ContentEntry> var3);

    @Query(value="\n        SELECT ContentEntry.*, Language.* \n          FROM ContentEntry \n               LEFT JOIN Language \n                         ON Language.langUid = ContentEntry.primaryLanguageUid\n         WHERE ContentEntry.contentEntryUid=:entryUuid\n        ")
    @Nullable
    public abstract Object findEntryWithLanguageByEntryIdAsync(long var1, @NotNull Continuation<? super ContentEntryAndLanguage> var3);

    @Query(value="\n        SELECT ContentEntry.*, ContentEntryPicture2.*\n          FROM ContentEntry\n               LEFT JOIN ContentEntryPicture2 \n                         ON ContentEntryPicture2.cepUid = :uid\n         WHERE ContentEntry.contentEntryUid = :uid                \n    ")
    @Nullable
    public abstract Object findByUidWithEditDetails(long var1, @NotNull Continuation<? super ContentEntryAndPicture> var3);

    @Query(value="\n              -- When the user is viewing ContentEntryDetail where the class is specified eg \n              -- for a ContentEntry that is part of a Clazz then results information will only be\n              -- included if the user is a student in the class\n              -- If the user is viewing the ContentEntryDetail via the library then the results\n              -- information will always be included\n              WITH IncludeResults(includeResults) AS (\n                   SELECT CAST(\n                      (SELECT (:clazzUid = 0)\n                           OR (\n        (SELECT EXISTS(\n                SELECT 1\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentClazzUid = :clazzUid\n                   AND ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid\n                   AND ClazzEnrolment.clazzEnrolmentRole = 1000))\n    )\n                      ) AS INTEGER)\n                  )\n\n              SELECT ContentEntry.*, ContentEntryVersion.*, ContentEntryPicture2.*,\n                   :accountPersonUid AS sPersonUid,\n                   :courseBlockUid AS sCbUid,\n                   \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n              FROM ContentEntry\n                   LEFT JOIN ContentEntryVersion\n                             ON ContentEntryVersion.cevUid = \n                             (SELECT ContentEntryVersion.cevUid\n                                FROM ContentEntryVersion\n                               WHERE ContentEntryVersion.cevContentEntryUid = :contentEntryUid\n                                 AND CAST(cevInActive AS INTEGER) = 0\n                            ORDER BY ContentEntryVersion.cevLct DESC\n                              LIMIT 1)\n                   LEFT JOIN ContentEntryPicture2\n                             ON ContentEntryPicture2.cepUid = :contentEntryUid   \n             WHERE ContentEntry.contentEntryUid = :contentEntryUid\n            ")
    @NotNull
    public abstract Flow<ContentEntryAndDetail> findByContentEntryUidWithDetailsAsFlow(long var1, long var3, long var5, long var7);

    @Query(value="SELECT * FROM ContentEntry WHERE sourceUrl = :sourceUrl LIMIT 1")
    @Nullable
    public abstract ContentEntry findBySourceUrl(@NotNull String var1);

    @Query(value="SELECT title FROM ContentEntry WHERE contentEntryUid = :entryUid")
    @Nullable
    public abstract Object findTitleByUidAsync(long var1, @NotNull Continuation<? super String> var3);

    @Query(value="SELECT ContentEntry.* FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid")
    @NotNull
    public abstract PagingSource<Integer, ContentEntry> getChildrenByParentUid(long var1);

    @Query(value="\n        SELECT ContentEntry.*\n          FROM ContentEntryParentChildJoin\n               JOIN ContentEntry \n                    ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid\n         WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid\n    ")
    @Nullable
    public abstract Object getChildrenByParentAsync(long var1, @NotNull Continuation<? super List<? extends ContentEntry>> var3);

    @Query(value="SELECT COUNT(*) FROM ContentEntry LEFT Join ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid")
    @Nullable
    public abstract Object getCountNumberOfChildrenByParentUUidAsync(long var1, @NotNull Continuation<? super Integer> var3);

    @Query(value="SELECT * FROM ContentEntry where contentEntryUid = :parentUid LIMIT 1")
    @Nullable
    public abstract Object getContentByUuidAsync(long var1, @NotNull Continuation<? super ContentEntry> var3);

    @Query(value="SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryRelatedEntryJoin ON ContentEntryRelatedEntryJoin.cerejRelatedEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryRelatedEntryJoin.relType = 1 AND ContentEntryRelatedEntryJoin.cerejRelatedEntryUid != :entryUuid")
    @Nullable
    public abstract Object findAllLanguageRelatedEntriesAsync(long var1, @NotNull Continuation<? super List<? extends ContentEntry>> var3);

    @Override
    @Update(entity=Object.class, onConflict=3)
    public abstract void update(@NotNull ContentEntry var1);

    @Query(value="\n        SELECT ContentEntry.*, Language.*\n          FROM ContentEntry\n               LEFT JOIN Language \n                      ON Language.langUid = ContentEntry.primaryLanguageUid \n         WHERE ContentEntry.contentEntryUid = :uid              \n    ")
    @Nullable
    public abstract Object findByUidWithLanguageAsync(long var1, @NotNull Continuation<? super ContentEntryWithLanguage> var3);

    @Query(value="SELECT * FROM ContentEntry WHERE contentEntryUid = :entryUid")
    @Nullable
    public abstract ContentEntry findByUid(long var1);

    @Query(value="SELECT * FROM ContentEntry WHERE title = :title")
    @NotNull
    public abstract Flow<ContentEntry> findByTitle(@NotNull String var1);

    @Query(value="SELECT ContentEntry.* FROM ContentEntry WHERE ContentEntry.sourceUrl = :sourceUrl")
    @Nullable
    public abstract Object findBySourceUrlWithContentEntryStatusAsync(@NotNull String var1, @NotNull Continuation<? super ContentEntry> var2);

    @Query(value="\n            WITH IncludeResults(includeResults) AS (SELECT 1)\n            \n            SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*,\n                   \n               :accountPersonUid AS sPersonUid,\n               0 AS sCbUid,\n               \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n    \n              FROM ContentEntry \n                    LEFT JOIN ContentEntryParentChildJoin \n                         ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid \n                    LEFT JOIN ContentEntryPicture2\n                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid\n             WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid \n               AND (:langParam = 0 OR ContentEntry.primaryLanguageUid = :langParam)\n               AND (:categoryParam0 = 0 OR :categoryParam0 \n                    IN (SELECT ceccjContentCategoryUid \n                          FROM ContentEntryContentCategoryJoin \n                         WHERE ceccjContentEntryUid = ContentEntry.contentEntryUid)) \n               AND (CAST(:includeDeleted AS INTEGER) = 1 OR CAST(ContentEntryParentChildJoin.cepcjDeleted AS INTEGER) = 0)          \n            ORDER BY ContentEntryParentChildJoin.childIndex,\n                     CASE(:sortOrder)\n                     WHEN 1 THEN ContentEntry.title\n                     ELSE ''\n                     END ASC,\n                     CASE(:sortOrder)\n                     WHEN 2 THEN ContentEntry.title\n                     ELSE ''\n                     END DESC,             \n                     ContentEntry.contentEntryUid")
    @NotNull
    public abstract PagingSource<Integer, ContentEntryAndListDetail> getChildrenByParentUidWithCategoryFilterOrderByName(long var1, long var3, long var5, long var7, int var9, boolean var10);

    @Query(value="\n        WITH IncludeResults(includeResults) AS (SELECT 1)\n        \n        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*,\n               \n               :accountPersonUid AS sPersonUid,\n               0 AS sCbUid,\n               \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n    \n          FROM CourseBlock\n               JOIN ContentEntry \n                    ON CourseBlock.cbType = 104\n                       AND ContentEntry.contentEntryUid = CourseBlock.cbEntityUid\n                       AND CAST(CourseBlock.cbActive AS INTEGER) = 1\n               LEFT JOIN ContentEntryParentChildJoin\n                         ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = 0\n               LEFT JOIN ContentEntryPicture2\n                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid          \n         WHERE CourseBlock.cbClazzUid IN\n               (SELECT ClazzEnrolment.clazzEnrolmentClazzUid\n                  FROM ClazzEnrolment\n                 WHERE ClazzEnrolment.clazzEnrolmentPersonUid = :accountPersonUid)\n    ")
    @NotNull
    public abstract PagingSource<Integer, ContentEntryAndListDetail> getContentFromMyCourses(long var1);

    @Query(value="\n        WITH IncludeResults(includeResults) AS (SELECT 1)\n        \n        SELECT ContentEntry.*, ContentEntryParentChildJoin.*, ContentEntryPicture2.*, \n               \n               :accountPersonUid AS sPersonUid,\n               0 AS sCbUid,\n               \n                   (SELECT MAX(StatementEntity.extensionProgress)\n                     FROM StatementEntity\n                    WHERE (SELECT includeResults FROM IncludeResults) = 1\n                      AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                      AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                      AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n                   ) AS sProgress,\n                   (SELECT CASE\n                       -- If a successful completion statement exists, then count as success\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1    \n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 1\n    )))\n                            THEN 1\n                       -- Else if no success record exists, however a fail record exists, mark as failed\n                       WHEN (SELECT EXISTS(\n                                    SELECT 1\n                                      FROM StatementEntity\n                                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid \n                                       AND (\n              CAST(StatementEntity.completionOrProgress AS INTEGER) = 1\n          AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n          AND CAST(StatementEntity.resultSuccess AS INTEGER) = 0\n    )))\n                            THEN 0\n                            \n                       ELSE NULL\n                       END                    \n                   ) AS sIsSuccess,\n                   (SELECT EXISTS(\n                           SELECT 1\n                             FROM StatementEntity\n                            WHERE (SELECT includeResults FROM IncludeResults) = 1\n                              AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                              AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                              AND CAST(StatementEntity.resultCompletion AS INTEGER) = 1\n                              AND CAST(StatementEntity.completionOrProgress AS INTEGER) = 1)\n                   ) AS sIsCompleted,\n                   (SELECT MAX(StatementEntity.resultScoreScaled)\n                      FROM StatementEntity\n                     WHERE (SELECT includeResults FROM IncludeResults) = 1\n                       AND StatementEntity.statementActorPersonUid = :accountPersonUid\n                       AND StatementEntity.statementContentEntryUid = ContentEntry.contentEntryUid\n                   ) AS sScoreScaled\n    \n    \n          FROM ContentEntry\n               LEFT JOIN ContentEntryParentChildJoin\n                         ON ContentEntryParentChildJoin.cepcjParentContentEntryUid = 0\n               LEFT JOIN ContentEntryPicture2\n                         ON ContentEntryPicture2.cepUid = ContentEntry.contentEntryUid\n         WHERE ContentEntry.contentOwner = :accountPersonUid\n    ")
    @NotNull
    public abstract PagingSource<Integer, ContentEntryAndListDetail> getContentByOwner(long var1);

    @Update(entity=Object.class, onConflict=3)
    @Nullable
    public abstract Object updateAsync(@NotNull ContentEntry var1, @NotNull Continuation<? super Integer> var2);

    @Query(value="SELECT ContentEntry.* FROM ContentEntry LEFT JOIN ContentEntryParentChildJoin ON ContentEntryParentChildJoin.cepcjChildContentEntryUid = ContentEntry.contentEntryUid WHERE ContentEntryParentChildJoin.cepcjParentContentEntryUid = :parentUid")
    @NotNull
    public abstract List<ContentEntry> getChildrenByAll(long var1);

    @Query(value="SELECT * FROM ContentEntry where contentEntryUid = :parentUid LIMIT 1")
    @NotNull
    public abstract Flow<ContentEntry> findLiveContentEntry(long var1);

    @Query(value="SELECT COALESCE((SELECT contentEntryUid \n                                      FROM ContentEntry \n                                     WHERE entryId = :objectId \n                                     LIMIT 1),0) AS ID")
    public abstract long getContentEntryUidFromXapiObjectId(@NotNull String var1);

    @Query(value="SELECT * FROM ContentEntry WHERE sourceUrl LIKE :sourceUrl")
    @NotNull
    public abstract List<ContentEntry> findSimilarIdEntryForKhan(@NotNull String var1);

    @Query(value="\n            UPDATE ContentEntry \n               SET ceInactive = :ceInactive,\n                   contentEntryLct = :changedTime        \n            WHERE ContentEntry.contentEntryUid = :contentEntryUid")
    public abstract void updateContentEntryInActive(long var1, boolean var3, long var4);

    @Query(value="\n        UPDATE ContentEntry \n           SET contentTypeFlag = :contentFlag,\n               contentEntryLct = :changedTime \n         WHERE ContentEntry.contentEntryUid = :contentEntryUid")
    public abstract void updateContentEntryContentFlag(int var1, long var2, long var4);

    @Query(value="Select ContentEntry.contentEntryUid AS uid, ContentEntry.title As labelName \n                    from ContentEntry WHERE contentEntryUid IN (:contentEntryUids)")
    @Nullable
    public abstract Object getContentEntryFromUids(@NotNull List<Long> var1, @NotNull Continuation<? super List<UidAndLabel>> var2);
}

