/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.sessions;

import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationKt;
import io.ktor.server.sessions.SessionSerializer;
import io.ktor.server.sessions.SessionTracker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B!\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J!\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0015\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lio/ktor/server/sessions/SessionTrackerByValue;", "S", "", "Lio/ktor/server/sessions/SessionTracker;", "type", "Lkotlin/reflect/KClass;", "serializer", "Lio/ktor/server/sessions/SessionSerializer;", "(Lkotlin/reflect/KClass;Lio/ktor/server/sessions/SessionSerializer;)V", "getSerializer", "()Lio/ktor/server/sessions/SessionSerializer;", "getType", "()Lkotlin/reflect/KClass;", "clear", "", "call", "Lio/ktor/server/application/ApplicationCall;", "(Lio/ktor/server/application/ApplicationCall;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "load", "transport", "", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "store", "value", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "validate", "(Ljava/lang/Object;)V", "ktor-server-sessions"})
public final class SessionTrackerByValue<S>
implements SessionTracker<S> {
    @NotNull
    private final KClass<S> type;
    @NotNull
    private final SessionSerializer<S> serializer;

    public SessionTrackerByValue(@NotNull KClass<S> type2, @NotNull SessionSerializer<S> serializer2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        this.type = type2;
        this.serializer = serializer2;
    }

    @NotNull
    public final KClass<S> getType() {
        return this.type;
    }

    @NotNull
    public final SessionSerializer<S> getSerializer() {
        return this.serializer;
    }

    @Override
    @Nullable
    public Object load(@NotNull ApplicationCall call, @Nullable String transport, @NotNull Continuation<? super S> $completion) {
        Object v1;
        String string = transport;
        if (string != null) {
            S s2;
            String serialized = string;
            boolean bl = false;
            try {
                s2 = this.serializer.deserialize(serialized);
            }
            catch (Throwable t3) {
                ApplicationKt.getLog(call.getApplication()).debug("Failed to deserialize session: " + serialized, t3);
                s2 = null;
            }
            v1 = s2;
        } else {
            v1 = null;
        }
        return v1;
    }

    @Override
    @Nullable
    public Object store(@NotNull ApplicationCall call, @NotNull S value, @NotNull Continuation<? super String> $completion) {
        return this.serializer.serialize(value);
    }

    @Override
    public void validate(@NotNull S value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!this.type.isInstance(value)) {
            throw new IllegalArgumentException("Value for this session tracker expected to be of type " + this.type + " but was " + value);
        }
    }

    @Override
    @Nullable
    public Object clear(@NotNull ApplicationCall call, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @NotNull
    public String toString() {
        return "SessionTrackerByValue";
    }
}

