/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.StringBuilderWriter;

public class IOUtils {
    public static final int EOF = -1;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final String LINE_SEPARATOR;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static char[] SKIP_CHAR_BUFFER;
    private static byte[] SKIP_BYTE_BUFFER;

    public static void close(URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    public static void closeQuietly(Reader input2) {
        IOUtils.closeQuietly((Closeable)input2);
    }

    public static void closeQuietly(Writer output2) {
        IOUtils.closeQuietly((Closeable)output2);
    }

    public static void closeQuietly(InputStream input2) {
        IOUtils.closeQuietly((Closeable)input2);
    }

    public static void closeQuietly(OutputStream output2) {
        IOUtils.closeQuietly((Closeable)output2);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            IOUtils.closeQuietly(closeable);
        }
    }

    public static void closeQuietly(Socket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Selector selector) {
        if (selector != null) {
            try {
                selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(ServerSocket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static InputStream toBufferedInputStream(InputStream input2) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(input2);
    }

    public static InputStream toBufferedInputStream(InputStream input2, int size2) throws IOException {
        return ByteArrayOutputStream.toBufferedInputStream(input2, size2);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader toBufferedReader(Reader reader, int size2) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, size2);
    }

    public static BufferedReader buffer(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader buffer(Reader reader, int size2) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, size2);
    }

    public static BufferedWriter buffer(Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static BufferedWriter buffer(Writer writer, int size2) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, size2);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream2) {
        if (outputStream2 == null) {
            throw new NullPointerException();
        }
        return outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream2, int size2) {
        if (outputStream2 == null) {
            throw new NullPointerException();
        }
        return outputStream2 instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream2 : new BufferedOutputStream(outputStream2, size2);
    }

    public static BufferedInputStream buffer(InputStream inputStream2) {
        if (inputStream2 == null) {
            throw new NullPointerException();
        }
        return inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2);
    }

    public static BufferedInputStream buffer(InputStream inputStream2, int size2) {
        if (inputStream2 == null) {
            throw new NullPointerException();
        }
        return inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, size2);
    }

    public static byte[] toByteArray(InputStream input2) throws IOException {
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        IOUtils.copy(input2, (OutputStream)output2);
        return output2.toByteArray();
    }

    public static byte[] toByteArray(InputStream input2, long size2) throws IOException {
        if (size2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + size2);
        }
        return IOUtils.toByteArray(input2, (int)size2);
    }

    public static byte[] toByteArray(InputStream input2, int size2) throws IOException {
        int offset;
        int readed;
        if (size2 < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size2);
        }
        if (size2 == 0) {
            return new byte[0];
        }
        byte[] data2 = new byte[size2];
        for (offset = 0; offset < size2 && (readed = input2.read(data2, offset, size2 - offset)) != -1; offset += readed) {
        }
        if (offset != size2) {
            throw new IOException("Unexpected readed size. current: " + offset + ", excepted: " + size2);
        }
        return data2;
    }

    @Deprecated
    public static byte[] toByteArray(Reader input2) throws IOException {
        return IOUtils.toByteArray(input2, Charset.defaultCharset());
    }

    public static byte[] toByteArray(Reader input2, Charset encoding) throws IOException {
        ByteArrayOutputStream output2 = new ByteArrayOutputStream();
        IOUtils.copy(input2, (OutputStream)output2, encoding);
        return output2.toByteArray();
    }

    public static byte[] toByteArray(Reader input2, String encoding) throws IOException {
        return IOUtils.toByteArray(input2, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static byte[] toByteArray(String input2) throws IOException {
        return input2.getBytes(Charset.defaultCharset());
    }

    public static byte[] toByteArray(URI uri2) throws IOException {
        return IOUtils.toByteArray(uri2.toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(URL url2) throws IOException {
        URLConnection conn = url2.openConnection();
        try {
            byte[] byArray = IOUtils.toByteArray(conn);
            return byArray;
        }
        finally {
            IOUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(URLConnection urlConn) throws IOException {
        InputStream inputStream2 = urlConn.getInputStream();
        try {
            byte[] byArray = IOUtils.toByteArray(inputStream2);
            return byArray;
        }
        finally {
            inputStream2.close();
        }
    }

    @Deprecated
    public static char[] toCharArray(InputStream is) throws IOException {
        return IOUtils.toCharArray(is, Charset.defaultCharset());
    }

    public static char[] toCharArray(InputStream is, Charset encoding) throws IOException {
        CharArrayWriter output2 = new CharArrayWriter();
        IOUtils.copy(is, (Writer)output2, encoding);
        return output2.toCharArray();
    }

    public static char[] toCharArray(InputStream is, String encoding) throws IOException {
        return IOUtils.toCharArray(is, Charsets.toCharset(encoding));
    }

    public static char[] toCharArray(Reader input2) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IOUtils.copy(input2, (Writer)sw);
        return sw.toCharArray();
    }

    @Deprecated
    public static String toString(InputStream input2) throws IOException {
        return IOUtils.toString(input2, Charset.defaultCharset());
    }

    public static String toString(InputStream input2, Charset encoding) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        IOUtils.copy(input2, (Writer)sw, encoding);
        return sw.toString();
    }

    public static String toString(InputStream input2, String encoding) throws IOException {
        return IOUtils.toString(input2, Charsets.toCharset(encoding));
    }

    public static String toString(Reader input2) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        IOUtils.copy(input2, (Writer)sw);
        return sw.toString();
    }

    @Deprecated
    public static String toString(URI uri2) throws IOException {
        return IOUtils.toString(uri2, Charset.defaultCharset());
    }

    public static String toString(URI uri2, Charset encoding) throws IOException {
        return IOUtils.toString(uri2.toURL(), Charsets.toCharset(encoding));
    }

    public static String toString(URI uri2, String encoding) throws IOException {
        return IOUtils.toString(uri2, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static String toString(URL url2) throws IOException {
        return IOUtils.toString(url2, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(URL url2, Charset encoding) throws IOException {
        InputStream inputStream2 = url2.openStream();
        try {
            String string = IOUtils.toString(inputStream2, encoding);
            return string;
        }
        finally {
            inputStream2.close();
        }
    }

    public static String toString(URL url2, String encoding) throws IOException {
        return IOUtils.toString(url2, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static String toString(byte[] input2) throws IOException {
        return new String(input2, Charset.defaultCharset());
    }

    public static String toString(byte[] input2, String encoding) throws IOException {
        return new String(input2, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static List<String> readLines(InputStream input2) throws IOException {
        return IOUtils.readLines(input2, Charset.defaultCharset());
    }

    public static List<String> readLines(InputStream input2, Charset encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader(input2, Charsets.toCharset(encoding));
        return IOUtils.readLines(reader);
    }

    public static List<String> readLines(InputStream input2, String encoding) throws IOException {
        return IOUtils.readLines(input2, Charsets.toCharset(encoding));
    }

    public static List<String> readLines(Reader input2) throws IOException {
        BufferedReader reader = IOUtils.toBufferedReader(input2);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static LineIterator lineIterator(InputStream input2, Charset encoding) throws IOException {
        return new LineIterator(new InputStreamReader(input2, Charsets.toCharset(encoding)));
    }

    public static LineIterator lineIterator(InputStream input2, String encoding) throws IOException {
        return IOUtils.lineIterator(input2, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static InputStream toInputStream(CharSequence input2) {
        return IOUtils.toInputStream(input2, Charset.defaultCharset());
    }

    public static InputStream toInputStream(CharSequence input2, Charset encoding) {
        return IOUtils.toInputStream(input2.toString(), encoding);
    }

    public static InputStream toInputStream(CharSequence input2, String encoding) throws IOException {
        return IOUtils.toInputStream(input2, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static InputStream toInputStream(String input2) {
        return IOUtils.toInputStream(input2, Charset.defaultCharset());
    }

    public static InputStream toInputStream(String input2, Charset encoding) {
        return new ByteArrayInputStream(input2.getBytes(Charsets.toCharset(encoding)));
    }

    public static InputStream toInputStream(String input2, String encoding) throws IOException {
        byte[] bytes = input2.getBytes(Charsets.toCharset(encoding));
        return new ByteArrayInputStream(bytes);
    }

    public static void write(byte[] data2, OutputStream output2) throws IOException {
        if (data2 != null) {
            output2.write(data2);
        }
    }

    public static void writeChunked(byte[] data2, OutputStream output2) throws IOException {
        if (data2 != null) {
            int bytes = data2.length;
            int offset = 0;
            while (bytes > 0) {
                int chunk = Math.min(bytes, 4096);
                output2.write(data2, offset, chunk);
                bytes -= chunk;
                offset += chunk;
            }
        }
    }

    @Deprecated
    public static void write(byte[] data2, Writer output2) throws IOException {
        IOUtils.write(data2, output2, Charset.defaultCharset());
    }

    public static void write(byte[] data2, Writer output2, Charset encoding) throws IOException {
        if (data2 != null) {
            output2.write(new String(data2, Charsets.toCharset(encoding)));
        }
    }

    public static void write(byte[] data2, Writer output2, String encoding) throws IOException {
        IOUtils.write(data2, output2, Charsets.toCharset(encoding));
    }

    public static void write(char[] data2, Writer output2) throws IOException {
        if (data2 != null) {
            output2.write(data2);
        }
    }

    public static void writeChunked(char[] data2, Writer output2) throws IOException {
        if (data2 != null) {
            int bytes = data2.length;
            int offset = 0;
            while (bytes > 0) {
                int chunk = Math.min(bytes, 4096);
                output2.write(data2, offset, chunk);
                bytes -= chunk;
                offset += chunk;
            }
        }
    }

    @Deprecated
    public static void write(char[] data2, OutputStream output2) throws IOException {
        IOUtils.write(data2, output2, Charset.defaultCharset());
    }

    public static void write(char[] data2, OutputStream output2, Charset encoding) throws IOException {
        if (data2 != null) {
            output2.write(new String(data2).getBytes(Charsets.toCharset(encoding)));
        }
    }

    public static void write(char[] data2, OutputStream output2, String encoding) throws IOException {
        IOUtils.write(data2, output2, Charsets.toCharset(encoding));
    }

    public static void write(CharSequence data2, Writer output2) throws IOException {
        if (data2 != null) {
            IOUtils.write(data2.toString(), output2);
        }
    }

    @Deprecated
    public static void write(CharSequence data2, OutputStream output2) throws IOException {
        IOUtils.write(data2, output2, Charset.defaultCharset());
    }

    public static void write(CharSequence data2, OutputStream output2, Charset encoding) throws IOException {
        if (data2 != null) {
            IOUtils.write(data2.toString(), output2, encoding);
        }
    }

    public static void write(CharSequence data2, OutputStream output2, String encoding) throws IOException {
        IOUtils.write(data2, output2, Charsets.toCharset(encoding));
    }

    public static void write(String data2, Writer output2) throws IOException {
        if (data2 != null) {
            output2.write(data2);
        }
    }

    @Deprecated
    public static void write(String data2, OutputStream output2) throws IOException {
        IOUtils.write(data2, output2, Charset.defaultCharset());
    }

    public static void write(String data2, OutputStream output2, Charset encoding) throws IOException {
        if (data2 != null) {
            output2.write(data2.getBytes(Charsets.toCharset(encoding)));
        }
    }

    public static void write(String data2, OutputStream output2, String encoding) throws IOException {
        IOUtils.write(data2, output2, Charsets.toCharset(encoding));
    }

    @Deprecated
    public static void write(StringBuffer data2, Writer output2) throws IOException {
        if (data2 != null) {
            output2.write(data2.toString());
        }
    }

    @Deprecated
    public static void write(StringBuffer data2, OutputStream output2) throws IOException {
        IOUtils.write(data2, output2, (String)null);
    }

    @Deprecated
    public static void write(StringBuffer data2, OutputStream output2, String encoding) throws IOException {
        if (data2 != null) {
            output2.write(data2.toString().getBytes(Charsets.toCharset(encoding)));
        }
    }

    @Deprecated
    public static void writeLines(Collection<?> lines, String lineEnding, OutputStream output2) throws IOException {
        IOUtils.writeLines(lines, lineEnding, output2, Charset.defaultCharset());
    }

    public static void writeLines(Collection<?> lines, String lineEnding, OutputStream output2, Charset encoding) throws IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_SEPARATOR;
        }
        Charset cs = Charsets.toCharset(encoding);
        for (Object line : lines) {
            if (line != null) {
                output2.write(line.toString().getBytes(cs));
            }
            output2.write(lineEnding.getBytes(cs));
        }
    }

    public static void writeLines(Collection<?> lines, String lineEnding, OutputStream output2, String encoding) throws IOException {
        IOUtils.writeLines(lines, lineEnding, output2, Charsets.toCharset(encoding));
    }

    public static void writeLines(Collection<?> lines, String lineEnding, Writer writer) throws IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_SEPARATOR;
        }
        for (Object line : lines) {
            if (line != null) {
                writer.write(line.toString());
            }
            writer.write(lineEnding);
        }
    }

    public static int copy(InputStream input2, OutputStream output2) throws IOException {
        long count2 = IOUtils.copyLarge(input2, output2);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copy(InputStream input2, OutputStream output2, int bufferSize) throws IOException {
        return IOUtils.copyLarge(input2, output2, new byte[bufferSize]);
    }

    public static long copyLarge(InputStream input2, OutputStream output2) throws IOException {
        return IOUtils.copy(input2, output2, 4096);
    }

    public static long copyLarge(InputStream input2, OutputStream output2, byte[] buffer) throws IOException {
        int n;
        long count2 = 0L;
        while (-1 != (n = input2.read(buffer))) {
            output2.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static long copyLarge(InputStream input2, OutputStream output2, long inputOffset, long length) throws IOException {
        return IOUtils.copyLarge(input2, output2, inputOffset, length, new byte[4096]);
    }

    public static long copyLarge(InputStream input2, OutputStream output2, long inputOffset, long length, byte[] buffer) throws IOException {
        int read2;
        int bufferLength;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input2, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = bufferLength = buffer.length;
        if (length > 0L && length < (long)bufferLength) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read2 = input2.read(buffer, 0, bytesToRead))) {
            output2.write(buffer, 0, read2);
            totalRead += (long)read2;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)bufferLength);
        }
        return totalRead;
    }

    @Deprecated
    public static void copy(InputStream input2, Writer output2) throws IOException {
        IOUtils.copy(input2, output2, Charset.defaultCharset());
    }

    public static void copy(InputStream input2, Writer output2, Charset inputEncoding) throws IOException {
        InputStreamReader in = new InputStreamReader(input2, Charsets.toCharset(inputEncoding));
        IOUtils.copy((Reader)in, output2);
    }

    public static void copy(InputStream input2, Writer output2, String inputEncoding) throws IOException {
        IOUtils.copy(input2, output2, Charsets.toCharset(inputEncoding));
    }

    public static int copy(Reader input2, Writer output2) throws IOException {
        long count2 = IOUtils.copyLarge(input2, output2);
        if (count2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count2;
    }

    public static long copyLarge(Reader input2, Writer output2) throws IOException {
        return IOUtils.copyLarge(input2, output2, new char[4096]);
    }

    public static long copyLarge(Reader input2, Writer output2, char[] buffer) throws IOException {
        int n;
        long count2 = 0L;
        while (-1 != (n = input2.read(buffer))) {
            output2.write(buffer, 0, n);
            count2 += (long)n;
        }
        return count2;
    }

    public static long copyLarge(Reader input2, Writer output2, long inputOffset, long length) throws IOException {
        return IOUtils.copyLarge(input2, output2, inputOffset, length, new char[4096]);
    }

    public static long copyLarge(Reader input2, Writer output2, long inputOffset, long length, char[] buffer) throws IOException {
        int read2;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input2, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = buffer.length;
        if (length > 0L && length < (long)buffer.length) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read2 = input2.read(buffer, 0, bytesToRead))) {
            output2.write(buffer, 0, read2);
            totalRead += (long)read2;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)buffer.length);
        }
        return totalRead;
    }

    @Deprecated
    public static void copy(Reader input2, OutputStream output2) throws IOException {
        IOUtils.copy(input2, output2, Charset.defaultCharset());
    }

    public static void copy(Reader input2, OutputStream output2, Charset outputEncoding) throws IOException {
        OutputStreamWriter out2 = new OutputStreamWriter(output2, Charsets.toCharset(outputEncoding));
        IOUtils.copy(input2, (Writer)out2);
        out2.flush();
    }

    public static void copy(Reader input2, OutputStream output2, String outputEncoding) throws IOException {
        IOUtils.copy(input2, output2, Charsets.toCharset(outputEncoding));
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (input1 == input2) {
            return true;
        }
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IOException {
        int ch2;
        if (input1 == input2) {
            return true;
        }
        input1 = IOUtils.toBufferedReader(input1);
        input2 = IOUtils.toBufferedReader(input2);
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws IOException {
        if (input1 == input2) {
            return true;
        }
        BufferedReader br1 = IOUtils.toBufferedReader(input1);
        BufferedReader br2 = IOUtils.toBufferedReader(input2);
        String line1 = br1.readLine();
        String line2 = br2.readLine();
        while (line1 != null && line2 != null && line1.equals(line2)) {
            line1 = br1.readLine();
            line2 = br2.readLine();
        }
        return line1 == null ? line2 == null : line1.equals(line2);
    }

    public static long skip(InputStream input2, long toSkip) throws IOException {
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (SKIP_BYTE_BUFFER == null) {
            SKIP_BYTE_BUFFER = new byte[2048];
        }
        for (remain = toSkip; remain > 0L && (n = (long)input2.read(SKIP_BYTE_BUFFER, 0, (int)Math.min(remain, 2048L))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static long skip(ReadableByteChannel input2, long toSkip) throws IOException {
        long remain;
        int n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        ByteBuffer skipByteBuffer = ByteBuffer.allocate((int)Math.min(toSkip, 2048L));
        for (remain = toSkip; remain > 0L; remain -= (long)n) {
            skipByteBuffer.position(0);
            skipByteBuffer.limit((int)Math.min(remain, 2048L));
            n = input2.read(skipByteBuffer);
            if (n == -1) break;
        }
        return toSkip - remain;
    }

    public static long skip(Reader input2, long toSkip) throws IOException {
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (SKIP_CHAR_BUFFER == null) {
            SKIP_CHAR_BUFFER = new char[2048];
        }
        for (remain = toSkip; remain > 0L && (n = (long)input2.read(SKIP_CHAR_BUFFER, 0, (int)Math.min(remain, 2048L))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static void skipFully(InputStream input2, long toSkip) throws IOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtils.skip(input2, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static void skipFully(ReadableByteChannel input2, long toSkip) throws IOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtils.skip(input2, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static void skipFully(Reader input2, long toSkip) throws IOException {
        long skipped = IOUtils.skip(input2, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Chars to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static int read(Reader input2, char[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count2;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count2 = input2.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count2) {
        }
        return length - remaining;
    }

    public static int read(Reader input2, char[] buffer) throws IOException {
        return IOUtils.read(input2, buffer, 0, buffer.length);
    }

    public static int read(InputStream input2, byte[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count2;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count2 = input2.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count2) {
        }
        return length - remaining;
    }

    public static int read(InputStream input2, byte[] buffer) throws IOException {
        return IOUtils.read(input2, buffer, 0, buffer.length);
    }

    public static int read(ReadableByteChannel input2, ByteBuffer buffer) throws IOException {
        int count2;
        int length = buffer.remaining();
        while (buffer.remaining() > 0 && -1 != (count2 = input2.read(buffer))) {
        }
        return length - buffer.remaining();
    }

    public static void readFully(Reader input2, char[] buffer, int offset, int length) throws IOException {
        int actual = IOUtils.read(input2, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    public static void readFully(Reader input2, char[] buffer) throws IOException {
        IOUtils.readFully(input2, buffer, 0, buffer.length);
    }

    public static void readFully(InputStream input2, byte[] buffer, int offset, int length) throws IOException {
        int actual = IOUtils.read(input2, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    public static void readFully(InputStream input2, byte[] buffer) throws IOException {
        IOUtils.readFully(input2, buffer, 0, buffer.length);
    }

    public static byte[] readFully(InputStream input2, int length) throws IOException {
        byte[] buffer = new byte[length];
        IOUtils.readFully(input2, buffer, 0, buffer.length);
        return buffer;
    }

    public static void readFully(ReadableByteChannel input2, ByteBuffer buffer) throws IOException {
        int expected = buffer.remaining();
        int actual = IOUtils.read(input2, buffer);
        if (actual != expected) {
            throw new EOFException("Length to read: " + expected + " actual: " + actual);
        }
    }

    static {
        StringBuilderWriter buf = new StringBuilderWriter(4);
        PrintWriter out2 = new PrintWriter(buf);
        out2.println();
        LINE_SEPARATOR = buf.toString();
        out2.close();
    }
}

