/*
 * Decompiled with CFR 0.152.
 */
package org.osjava.sj.loader;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osjava.StringUtils;
import org.osjava.sj.jndi.JndiUtils;
import org.osjava.sj.loader.convert.ConverterIF;
import org.osjava.sj.loader.convert.ConverterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiLoader {
    public static final String DELIMITER = "org.osjava.sj.delimiter";
    public static final String COLON_REPLACE = "org.osjava.sj.colon.replace";
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private static ConverterRegistry converterRegistry = new ConverterRegistry();
    private final Properties envAsProperties;
    Hashtable environment = new Hashtable();
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final String FILENAME_TO_CONTEXT = "org.osjava.sj.filenameToContext";

    public JndiLoader(Hashtable env) {
        this.environment = new Hashtable(env);
        if (!this.environment.containsKey(DELIMITER)) {
            this.LOGGER.info("{} not set. Setting to \".\"", (Object)DELIMITER);
            this.environment.put(DELIMITER, ".");
        }
        if (!this.environment.containsKey("jndi.syntax.direction")) {
            this.LOGGER.warn("jndi.syntax.direction not set. Setting to \"left_to_right\"");
            this.environment.put("jndi.syntax.direction", "left_to_right");
        }
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.environment);
        this.envAsProperties = props;
    }

    boolean isNotNamespacedTypeDefinition(Properties properties2) {
        for (Object k : properties2.keySet()) {
            String key2 = (String)k;
            if (!key2.equals("type")) continue;
            return true;
        }
        return false;
    }

    String handleColonReplacement(String name) {
        String colonReplace = (String)this.environment.get(COLON_REPLACE);
        if (colonReplace != null && name.contains(colonReplace)) {
            name = StringUtils.replace(name, colonReplace, ":");
        }
        return name;
    }

    public void load(Properties properties2, Context ctxt) throws NamingException {
        this.load(properties2, ctxt, null, "");
    }

    void load(Properties properties2, Context subContext, Context parentCtxt, String subName) throws NamingException {
        Map<String, Properties> typeMap = this.extractTypedProperties(properties2);
        for (String iterator2 : properties2.keySet()) {
            Object value = properties2.get(iterator2);
            String delimiter = this.extractDelimiter(iterator2);
            if (iterator2.equals("type") || this.extractTypeDeclaration(iterator2) != null) continue;
            if (typeMap.containsKey("datasourceOrBeanProperty")) {
                typeMap.get("datasourceOrBeanProperty").put(iterator2, value);
                continue;
            }
            if (typeMap.containsKey(iterator2)) {
                typeMap.get(iterator2).put("valueToConvert", value);
                continue;
            }
            if (delimiter != null) {
                String pathText = JndiLoader.removeLastElement(iterator2, delimiter);
                String nodeText = JndiLoader.getLastElement(iterator2, delimiter);
                if (typeMap.containsKey(pathText)) {
                    typeMap.get(pathText).put(nodeText, value);
                    continue;
                }
                this.jndiPut(subContext, iterator2, value);
                continue;
            }
            this.jndiPut(subContext, iterator2, value);
        }
        Iterator<String> iterator2 = typeMap.keySet().iterator();
        while (iterator2.hasNext()) {
            String key3;
            String typeKey = key3 = iterator2.next();
            Properties typeProperties = typeMap.get(typeKey);
            Object value = this.convert(typeProperties);
            if (typeKey.equals("datasourceOrBeanProperty")) {
                parentCtxt.rebind(subName, value);
                continue;
            }
            this.jndiPut(subContext, typeKey, value);
        }
    }

    @NotNull
    Map<String, Properties> extractTypedProperties(Properties properties2) throws InvalidNameException {
        HashMap<String, Properties> typeMap = new HashMap<String, Properties>();
        for (String string : properties2.keySet()) {
            String type2 = this.extractTypeDeclaration(string);
            if (!string.equals("type") && type2 == null) continue;
            Properties props = new Properties();
            props.put("type", properties2.get(string));
            if (string.equals("type")) {
                typeMap.put("datasourceOrBeanProperty", props);
                continue;
            }
            String keyWithoutType = string.substring(0, string.length() - type2.length() - 1);
            typeMap.put(keyWithoutType, props);
        }
        HashMap<String, Properties> hashMap = typeMap;
        if (hashMap == null) {
            JndiLoader.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    private void processTypedProperty(Properties properties2, Context subContext, String subName) throws NamingException {
        Properties notNamespacedKeys;
        Name objName;
        Context deepestCtx;
        if (this.isNotNamespacedTypeDefinition(properties2)) {
            String typeDefinition = this.getTypeDefinition(properties2);
            Name contextName = this.extractContextName(typeDefinition);
            deepestCtx = subContext;
            if (contextName != null) {
                if (contextName.size() > 1) {
                    contextName.remove(contextName.size() - 1);
                    deepestCtx = this.createSubContexts(contextName, subContext);
                    objName = contextName.getSuffix(contextName.size() - 1);
                } else {
                    objName = contextName;
                }
            } else {
                objName = new CompoundName(subName, EMPTY_PROPERTIES);
            }
            notNamespacedKeys = new Properties();
            for (Object k : properties2.keySet()) {
                String key2 = (String)k;
                key2 = this.extractObjectName(key2);
                String value = (String)properties2.get(key2);
                notNamespacedKeys.put(key2, value);
            }
        } else {
            throw new RuntimeException("Not implemented yet.");
        }
        this.jndiPut(deepestCtx, objName.toString(), this.convert(notNamespacedKeys));
    }

    @Nullable
    String getTypeDefinition(@NotNull Properties properties2) {
        if (properties2 == null) {
            JndiLoader.$$$reportNull$$$0(1);
        }
        for (Object k : properties2.keySet()) {
            String key2 = (String)k;
            if (!key2.endsWith("type")) continue;
            return key2;
        }
        return null;
    }

    @Nullable
    Name extractContextName(String path) throws InvalidNameException {
        CompoundName name = this.toCompoundName(path);
        Name nameWithoutObjectName = name.size() > 1 ? name.getPrefix(name.size() - 1) : null;
        return nameWithoutObjectName;
    }

    @NotNull
    String extractObjectName(String path) throws InvalidNameException {
        CompoundName name;
        String string = name.getSuffix((name = this.toCompoundName(path)).size() > 1 ? name.size() - 1 : 0).toString();
        if (string == null) {
            JndiLoader.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    CompoundName toCompoundName(@NotNull String path) throws InvalidNameException {
        if (path == null) {
            JndiLoader.$$$reportNull$$$0(3);
        }
        CompoundName compoundName = JndiUtils.toCompoundName(path, this.envAsProperties);
        if (compoundName == null) {
            JndiLoader.$$$reportNull$$$0(4);
        }
        return compoundName;
    }

    private String extractDelimiter(String key2) {
        Pattern pattern;
        Matcher matcher;
        String delimiter = (String)this.environment.get(DELIMITER);
        if (delimiter.length() == 1) {
            delimiter = delimiter.replace(".", "\\.");
        }
        if ((matcher = (pattern = Pattern.compile("^.+(" + delimiter + ").+")).matcher(key2)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Nullable
    private String extractTypeDeclaration(@NotNull String key2) throws InvalidNameException {
        String objName;
        if (key2 == null) {
            JndiLoader.$$$reportNull$$$0(5);
        }
        return (objName = this.extractObjectName(key2)).equals("type") ? objName : null;
    }

    private void jndiPut(Context ctxt, String key2, Object value) throws NamingException {
        Name name = this.extractContextName(key2);
        if (name != null) {
            Context deepestCtx = this.createSubContexts(name, ctxt);
            deepestCtx.bind(this.extractObjectName(key2), value);
        } else {
            ctxt.bind(this.toCompoundName(key2), value);
        }
    }

    Context createSubContexts(Name name, Context parentContext) throws NamingException {
        Context currentCtx = parentContext;
        for (int i2 = 0; i2 < name.size(); ++i2) {
            try {
                Object obj = currentCtx.lookup(name.get(i2));
                if (!(obj instanceof Context)) {
                    this.LOGGER.error("createSubContexts() CompoundName={} Name '{}' already occupied by '{}'.", name, name.get(i2), obj);
                    throw new NotContextException(name.get(i2) + " already occupied by " + obj);
                }
                currentCtx = (Context)obj;
                continue;
            }
            catch (NameNotFoundException e) {
                currentCtx = currentCtx.createSubcontext(name.get(i2));
            }
        }
        return currentCtx;
    }

    @Nullable
    private Object convert(Properties properties2) {
        String type2 = properties2.getProperty("type");
        Object obj = properties2.get("valueToConvert");
        String converterClassName = properties2.getProperty("converter");
        obj = converterClassName != null ? JndiLoader.callConverter(properties2, type2, converterClassName) : this.processType(properties2, type2, obj);
        return obj;
    }

    @Nullable
    Object processType(Properties properties2, String type2, Object obj) {
        block12: {
            if (properties2.containsKey("type")) {
                if (properties2.containsKey("javaxNamingSpiObjectFactory")) {
                    obj = JndiUtils.toReference(properties2, type2);
                } else {
                    ConverterIF converter = converterRegistry.getConverter(type2);
                    if (converter != null) {
                        Object values2 = properties2.get("valueToConvert");
                        if (values2 instanceof List) {
                            List vals = (List)values2;
                            LinkedList<Object> converted = new LinkedList<Object>();
                            for (String val : vals) {
                                Properties props = new Properties();
                                props.setProperty("valueToConvert", val);
                                converted.add(converter.convert(props, type2));
                            }
                            obj = converted;
                        } else {
                            try {
                                obj = converter.convert(properties2, type2);
                            }
                            catch (IllegalArgumentException e) {
                                if (type2.equals("javax.sql.DataSource") && this.environment.containsKey("java.naming.factory.object")) {
                                    obj = JndiUtils.toReference(properties2, type2);
                                    break block12;
                                }
                                this.LOGGER.error("", e);
                            }
                        }
                    } else if (this.environment.containsKey("java.naming.factory.object")) {
                        obj = JndiUtils.toReference(properties2, type2);
                    }
                }
            }
        }
        return obj;
    }

    private static Object callConverter(Properties properties2, String type2, String converterClassName) {
        Object obj;
        try {
            Class<?> converterClass = Class.forName(converterClassName);
            ConverterIF converter = (ConverterIF)converterClass.newInstance();
            obj = converter.convert(properties2, type2);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Unable to find class: " + converterClassName, cnfe);
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException("Unable to access class: " + type2, ie);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("Unable to create Converter " + type2 + " via empty constructor. ", ie);
        }
        return obj;
    }

    private static String getLastElement(String str, String delimiter) {
        int idx = str.lastIndexOf(delimiter);
        return str.substring(idx + 1);
    }

    private static String removeLastElement(String str, String delimiter) {
        int idx = str.lastIndexOf(delimiter);
        return str.substring(0, idx);
    }

    protected boolean isSupportedFile(@NotNull File file2) {
        if (file2 == null) {
            JndiLoader.$$$reportNull$$$0(6);
        }
        String[] extensionsToProcess = new String[]{"properties", "ini", "xml"};
        String ext = FilenameUtils.getExtension(file2.getName());
        for (String extToProcess : extensionsToProcess) {
            if (!extToProcess.equals(ext)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/osjava/sj/loader/JndiLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTypedProperties";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/osjava/sj/loader/JndiLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractObjectName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toCompoundName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeDefinition";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toCompoundName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractTypeDeclaration";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

