/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMessage;
import io.ktor.http.HttpMessageBuilder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0017\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0019\u0010\t\u001a\u00020\b*\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0002*\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0013\u0010\r\u001a\u0004\u0018\u00010\u0002*\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\f\u001a\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0002*\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000f\u001a\u0013\u0010\r\u001a\u0004\u0018\u00010\u0002*\u00020\u000e\u00a2\u0006\u0004\b\r\u0010\u000f\u001a\u0013\u0010\u0001\u001a\u0004\u0018\u00010\u0002*\u00020\u000e\u00a2\u0006\u0004\b\u0001\u0010\u000f\"\u0014\u0010\u0013\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"", "date", "Ljava/util/Date;", "parseHttpDate", "(Ljava/lang/String;)Ljava/util/Date;", "formatHttpDate", "(Ljava/util/Date;)Ljava/lang/String;", "Lio/ktor/http/HttpMessageBuilder;", "", "ifModifiedSince", "(Lio/ktor/http/HttpMessageBuilder;Ljava/util/Date;)V", "lastModified", "(Lio/ktor/http/HttpMessageBuilder;)Ljava/util/Date;", "expires", "Lio/ktor/http/HttpMessage;", "(Lio/ktor/http/HttpMessage;)Ljava/util/Date;", "Ljava/text/SimpleDateFormat;", "getHTTP_DATE_FORMAT", "()Ljava/text/SimpleDateFormat;", "HTTP_DATE_FORMAT", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nHttpMessagePropertiesJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpMessagePropertiesJvm.kt\nio/ktor/http/HttpMessagePropertiesJvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class HttpMessagePropertiesJvmKt {
    private static final SimpleDateFormat getHTTP_DATE_FORMAT() {
        SimpleDateFormat simpleDateFormat;
        SimpleDateFormat $this$_get_HTTP_DATE_FORMAT__u24lambda_u240 = simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        boolean bl = false;
        $this$_get_HTTP_DATE_FORMAT__u24lambda_u240.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    }

    private static final Date parseHttpDate(String date) {
        Date date2 = HttpMessagePropertiesJvmKt.getHTTP_DATE_FORMAT().parse(date);
        Intrinsics.checkNotNullExpressionValue(date2, "parse(...)");
        return date2;
    }

    private static final String formatHttpDate(Date date) {
        String string2 = HttpMessagePropertiesJvmKt.getHTTP_DATE_FORMAT().format(date);
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return string2;
    }

    public static final void ifModifiedSince(@NotNull HttpMessageBuilder $this$ifModifiedSince, @NotNull Date date) {
        Intrinsics.checkNotNullParameter($this$ifModifiedSince, "<this>");
        Intrinsics.checkNotNullParameter(date, "date");
        $this$ifModifiedSince.getHeaders().set(HttpHeaders.INSTANCE.getIfModifiedSince(), HttpMessagePropertiesJvmKt.formatHttpDate(date));
    }

    @Nullable
    public static final Date lastModified(@NotNull HttpMessageBuilder $this$lastModified) {
        Date date;
        Intrinsics.checkNotNullParameter($this$lastModified, "<this>");
        String string2 = $this$lastModified.getHeaders().get(HttpHeaders.INSTANCE.getLastModified());
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date expires(@NotNull HttpMessageBuilder $this$expires) {
        Date date;
        Intrinsics.checkNotNullParameter($this$expires, "<this>");
        String string2 = $this$expires.getHeaders().get(HttpHeaders.INSTANCE.getExpires());
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date lastModified(@NotNull HttpMessage $this$lastModified) {
        Date date;
        Intrinsics.checkNotNullParameter($this$lastModified, "<this>");
        String string2 = $this$lastModified.getHeaders().get(HttpHeaders.INSTANCE.getLastModified());
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date expires(@NotNull HttpMessage $this$expires) {
        Date date;
        Intrinsics.checkNotNullParameter($this$expires, "<this>");
        String string2 = $this$expires.getHeaders().get(HttpHeaders.INSTANCE.getExpires());
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }

    @Nullable
    public static final Date date(@NotNull HttpMessage $this$date) {
        Date date;
        Intrinsics.checkNotNullParameter($this$date, "<this>");
        String string2 = $this$date.getHeaders().get(HttpHeaders.INSTANCE.getDate());
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            date = HttpMessagePropertiesJvmKt.parseHttpDate(it);
        } else {
            date = null;
        }
        return date;
    }
}

