/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal.format;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.internal.format.FieldFormatDirective;
import kotlinx.datetime.internal.format.UnsignedFieldSpec;
import kotlinx.datetime.internal.format.formatter.FormatterStructure;
import kotlinx.datetime.internal.format.formatter.StringFormatterStructure;
import kotlinx.datetime.internal.format.parser.AssignableField;
import kotlinx.datetime.internal.format.parser.ParserStructure;
import kotlinx.datetime.internal.format.parser.StringSetParserOperation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0014B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lkotlinx/datetime/internal/format/NamedUnsignedIntFieldFormatDirective;", "Target", "Lkotlinx/datetime/internal/format/FieldFormatDirective;", "field", "Lkotlinx/datetime/internal/format/UnsignedFieldSpec;", "values", "", "", "name", "<init>", "(Lkotlinx/datetime/internal/format/UnsignedFieldSpec;Ljava/util/List;Ljava/lang/String;)V", "getField", "()Lkotlinx/datetime/internal/format/UnsignedFieldSpec;", "getStringValue", "target", "(Ljava/lang/Object;)Ljava/lang/String;", "formatter", "Lkotlinx/datetime/internal/format/formatter/FormatterStructure;", "parser", "Lkotlinx/datetime/internal/format/parser/ParserStructure;", "AssignableString", "kotlinx-datetime"})
public abstract class NamedUnsignedIntFieldFormatDirective<Target>
implements FieldFormatDirective<Target> {
    @NotNull
    private final UnsignedFieldSpec<Target> field;
    @NotNull
    private final List<String> values;
    @NotNull
    private final String name;

    public NamedUnsignedIntFieldFormatDirective(@NotNull UnsignedFieldSpec<? super Target> field, @NotNull List<String> values2, @NotNull String name) {
        Intrinsics.checkNotNullParameter(field, "field");
        Intrinsics.checkNotNullParameter(values2, "values");
        Intrinsics.checkNotNullParameter(name, "name");
        this.field = field;
        this.values = values2;
        this.name = name;
        if (!(this.values.size() == this.field.getMaxValue() - this.field.getMinValue() + 1)) {
            boolean bl = false;
            String string2 = "The number of values (" + this.values.size() + ") in " + this.values + " does not match the range of the field (" + (this.field.getMaxValue() - this.field.getMinValue() + 1) + ')';
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final UnsignedFieldSpec<Target> getField() {
        return this.field;
    }

    private final String getStringValue(Target target) {
        int it = ((Number)this.field.getAccessor().getterNotNull(target)).intValue();
        boolean bl = false;
        String string2 = CollectionsKt.getOrNull(this.values, it - this.field.getMinValue());
        if (string2 == null) {
            string2 = "The value " + it + " of " + this.field.getName() + " does not have a corresponding string representation";
        }
        return string2;
    }

    @Override
    @NotNull
    public FormatterStructure<Target> formatter() {
        return new StringFormatterStructure(new Function1<Target, String>(this){

            public final String invoke(Target p0) {
                return NamedUnsignedIntFieldFormatDirective.access$getStringValue((NamedUnsignedIntFieldFormatDirective)this.receiver, p0);
            }
        });
    }

    @Override
    @NotNull
    public ParserStructure<Target> parser() {
        return new ParserStructure(CollectionsKt.listOf(new StringSetParserOperation((Collection<String>)this.values, new AssignableString(), "one of " + this.values + " for " + this.name)), CollectionsKt.emptyList());
    }

    public static final /* synthetic */ String access$getStringValue(NamedUnsignedIntFieldFormatDirective $this, Object target) {
        return $this.getStringValue(target);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lkotlinx/datetime/internal/format/NamedUnsignedIntFieldFormatDirective$AssignableString;", "Lkotlinx/datetime/internal/format/parser/AssignableField;", "", "<init>", "(Lkotlinx/datetime/internal/format/NamedUnsignedIntFieldFormatDirective;)V", "trySetWithoutReassigning", "container", "newValue", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/String;", "name", "getName", "()Ljava/lang/String;", "kotlinx-datetime"})
    private final class AssignableString
    implements AssignableField<Target, String> {
        @Override
        @Nullable
        public String trySetWithoutReassigning(Target container2, @NotNull String newValue) {
            String string2;
            Intrinsics.checkNotNullParameter(newValue, "newValue");
            Integer n = ((UnsignedFieldSpec)NamedUnsignedIntFieldFormatDirective.this.getField()).getAccessor().trySetWithoutReassigning(container2, NamedUnsignedIntFieldFormatDirective.this.values.indexOf(newValue) + ((UnsignedFieldSpec)NamedUnsignedIntFieldFormatDirective.this.getField()).getMinValue());
            if (n != null) {
                Integer n2 = n;
                NamedUnsignedIntFieldFormatDirective namedUnsignedIntFieldFormatDirective = NamedUnsignedIntFieldFormatDirective.this;
                int it = ((Number)n2).intValue();
                boolean bl = false;
                string2 = (String)namedUnsignedIntFieldFormatDirective.values.get(it - ((UnsignedFieldSpec)namedUnsignedIntFieldFormatDirective.getField()).getMinValue());
            } else {
                string2 = null;
            }
            return string2;
        }

        @Override
        @NotNull
        public String getName() {
            return NamedUnsignedIntFieldFormatDirective.this.name;
        }
    }
}

