/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.account.passkey;

import androidx.compose.runtime.internal.StabilityInferred;
import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.converter.exception.DataConversionException;
import com.webauthn4j.credential.CredentialRecord;
import com.webauthn4j.credential.CredentialRecordImpl;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.server.ServerProperty;
import io.github.aakira.napier.Napier;
import java.util.Base64;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import world.respect.credentials.passkey.RespectUserHandle;
import world.respect.credentials.passkey.model.AuthenticationResponseJSON;
import world.respect.credentials.passkey.model.ClientDataJSON;
import world.respect.credentials.passkey.model.PasskeyVerifyResult;
import world.respect.credentials.passkey.request.DecodeUserHandleUseCase;
import world.respect.datalayer.db.RespectSchoolDatabase;
import world.respect.datalayer.db.school.entities.PersonPasskeyEntity;
import world.respect.libutil.util.throwable.ExceptionWithHttpStatusCodeKt;
import world.respect.shared.domain.account.passkey.VerifySignInWithPasskeyUseCase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0086B\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lworld/respect/shared/domain/account/passkey/VerifySignInWithPasskeyUseCase;", "", "schoolDb", "Lworld/respect/datalayer/db/RespectSchoolDatabase;", "json", "Lkotlinx/serialization/json/Json;", "decodeUserHandleUseCase", "Lworld/respect/credentials/passkey/request/DecodeUserHandleUseCase;", "<init>", "(Lworld/respect/datalayer/db/RespectSchoolDatabase;Lkotlinx/serialization/json/Json;Lworld/respect/credentials/passkey/request/DecodeUserHandleUseCase;)V", "webAuthnManager", "Lcom/webauthn4j/WebAuthnManager;", "invoke", "Lworld/respect/credentials/passkey/model/PasskeyVerifyResult;", "authenticationResponseJSON", "Lworld/respect/credentials/passkey/model/AuthenticationResponseJSON;", "rpId", "", "(Lworld/respect/credentials/passkey/model/AuthenticationResponseJSON;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createCredentialRecord", "Lcom/webauthn4j/credential/CredentialRecord;", "passkeyEntity", "Lworld/respect/datalayer/db/school/entities/PersonPasskeyEntity;", "respect-lib-shared"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVerifySignInWithPasskeyUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifySignInWithPasskeyUseCase.kt\nworld/respect/shared/domain/account/passkey/VerifySignInWithPasskeyUseCase\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,143:1\n222#2:144\n*S KotlinDebug\n*F\n+ 1 VerifySignInWithPasskeyUseCase.kt\nworld/respect/shared/domain/account/passkey/VerifySignInWithPasskeyUseCase\n*L\n42#1:144\n*E\n"})
public final class VerifySignInWithPasskeyUseCase {
    @NotNull
    private final RespectSchoolDatabase schoolDb;
    @NotNull
    private final Json json;
    @NotNull
    private final DecodeUserHandleUseCase decodeUserHandleUseCase;
    @NotNull
    private final WebAuthnManager webAuthnManager;
    public static final int $stable = 8;

    public VerifySignInWithPasskeyUseCase(@NotNull RespectSchoolDatabase schoolDb, @NotNull Json json, @NotNull DecodeUserHandleUseCase decodeUserHandleUseCase) {
        Intrinsics.checkNotNullParameter(schoolDb, "schoolDb");
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(decodeUserHandleUseCase, "decodeUserHandleUseCase");
        this.schoolDb = schoolDb;
        this.json = json;
        this.decodeUserHandleUseCase = decodeUserHandleUseCase;
        WebAuthnManager webAuthnManager = WebAuthnManager.createNonStrictWebAuthnManager();
        Intrinsics.checkNotNullExpressionValue(webAuthnManager, "createNonStrictWebAuthnManager(...)");
        this.webAuthnManager = webAuthnManager;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object invoke(@NotNull AuthenticationResponseJSON authenticationResponseJSON, @NotNull String rpId, @NotNull Continuation<? super PasskeyVerifyResult> $completion) {
        if (!($completion instanceof invoke.1)) ** GOTO lbl-1000
        var29_4 = $completion;
        if ((var29_4.label & -2147483648) != 0) {
            var29_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                Object L$13;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ VerifySignInWithPasskeyUseCase this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.invoke(null, null, this);
                }
            };
        }
        $result = $continuation.result;
        var30_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                clientDataJSONBase64 = authenticationResponseJSON.getResponse().getClientDataJSON();
                decodedBytes = Base64.getDecoder().decode(clientDataJSONBase64);
                var7_11 = this.json;
                Intrinsics.checkNotNull(decodedBytes);
                string$iv = StringsKt.decodeToString(decodedBytes);
                $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                clientDataJson = (ClientDataJSON)this_$iv.decodeFromString((DeserializationStrategy)ClientDataJSON.Companion.serializer(), string$iv);
                credentialIdByte = Base64.getUrlDecoder().decode(authenticationResponseJSON.getId());
                userHandleByte = Base64.getUrlDecoder().decode(authenticationResponseJSON.getResponse().getUserHandle());
                v0 = authenticationResponseJSON.getResponse().getUserHandle();
                if (v0 == null) {
                    throw new IllegalArgumentException("User handle cannot be null");
                }
                userHandle = this.decodeUserHandleUseCase.invoke(v0);
                authenticatorDataByte = Base64.getUrlDecoder().decode(authenticationResponseJSON.getResponse().getAuthenticatorData());
                clientDataJSONByte = Base64.getUrlDecoder().decode(authenticationResponseJSON.getResponse().getClientDataJSON());
                signatureByte = Base64.getUrlDecoder().decode(authenticationResponseJSON.getResponse().getSignature());
                serverOrigin = new Origin(clientDataJson.getOrigin());
                serverChallenge = new DefaultChallenge(Base64.getUrlDecoder().decode(clientDataJson.getChallenge()));
                tokenBindingId = null;
                serverProperty = new ServerProperty(serverOrigin, rpId, (Challenge)serverChallenge, tokenBindingId);
                allowCredentials = null;
                userVerificationRequired = 1;
                userPresenceRequired = 1;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(authenticationResponseJSON);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(rpId);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable(clientDataJSONBase64);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable(decodedBytes);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable(clientDataJson);
                $continuation.L$5 = credentialIdByte;
                $continuation.L$6 = userHandleByte;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable(userHandle);
                $continuation.L$8 = authenticatorDataByte;
                $continuation.L$9 = clientDataJSONByte;
                $continuation.L$10 = signatureByte;
                $continuation.L$11 = SpillingKt.nullOutSpilledVariable(serverOrigin);
                $continuation.L$12 = SpillingKt.nullOutSpilledVariable(serverChallenge);
                $continuation.L$13 = serverProperty;
                $continuation.I$0 = userVerificationRequired;
                $continuation.I$1 = userPresenceRequired;
                $continuation.label = 1;
                v1 = this.schoolDb.getPersonPasskeyEntityDao().findByPersonUidAndCredentialId(userHandle.getPersonUidNum(), authenticationResponseJSON.getId(), $continuation);
                if (v1 == var30_6) {
                    return var30_6;
                }
                ** GOTO lbl79
            }
            case 1: {
                userPresenceRequired = $continuation.I$1;
                userVerificationRequired = $continuation.I$0;
                allowCredentials = null;
                serverProperty = (ServerProperty)$continuation.L$13;
                tokenBindingId = null;
                serverChallenge = (DefaultChallenge)$continuation.L$12;
                serverOrigin = (Origin)$continuation.L$11;
                signatureByte = (byte[])$continuation.L$10;
                clientDataJSONByte = (byte[])$continuation.L$9;
                authenticatorDataByte = (byte[])$continuation.L$8;
                userHandle = (RespectUserHandle)$continuation.L$7;
                userHandleByte = (byte[])$continuation.L$6;
                credentialIdByte = (byte[])$continuation.L$5;
                clientDataJson = (ClientDataJSON)$continuation.L$4;
                decodedBytes = (byte[])$continuation.L$3;
                clientDataJSONBase64 = (String)$continuation.L$2;
                rpId = (String)$continuation.L$1;
                authenticationResponseJSON = (AuthenticationResponseJSON)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl79:
                // 2 sources

                v2 = (PersonPasskeyEntity)v1;
                if (v2 == null) {
                    throw ExceptionWithHttpStatusCodeKt.withHttpStatus(new IllegalArgumentException(), 401);
                }
                passkeyData = v2;
                credentialRecord = this.createCredentialRecord(passkeyData);
                authenticationRequest = new AuthenticationRequest(credentialIdByte, userHandleByte, authenticatorDataByte, clientDataJSONByte, null, signatureByte);
                authenticationParameters = new AuthenticationParameters(serverProperty, credentialRecord, allowCredentials, userVerificationRequired != 0, userPresenceRequired != 0);
                try {
                    var26_35 = this.webAuthnManager.parse(authenticationRequest);
                }
                catch (DataConversionException e) {
                    throw ExceptionWithHttpStatusCodeKt.withHttpStatus(e, 404);
                }
                var25_38 = var26_35;
                Intrinsics.checkNotNull(var25_38);
                authenticationData = var25_38;
                try {
                    this.webAuthnManager.verify(authenticationData, authenticationParameters);
                    var25_38 = new PasskeyVerifyResult(true, passkeyData.getPpPersonUidNum(), null, null, 12, null);
                }
                catch (Exception e) {
                    Napier.w$default(Napier.INSTANCE, "VerifySigninWithPasskey: Failed", e, null, 4, null);
                    var25_38 = new PasskeyVerifyResult(false, 0L, null, null, 12, null);
                }
                return var25_38;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final CredentialRecord createCredentialRecord(PersonPasskeyEntity passkeyEntity) {
        RegistrationData registrationData;
        byte[] attestationObject = Base64.getUrlDecoder().decode(passkeyEntity.getPpAttestationObj());
        byte[] clientDataJSON = Base64.getUrlDecoder().decode(passkeyEntity.getPpClientDataJson());
        String clientExtensionJSON = null;
        String[] stringArray = new String[]{"internal", "hybrid"};
        Set<String> transports = SetsKt.setOf(stringArray);
        RegistrationRequest registrationRequest = new RegistrationRequest(attestationObject, clientDataJSON, clientExtensionJSON, transports);
        try {
            registrationData = this.webAuthnManager.parse(registrationRequest);
        }
        catch (DataConversionException e) {
            throw ExceptionWithHttpStatusCodeKt.withHttpStatus(e, 404);
        }
        RegistrationData registrationData2 = registrationData;
        Intrinsics.checkNotNull(registrationData2);
        RegistrationData registrationData3 = registrationData2;
        AttestationObject attestationObject2 = registrationData3.getAttestationObject();
        if (attestationObject2 == null) {
            throw new IllegalStateException("Null attestation object");
        }
        AttestationObject it = attestationObject2;
        boolean bl = false;
        return new CredentialRecordImpl(it, registrationData3.getCollectedClientData(), registrationData3.getClientExtensions(), registrationData3.getTransports());
    }
}

