/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal.util;

import com.ethlo.time.internal.util.ErrorUtil;
import java.util.Arrays;

public final class LimitedCharArrayIntegerUtil {
    public static final char DIGIT_9 = '9';
    public static final char ZERO = '0';
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final int TABLE_WIDTH = 4;
    private static final int RADIX = 10;
    private static final int MAX_INT_WIDTH = 10;
    private static final int TABLE_SIZE = (int)Math.pow(10.0, 4.0);
    private static final char[] INT_CONVERSION_CACHE = new char[TABLE_SIZE * 4 + 10];

    private LimitedCharArrayIntegerUtil() {
    }

    public static int parsePositiveInt(String strNum, int startInclusive, int endExclusive) {
        int result = 0;
        try {
            for (int i = startInclusive; i < endExclusive; ++i) {
                char c = strNum.charAt(i);
                if (c < '0' || c > '9') {
                    ErrorUtil.raiseUnexpectedCharacter(strNum, i, '0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
                }
                result = result * 10 + (c - 48);
            }
        }
        catch (StringIndexOutOfBoundsException exc) {
            ErrorUtil.raiseUnexpectedEndOfText(strNum, startInclusive);
        }
        return result;
    }

    public static void toString(int value, char[] buf, int offset, int charLength) {
        if (value < TABLE_SIZE) {
            int length = Math.min(4, charLength);
            int padPrefixLen = charLength - length;
            int start = charLength > 4 ? 4 : 4 - charLength;
            int targetOffset = offset + padPrefixLen;
            int srcPos = value * 4 + (charLength < 4 ? start : 0);
            LimitedCharArrayIntegerUtil.copy(INT_CONVERSION_CACHE, srcPos, buf, targetOffset, length);
            if (padPrefixLen > 0) {
                LimitedCharArrayIntegerUtil.zeroFill(buf, offset, padPrefixLen);
            }
        } else {
            LimitedCharArrayIntegerUtil.createBufferEntry(buf, offset, charLength, value);
        }
    }

    private static void createBufferEntry(char[] buf, int offset, int charLength, int value) {
        int charPos = offset + 10;
        value = -value;
        while (value <= -10) {
            int div = value / 10;
            int rem = -(value - 10 * div);
            buf[charPos--] = DIGITS[rem];
            value = div;
        }
        buf[charPos] = DIGITS[-value];
        for (int l = 10 + offset - charPos + 1; l < charLength; ++l) {
            buf[--charPos] = 48;
        }
        int srcPos = charPos;
        LimitedCharArrayIntegerUtil.copy(buf, srcPos, offset, charLength);
    }

    private static void zeroFill(char[] buf, int offset, int padPrefixLen) {
        Arrays.fill(buf, offset, offset + padPrefixLen, '0');
    }

    private static void copy(char[] buf, int srcPos, int offset, int length) {
        LimitedCharArrayIntegerUtil.copy(buf, srcPos, buf, offset, length);
    }

    private static void copy(char[] buf, int srcPos, char[] target, int offset, int length) {
        System.arraycopy(buf, srcPos, target, offset, length);
    }

    static {
        int offset = 0;
        for (int i = 0; i < TABLE_SIZE; ++i) {
            LimitedCharArrayIntegerUtil.createBufferEntry(INT_CONVERSION_CACHE, offset, 4, i);
            offset += 4;
        }
    }
}

