/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.paging.LoadState;
import androidx.paging.LoadStates;
import androidx.paging.LoadType;
import androidx.paging.PagingState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u0002*+B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001eJ\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\bJ\u0014\u0010\"\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u001eJ \u0010#\u001a\u001c\u0012\u0004\u0012\u00020\u001b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001e\u0018\u00010$J\u0006\u0010%\u001a\u00020 J\u000e\u0010&\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010'\u001a\u00020 J\u0018\u0010(\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010)\u001a\u0004\u0018\u00010\u000bR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Landroidx/paging/AccessorState;", "Key", "", "Value", "<init>", "()V", "blockStates", "", "Landroidx/paging/AccessorState$BlockState;", "[Landroidx/paging/AccessorState$BlockState;", "errors", "Landroidx/paging/LoadState$Error;", "[Landroidx/paging/LoadState$Error;", "pendingRequests", "Lkotlin/collections/ArrayDeque;", "Landroidx/paging/AccessorState$PendingRequest;", "refreshAllowed", "", "getRefreshAllowed", "()Z", "setRefreshAllowed", "(Z)V", "computeLoadStates", "Landroidx/paging/LoadStates;", "computeLoadTypeState", "Landroidx/paging/LoadState;", "loadType", "Landroidx/paging/LoadType;", "add", "pagingState", "Landroidx/paging/PagingState;", "setBlockState", "", "state", "getPendingRefresh", "getPendingBoundary", "Lkotlin/Pair;", "clearPendingRequests", "clearPendingRequest", "clearErrors", "setError", "errorState", "PendingRequest", "BlockState", "paging-common"})
@SourceDebugExtension(value={"SMAP\nRemoteMediatorAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteMediatorAccessor.kt\nandroidx/paging/AccessorState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,432:1\n1755#2,3:433\n295#2,2:436\n295#2,2:438\n295#2,2:440\n*S KotlinDebug\n*F\n+ 1 RemoteMediatorAccessor.kt\nandroidx/paging/AccessorState\n*L\n116#1:433,3\n151#1:436,2\n197#1:438,2\n201#1:440,2\n*E\n"})
final class AccessorState<Key, Value> {
    @NotNull
    private final BlockState[] blockStates;
    @NotNull
    private final LoadState.Error[] errors;
    @NotNull
    private final ArrayDeque<PendingRequest<Key, Value>> pendingRequests;
    private boolean refreshAllowed;

    public AccessorState() {
        int n;
        int n2 = 0;
        int n3 = LoadType.values().length;
        Object[] objectArray = new BlockState[n3];
        AccessorState accessorState = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = BlockState.UNBLOCKED;
        }
        accessorState.blockStates = objectArray;
        n2 = 0;
        n3 = LoadType.values().length;
        objectArray = new LoadState.Error[n3];
        accessorState = this;
        while (n2 < n3) {
            n = n2++;
            objectArray[n] = null;
        }
        accessorState.errors = objectArray;
        this.pendingRequests = new ArrayDeque();
    }

    public final boolean getRefreshAllowed() {
        return this.refreshAllowed;
    }

    public final void setRefreshAllowed(boolean bl) {
        this.refreshAllowed = bl;
    }

    @NotNull
    public final LoadStates computeLoadStates() {
        LoadState loadState = this.computeLoadTypeState(LoadType.REFRESH);
        LoadState loadState2 = this.computeLoadTypeState(LoadType.APPEND);
        LoadState loadState3 = this.computeLoadTypeState(LoadType.PREPEND);
        return new LoadStates(loadState, loadState3, loadState2);
    }

    private final LoadState computeLoadTypeState(LoadType loadType) {
        LoadState loadState;
        boolean hasPending;
        BlockState blockState;
        block10: {
            boolean bl;
            blockState = this.blockStates[loadType.ordinal()];
            Iterable $this$any$iv = (Iterable)this.pendingRequests;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PendingRequest it = (PendingRequest)element$iv;
                    boolean bl2 = false;
                    if (!(it.getLoadType() == loadType)) continue;
                    bl = true;
                    break block10;
                }
                bl = hasPending = false;
            }
        }
        if (hasPending && blockState != BlockState.REQUIRES_REFRESH) {
            return LoadState.Loading.INSTANCE;
        }
        LoadState.Error error = this.errors[loadType.ordinal()];
        if (error != null) {
            LoadState.Error it = error;
            boolean bl = false;
            return it;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[blockState.ordinal()]) {
            case 1: {
                loadState = WhenMappings.$EnumSwitchMapping$0[loadType.ordinal()] == 1 ? LoadState.NotLoading.Companion.getIncomplete$paging_common() : LoadState.NotLoading.Companion.getComplete$paging_common();
                break;
            }
            case 2: {
                loadState = LoadState.NotLoading.Companion.getIncomplete$paging_common();
                break;
            }
            case 3: {
                loadState = LoadState.NotLoading.Companion.getIncomplete$paging_common();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return loadState;
    }

    public final boolean add(@NotNull LoadType loadType, @NotNull PagingState<Key, Value> pagingState) {
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
            Intrinsics.checkNotNullParameter(pagingState, (String)"pagingState");
            Iterable $this$firstOrNull$iv = (Iterable)this.pendingRequests;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PendingRequest it = (PendingRequest)element$iv;
                boolean bl = false;
                if (!(it.getLoadType() == loadType)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        PendingRequest existing = v0;
        if (existing != null) {
            existing.setPagingState(pagingState);
            return false;
        }
        BlockState blockState = this.blockStates[loadType.ordinal()];
        if (blockState == BlockState.REQUIRES_REFRESH && loadType != LoadType.REFRESH) {
            this.pendingRequests.add(new PendingRequest<Key, Value>(loadType, pagingState));
            return false;
        }
        if (blockState != BlockState.UNBLOCKED && loadType != LoadType.REFRESH) {
            return false;
        }
        if (loadType == LoadType.REFRESH) {
            this.setError(LoadType.REFRESH, null);
        }
        return this.errors[loadType.ordinal()] == null ? this.pendingRequests.add(new PendingRequest<Key, Value>(loadType, pagingState)) : false;
    }

    public final void setBlockState(@NotNull LoadType loadType, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.blockStates[loadType.ordinal()] = state;
    }

    @Nullable
    public final PagingState<Key, Value> getPendingRefresh() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)this.pendingRequests;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PendingRequest it = (PendingRequest)element$iv;
                boolean bl = false;
                if (!(it.getLoadType() == LoadType.REFRESH)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        PendingRequest pendingRequest = v0;
        return pendingRequest != null ? pendingRequest.getPagingState() : null;
    }

    @Nullable
    public final Pair<LoadType, PagingState<Key, Value>> getPendingBoundary() {
        Pair pair;
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = (Iterable)this.pendingRequests;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PendingRequest it = (PendingRequest)element$iv;
                boolean bl = false;
                if (!(it.getLoadType() != LoadType.REFRESH && this.blockStates[it.getLoadType().ordinal()] == BlockState.UNBLOCKED)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        PendingRequest pendingRequest = v0;
        if (pendingRequest != null) {
            PendingRequest it = pendingRequest;
            boolean bl = false;
            pair = TuplesKt.to((Object)((Object)it.getLoadType()), it.getPagingState());
        } else {
            pair = null;
        }
        return pair;
    }

    public final void clearPendingRequests() {
        this.pendingRequests.clear();
    }

    public final void clearPendingRequest(@NotNull LoadType loadType) {
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        CollectionsKt.removeAll((List)((List)this.pendingRequests), arg_0 -> AccessorState.clearPendingRequest$lambda$6(loadType, arg_0));
    }

    public final void clearErrors() {
        int n = this.errors.length;
        for (int i = 0; i < n; ++i) {
            this.errors[i] = null;
        }
    }

    public final void setError(@NotNull LoadType loadType, @Nullable LoadState.Error errorState) {
        Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
        this.errors[loadType.ordinal()] = errorState;
    }

    private static final boolean clearPendingRequest$lambda$6(LoadType $loadType, PendingRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLoadType() == $loadType;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/paging/AccessorState$BlockState;", "", "<init>", "(Ljava/lang/String;I)V", "UNBLOCKED", "COMPLETED", "REQUIRES_REFRESH", "paging-common"})
    public static final class BlockState
    extends Enum<BlockState> {
        public static final /* enum */ BlockState UNBLOCKED = new BlockState();
        public static final /* enum */ BlockState COMPLETED = new BlockState();
        public static final /* enum */ BlockState REQUIRES_REFRESH = new BlockState();
        private static final /* synthetic */ BlockState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BlockState[] values() {
            return (BlockState[])$VALUES.clone();
        }

        public static BlockState valueOf(String value) {
            return Enum.valueOf(BlockState.class, value);
        }

        @NotNull
        public static EnumEntries<BlockState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = blockStateArray = new BlockState[]{BlockState.UNBLOCKED, BlockState.COMPLETED, BlockState.REQUIRES_REFRESH};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\b\b\u0003\u0010\u0003*\u00020\u00022\u00020\u0002B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Landroidx/paging/AccessorState$PendingRequest;", "Key", "", "Value", "loadType", "Landroidx/paging/LoadType;", "pagingState", "Landroidx/paging/PagingState;", "<init>", "(Landroidx/paging/LoadType;Landroidx/paging/PagingState;)V", "getLoadType", "()Landroidx/paging/LoadType;", "getPagingState", "()Landroidx/paging/PagingState;", "setPagingState", "(Landroidx/paging/PagingState;)V", "paging-common"})
    public static final class PendingRequest<Key, Value> {
        @NotNull
        private final LoadType loadType;
        @NotNull
        private PagingState<Key, Value> pagingState;

        public PendingRequest(@NotNull LoadType loadType, @NotNull PagingState<Key, Value> pagingState) {
            Intrinsics.checkNotNullParameter((Object)((Object)loadType), (String)"loadType");
            Intrinsics.checkNotNullParameter(pagingState, (String)"pagingState");
            this.loadType = loadType;
            this.pagingState = pagingState;
        }

        @NotNull
        public final LoadType getLoadType() {
            return this.loadType;
        }

        @NotNull
        public final PagingState<Key, Value> getPagingState() {
            return this.pagingState;
        }

        public final void setPagingState(@NotNull PagingState<Key, Value> pagingState) {
            Intrinsics.checkNotNullParameter(pagingState, (String)"<set-?>");
            this.pagingState = pagingState;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LoadType.values().length];
            try {
                nArray[LoadType.REFRESH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BlockState.values().length];
            try {
                nArray[BlockState.COMPLETED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockState.REQUIRES_REFRESH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockState.UNBLOCKED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

