/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.IOException;
import java.net.CookieManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jsoup.Connection;
import org.jsoup.helper.HttpConnection;
import org.jsoup.internal.StringUtil;
import org.jsoup.parser.CharacterReader;
import org.jspecify.annotations.Nullable;

class CookieUtil {
    private static final Map<String, List<String>> EmptyRequestHeaders = Collections.unmodifiableMap(new HashMap());
    private static final String Sep = "; ";
    private static final String CookieName = "Cookie";
    private static final String Cookie2Name = "Cookie2";

    CookieUtil() {
    }

    static void applyCookiesToRequest(HttpConnection.Request req, BiConsumer<String, String> setter) throws IOException {
        LinkedHashSet<String> cookieSet = CookieUtil.requestCookieSet(req);
        HashSet cookies2 = null;
        Map<String, List<String>> storedCookies = req.cookieManager().get(CookieUtil.asUri(req.url), EmptyRequestHeaders);
        for (Map.Entry<String, List<String>> entry : storedCookies.entrySet()) {
            HashSet set2;
            List<String> cookies3 = entry.getValue();
            if (cookies3 == null || cookies3.size() == 0) continue;
            String key = entry.getKey();
            if (CookieName.equals(key)) {
                set2 = cookieSet;
            } else {
                if (!Cookie2Name.equals(key)) continue;
                cookies2 = set2 = new HashSet();
            }
            set2.addAll(cookies3);
        }
        if (cookieSet.size() > 0) {
            setter.accept(CookieName, StringUtil.join(cookieSet, Sep));
        }
        if (cookies2 != null && cookies2.size() > 0) {
            setter.accept(Cookie2Name, StringUtil.join(cookies2, Sep));
        }
    }

    private static LinkedHashSet<String> requestCookieSet(Connection.Request req) {
        LinkedHashSet<String> set2 = new LinkedHashSet<String>();
        for (Map.Entry<String, String> cookie : req.cookies().entrySet()) {
            set2.add(cookie.getKey() + "=" + cookie.getValue());
        }
        return set2;
    }

    static URI asUri(URL url2) throws IOException {
        try {
            return url2.toURI();
        }
        catch (URISyntaxException e) {
            MalformedURLException ue = new MalformedURLException(e.getMessage());
            ue.initCause(e);
            throw ue;
        }
    }

    static void storeCookies(HttpConnection.Request req, HttpConnection.Response res, URL url2, Map<String, List<String>> resHeaders) throws IOException {
        CookieManager manager = req.cookieManager();
        URI uri = CookieUtil.asUri(url2);
        manager.put(uri, resHeaders);
        for (Map.Entry<String, List<String>> entry : resHeaders.entrySet()) {
            String name = entry.getKey();
            List<String> values2 = entry.getValue();
            if (!name.equalsIgnoreCase("Set-Cookie")) continue;
            for (String value : values2) {
                CookieUtil.parseCookie(value, res);
            }
        }
    }

    static void parseCookie(@Nullable String value, HttpConnection.Response res) {
        if (value == null) {
            return;
        }
        CharacterReader reader2 = new CharacterReader(value);
        String cookieName = reader2.consumeTo('=').trim();
        reader2.advance();
        String cookieVal = reader2.consumeTo(';').trim();
        if (!cookieName.isEmpty()) {
            res.cookie(cookieName, cookieVal);
        }
        reader2.close();
    }
}

