/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.format;

import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Format;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;

public class TimeFormat
implements Format {
    private static final long MAX_OFFSET_MIN = 1439L;
    private static final long MIN_OFFSET_MIN = -1439L;
    private static final DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:MM", "Z").parseLenient().toFormatter();

    @Override
    public boolean matches(ExecutionContext executionContext, String value) {
        try {
            boolean isStandardTimeRange;
            if (null == value) {
                return true;
            }
            int pos = value.indexOf(90);
            if (-1 != pos && pos != value.length() - 1) {
                return false;
            }
            TemporalAccessor accessor = formatter.parseUnresolved(value, new ParsePosition(0));
            if (null == accessor) {
                return false;
            }
            long offset = accessor.getLong(ChronoField.OFFSET_SECONDS) / 60L;
            if (1439L < offset || -1439L > offset) {
                return false;
            }
            long hr = accessor.getLong(ChronoField.HOUR_OF_DAY);
            long min = accessor.getLong(ChronoField.MINUTE_OF_HOUR);
            long sec = accessor.getLong(ChronoField.SECOND_OF_MINUTE);
            boolean bl = isStandardTimeRange = sec <= 59L && min <= 59L && hr <= 23L;
            if (isStandardTimeRange) {
                return true;
            }
            hr -= offset / 60L;
            if ((min -= offset % 60L) < 0L) {
                --hr;
                min += 60L;
            }
            if (hr < 0L) {
                hr += 24L;
            }
            return this.isSpecialCaseLeapSecond(sec, min, hr);
        }
        catch (DateTimeException e) {
            return false;
        }
    }

    private boolean isSpecialCaseLeapSecond(long sec, long min, long hr) {
        return sec == 60L && min == 59L && hr == 23L;
    }

    @Override
    public String getName() {
        return "time";
    }

    @Override
    public String getMessageKey() {
        return "format.time";
    }
}

