/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.verifier.exception.BadChallengeException;
import com.webauthn4j.verifier.exception.MissingChallengeException;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;

class ChallengeVerifier {
    ChallengeVerifier() {
    }

    public void verify(@NotNull CollectedClientData collectedClientData, @NotNull ServerProperty serverProperty) {
        AssertUtil.notNull(collectedClientData, "collectedClientData must not be null");
        AssertUtil.notNull(serverProperty, "serverProperty must not be null");
        Challenge savedChallenge = serverProperty.getChallenge();
        Challenge collectedChallenge = collectedClientData.getChallenge();
        if (savedChallenge == null) {
            throw new MissingChallengeException("The server doesn't have a challenge. The client must request the server to issue the challenge before WebAuthn operations.");
        }
        this.verify(savedChallenge, collectedChallenge);
    }

    public void verify(@NotNull Challenge expected, @NotNull Challenge actual) {
        AssertUtil.notNull(expected, "expected must not be null");
        AssertUtil.notNull(actual, "actual must not be null");
        byte[] expectedChallengeBytes = expected.getValue();
        byte[] actualChallengeBytes = actual.getValue();
        if (!MessageDigest.isEqual(expectedChallengeBytes, actualChallengeBytes)) {
            throw new BadChallengeException("The actual challenge does not match the expected challenge");
        }
    }
}

