/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.selector;

import io.ktor.network.selector.InterestSuspensionsMap;
import io.ktor.network.selector.SelectInterest;
import io.ktor.network.selector.Selectable;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.selector.SelectorManagerSupport;
import io.ktor.network.selector.SelectorManagerSupportKt;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0011\b&\u0018\u00002\u00020\u0001:\u00018B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H$\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0086@\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0012\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u000eH\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001eH\u0004\u00a2\u0006\u0004\b \u0010!J!\u0010 \u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0004\u00a2\u0006\u0004\b \u0010\"R\u0017\u0010$\u001a\u00020#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010/\u001a\u00020(8\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010*\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R,\u00107\u001a\u0004\u0018\u00010\u0004*\u00020\u000e2\b\u00102\u001a\u0004\u0018\u00010\u00048B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u00069"}, d2={"Lio/ktor/network/selector/SelectorManagerSupport;", "Lio/ktor/network/selector/SelectorManager;", "<init>", "()V", "Lio/ktor/network/selector/Selectable;", "selectable", "", "publishInterest", "(Lio/ktor/network/selector/Selectable;)V", "Lio/ktor/network/selector/SelectInterest;", "interest", "select", "(Lio/ktor/network/selector/Selectable;Lio/ktor/network/selector/SelectInterest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "Ljava/nio/channels/SelectionKey;", "selectedKeys", "", "keys", "handleSelectedKeys", "(Ljava/util/Set;Ljava/util/Set;)V", "key", "handleSelectedKey", "(Ljava/nio/channels/SelectionKey;)V", "Ljava/nio/channels/Selector;", "selector", "applyInterest", "(Ljava/nio/channels/Selector;Lio/ktor/network/selector/Selectable;)V", "attachment", "notifyClosedImpl", "(Ljava/nio/channels/Selector;Ljava/nio/channels/SelectionKey;Lio/ktor/network/selector/Selectable;)V", "", "cause", "cancelAllSuspensions", "(Lio/ktor/network/selector/Selectable;Ljava/lang/Throwable;)V", "(Ljava/nio/channels/Selector;Ljava/lang/Throwable;)V", "Ljava/nio/channels/spi/SelectorProvider;", "provider", "Ljava/nio/channels/spi/SelectorProvider;", "getProvider", "()Ljava/nio/channels/spi/SelectorProvider;", "", "pending", "I", "getPending", "()I", "setPending", "(I)V", "cancelled", "getCancelled", "setCancelled", "newValue", "getSubject", "(Ljava/nio/channels/SelectionKey;)Lio/ktor/network/selector/Selectable;", "setSubject", "(Ljava/nio/channels/SelectionKey;Lio/ktor/network/selector/Selectable;)V", "subject", "ClosedSelectorCancellationException", "ktor-network"})
@SourceDebugExtension(value={"SMAP\nSelectorManagerSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectorManagerSupport.kt\nio/ktor/network/selector/SelectorManagerSupport\n+ 2 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n+ 3 InterestSuspensionsMap.kt\nio/ktor/network/selector/InterestSuspensionsMap\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n426#2,11:188\n32#3,8:199\n42#3,2:207\n45#3:210\n1#4:209\n1#4:212\n1869#5:211\n1870#5:213\n*S KotlinDebug\n*F\n+ 1 SelectorManagerSupport.kt\nio/ktor/network/selector/SelectorManagerSupport\n*L\n44#1:188,11\n86#1:199,8\n150#1:207,2\n150#1:210\n150#1:209\n161#1:211\n161#1:213\n*E\n"})
public abstract class SelectorManagerSupport
implements SelectorManager {
    @NotNull
    private final SelectorProvider provider;
    private int pending;
    private int cancelled;

    public SelectorManagerSupport() {
        SelectorProvider selectorProvider = SelectorProvider.provider();
        Intrinsics.checkNotNullExpressionValue(selectorProvider, "provider(...)");
        this.provider = selectorProvider;
    }

    @Override
    @NotNull
    public final SelectorProvider getProvider() {
        return this.provider;
    }

    protected final int getPending() {
        return this.pending;
    }

    protected final void setPending(int n) {
        this.pending = n;
    }

    protected final int getCancelled() {
        return this.cancelled;
    }

    protected final void setCancelled(int n) {
        this.cancelled = n;
    }

    protected abstract void publishInterest(@NotNull Selectable var1);

    @Override
    @Nullable
    public final Object select(@NotNull Selectable selectable2, @NotNull SelectInterest interest, @NotNull Continuation<? super Unit> $completion) {
        int interestedOps = selectable2.getInterestedOps();
        int flag = interest.getFlag();
        if (selectable2.isClosed()) {
            SelectorManagerSupportKt.access$selectableIsClosed();
            throw new KotlinNothingValueException();
        }
        if ((interestedOps & flag) == 0) {
            SelectorManagerSupportKt.access$selectableIsInvalid(interestedOps, flag);
            throw new KotlinNothingValueException();
        }
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super Unit> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl<? super Unit> cancellable$iv = new CancellableContinuationImpl<Unit>(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation2 = cancellable$iv;
        boolean bl2 = false;
        continuation2.invokeOnCancellation(select.2.1.INSTANCE);
        selectable2.getSuspensions().addSuspension(interest, continuation2);
        if (!continuation2.isCancelled()) {
            this.publishInterest(selectable2);
        }
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    protected final void handleSelectedKeys(@NotNull Set<SelectionKey> selectedKeys, @NotNull Set<? extends SelectionKey> keys2) {
        Intrinsics.checkNotNullParameter(selectedKeys, "selectedKeys");
        Intrinsics.checkNotNullParameter(keys2, "keys");
        int selectedCount = selectedKeys.size();
        this.pending = keys2.size() - selectedCount;
        this.cancelled = 0;
        if (selectedCount <= 0) {
            return;
        }
        Iterator<SelectionKey> iter = selectedKeys.iterator();
        while (iter.hasNext()) {
            SelectionKey k = iter.next();
            this.handleSelectedKey(k);
            iter.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void handleSelectedKey(@NotNull SelectionKey key) {
        block5: {
            Intrinsics.checkNotNullParameter(key, "key");
            try {
                int readyOps = key.readyOps();
                int interestOps = key.interestOps();
                Selectable subject = this.getSubject(key);
                if (subject == null) {
                    key.cancel();
                    int n = this.cancelled;
                    this.cancelled = n + 1;
                    break block5;
                }
                InterestSuspensionsMap interestSuspensionsMap = subject.getSuspensions();
                int readyOps$iv = readyOps;
                boolean $i$f$invokeForEachPresent = false;
                int[] flags$iv = SelectInterest.Companion.getFlags();
                int n = flags$iv.length;
                for (int ordinal$iv = 0; ordinal$iv < n; ++ordinal$iv) {
                    CancellableContinuation<Unit> $this$handleSelectedKey_u24lambda_u241;
                    void this_$iv;
                    if ((flags$iv[ordinal$iv] & readyOps$iv) == 0 || this_$iv.removeSuspension(ordinal$iv) == null) continue;
                    boolean bl = false;
                    ((Continuation)$this$handleSelectedKey_u24lambda_u241).resumeWith(Result.constructor-impl(Unit.INSTANCE));
                }
                int newOps = interestOps & ~readyOps;
                if (newOps != interestOps) {
                    key.interestOps(newOps);
                }
                if (newOps == 0) break block5;
                readyOps$iv = this.pending;
                this.pending = readyOps$iv + 1;
            }
            catch (Throwable cause) {
                key.cancel();
                int n = this.cancelled;
                this.cancelled = n + 1;
                Selectable selectable2 = this.getSubject(key);
                if (selectable2 == null) break block5;
                Selectable subject = selectable2;
                boolean bl = false;
                this.cancelAllSuspensions(subject, cause);
                this.setSubject(key, null);
            }
        }
    }

    protected final void applyInterest(@NotNull Selector selector, @NotNull Selectable selectable2) {
        Intrinsics.checkNotNullParameter(selector, "selector");
        Intrinsics.checkNotNullParameter(selectable2, "selectable");
        try {
            SelectableChannel channel2 = selectable2.getChannel();
            SelectionKey key = channel2.keyFor(selector);
            int ops = selectable2.getInterestedOps();
            if (key == null) {
                if (ops != 0) {
                    channel2.register(selector, ops, selectable2);
                }
            } else if (key.interestOps() != ops) {
                key.interestOps(ops);
            }
            if (ops != 0) {
                int n = this.pending;
                this.pending = n + 1;
            }
        }
        catch (Throwable cause) {
            SelectionKey selectionKey = selectable2.getChannel().keyFor(selector);
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            this.cancelAllSuspensions(selectable2, cause);
        }
    }

    protected final void notifyClosedImpl(@NotNull Selector selector, @NotNull SelectionKey key, @NotNull Selectable attachment) {
        Intrinsics.checkNotNullParameter(selector, "selector");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(attachment, "attachment");
        this.cancelAllSuspensions(attachment, (Throwable)new ClosedChannelException());
        this.setSubject(key, null);
        selector.wakeup();
    }

    protected final void cancelAllSuspensions(@NotNull Selectable attachment, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter(attachment, "attachment");
        Intrinsics.checkNotNullParameter(cause, "cause");
        InterestSuspensionsMap this_$iv = attachment.getSuspensions();
        boolean $i$f$invokeForEachPresent = false;
        for (SelectInterest interest$iv : SelectInterest.Companion.getAllInterests()) {
            CancellableContinuation<Unit> $this$invokeForEachPresent_u24lambda_u240$iv;
            if (this_$iv.removeSuspension(interest$iv) == null) continue;
            boolean bl = false;
            SelectInterest selectInterest = interest$iv;
            CancellableContinuation<Unit> $this$cancelAllSuspensions_u24lambda_u243 = $this$invokeForEachPresent_u24lambda_u240$iv;
            boolean bl2 = false;
            ((Continuation)$this$cancelAllSuspensions_u24lambda_u243).resumeWith(Result.constructor-impl(ResultKt.createFailure(cause)));
        }
    }

    protected final void cancelAllSuspensions(@NotNull Selector selector, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter(selector, "selector");
        Throwable throwable = cause;
        if (throwable == null) {
            throwable = new ClosedSelectorCancellationException();
        }
        Throwable currentCause = throwable;
        Set<SelectionKey> set2 = selector.keys();
        Intrinsics.checkNotNullExpressionValue(set2, "keys(...)");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            SelectionKey key = (SelectionKey)element$iv;
            boolean bl = false;
            try {
                if (key.isValid()) {
                    key.interestOps(0);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                // empty catch block
            }
            if (((object = key.attachment()) instanceof Selectable ? (Selectable)object : null) != null) {
                Selectable it;
                it = it;
                boolean bl2 = false;
                this.cancelAllSuspensions(it, currentCause);
            }
            key.cancel();
        }
    }

    private final Selectable getSubject(SelectionKey $this$subject) {
        Object object = $this$subject.attachment();
        return object instanceof Selectable ? (Selectable)object : null;
    }

    private final void setSubject(SelectionKey $this$subject, Selectable newValue) {
        $this$subject.attach(newValue);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lio/ktor/network/selector/SelectorManagerSupport$ClosedSelectorCancellationException;", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "<init>", "()V", "ktor-network"})
    public static final class ClosedSelectorCancellationException
    extends CancellationException {
        public ClosedSelectorCancellationException() {
            super("Closed selector");
        }
    }
}

