/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.AuthenticatorAttachment;
import com.webauthn4j.data.extension.CredentialProtectionPolicy;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class CredentialProtectionPolicyDeserializer
extends StdDeserializer<CredentialProtectionPolicy> {
    public CredentialProtectionPolicyDeserializer() {
        super(CredentialProtectionPolicy.class);
    }

    @NotNull
    public CredentialProtectionPolicy deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) throws IOException {
        byte value = (byte)p.getValueAsInt();
        try {
            return CredentialProtectionPolicy.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, AuthenticatorAttachment.class);
        }
    }
}

