/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class X509CertificateDeserializer
extends StdDeserializer<X509Certificate> {
    public X509CertificateDeserializer() {
        super(X509Certificate.class);
    }

    @Override
    @Nullable
    public X509Certificate deserialize(@NotNull JsonParser p2, @NotNull DeserializationContext ctxt) throws IOException {
        String value = p2.getValueAsString();
        byte[] bytes = Base64Util.decode(value);
        if (bytes.length == 0) {
            return null;
        }
        return CertificateUtil.generateX509Certificate(bytes);
    }
}

