/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import kotlinx.datetime.FixedOffsetTimeZone;
import kotlinx.datetime.IllegalTimeZoneException;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.OverloadMarker;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.TimeZoneKt__TimeZoneJvmKt;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.serializers.TimeZoneSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=TimeZoneSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\f\u001a\u00020\r*\u00020\u000eJ\u0014\u0010\u000f\u001a\u00020\u000e*\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lkotlinx/datetime/TimeZone;", "", "zoneId", "Ljava/time/ZoneId;", "<init>", "(Ljava/time/ZoneId;)V", "getZoneId$kotlinx_datetime", "()Ljava/time/ZoneId;", "id", "", "getId", "()Ljava/lang/String;", "toLocalDateTime", "Lkotlinx/datetime/LocalDateTime;", "Lkotlin/time/Instant;", "toInstant", "youShallNotPass", "Lkotlinx/datetime/OverloadMarker;", "equals", "", "other", "hashCode", "", "toString", "Companion", "kotlinx-datetime"})
public class TimeZone {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ZoneId zoneId;
    @NotNull
    private static final FixedOffsetTimeZone UTC;

    public TimeZone(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter(zoneId, "zoneId");
        this.zoneId = zoneId;
    }

    @NotNull
    public final ZoneId getZoneId$kotlinx_datetime() {
        return this.zoneId;
    }

    @NotNull
    public final String getId() {
        String string2 = this.zoneId.getId();
        Intrinsics.checkNotNullExpressionValue(string2, "getId(...)");
        return string2;
    }

    @NotNull
    public final LocalDateTime toLocalDateTime(@NotNull Instant $this$toLocalDateTime) {
        Intrinsics.checkNotNullParameter($this$toLocalDateTime, "<this>");
        return TimeZoneKt.toLocalDateTime($this$toLocalDateTime, this);
    }

    @NotNull
    public final Instant toInstant(@NotNull LocalDateTime $this$toInstant, @NotNull OverloadMarker youShallNotPass) {
        Intrinsics.checkNotNullParameter($this$toInstant, "<this>");
        Intrinsics.checkNotNullParameter(youShallNotPass, "youShallNotPass");
        return TimeZoneKt.toInstant$default($this$toInstant, this, null, 2, null);
    }

    public static /* synthetic */ Instant toInstant$default(TimeZone timeZone, LocalDateTime localDateTime, OverloadMarker overloadMarker, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toInstant");
        }
        if ((n & 1) != 0) {
            overloadMarker = OverloadMarker.Companion.getINSTANCE$kotlinx_datetime();
        }
        return timeZone.toInstant(localDateTime, overloadMarker);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TimeZone && Intrinsics.areEqual(this.zoneId, ((TimeZone)other).zoneId);
    }

    public int hashCode() {
        return this.zoneId.hashCode();
    }

    @NotNull
    public String toString() {
        String string2 = this.zoneId.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    static {
        UtcOffset utcOffset = UtcOffset.Companion.getZERO();
        ZoneId zoneId = ZoneId.of("UTC");
        Intrinsics.checkNotNullExpressionValue(zoneId, "of(...)");
        UTC = new FixedOffsetTimeZone(utcOffset, zoneId);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0015\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lkotlinx/datetime/TimeZone$Companion;", "", "<init>", "()V", "currentSystemDefault", "Lkotlinx/datetime/TimeZone;", "UTC", "Lkotlinx/datetime/FixedOffsetTimeZone;", "getUTC", "()Lkotlinx/datetime/FixedOffsetTimeZone;", "of", "zoneId", "", "ofZone", "Ljava/time/ZoneId;", "ofZone$kotlinx_datetime", "availableZoneIds", "", "getAvailableZoneIds", "()Ljava/util/Set;", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeZone currentSystemDefault() {
            ZoneId zoneId = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue(zoneId, "systemDefault(...)");
            return this.ofZone$kotlinx_datetime(zoneId);
        }

        @NotNull
        public final FixedOffsetTimeZone getUTC() {
            return UTC;
        }

        @NotNull
        public final TimeZone of(@NotNull String zoneId) {
            TimeZone timeZone;
            Intrinsics.checkNotNullParameter(zoneId, "zoneId");
            try {
                ZoneId zoneId2 = ZoneId.of(Intrinsics.areEqual(zoneId, "z") ? "Z" : zoneId);
                Intrinsics.checkNotNullExpressionValue(zoneId2, "of(...)");
                timeZone = this.ofZone$kotlinx_datetime(zoneId2);
            }
            catch (Exception e) {
                if (e instanceof DateTimeException) {
                    throw new IllegalTimeZoneException(e);
                }
                throw e;
            }
            return timeZone;
        }

        @NotNull
        public final TimeZone ofZone$kotlinx_datetime(@NotNull ZoneId zoneId) {
            TimeZone timeZone;
            Intrinsics.checkNotNullParameter(zoneId, "zoneId");
            if (zoneId instanceof ZoneOffset) {
                timeZone = new FixedOffsetTimeZone(new UtcOffset((ZoneOffset)zoneId));
            } else if (TimeZoneKt__TimeZoneJvmKt.access$isFixedOffset(zoneId)) {
                ZoneId zoneId2 = zoneId.normalized();
                Intrinsics.checkNotNull(zoneId2, "null cannot be cast to non-null type java.time.ZoneOffset");
                timeZone = new FixedOffsetTimeZone(new UtcOffset((ZoneOffset)zoneId2), zoneId);
            } else {
                timeZone = new TimeZone(zoneId);
            }
            return timeZone;
        }

        @NotNull
        public final Set<String> getAvailableZoneIds() {
            Set<String> set2 = ZoneId.getAvailableZoneIds();
            Intrinsics.checkNotNullExpressionValue(set2, "getAvailableZoneIds(...)");
            return set2;
        }

        @NotNull
        public final KSerializer<TimeZone> serializer() {
            return TimeZoneSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

