/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.awt;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.compose.ui.unit.IntRect;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0000\u001a0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u0005*\u00020\f2\b\b\u0002\u0010\u000b\u001a\u00020\rH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\rH\u0000\u001a\u0013\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\"(\u0010\u001a\u001a\u00020\u0001*\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00018B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\"(\u0010\u001a\u001a\u00020\u0001*\u00020 2\u0006\u0010\u0019\u001a\u00020\u00018@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010!\"\u0004\b\u001e\u0010\"\"(\u0010\u001a\u001a\u00020\u0001*\u00020#2\u0006\u0010\u0019\u001a\u00020\u00018@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010$\"\u0004\b\u001e\u0010%\u00a8\u0006&"}, d2={"isParentOf", "", "Ljava/awt/Component;", "component", "toAwtRectangle", "Ljava/awt/Rectangle;", "left", "", "top", "right", "bottom", "density", "Landroidx/compose/ui/unit/IntRect;", "Landroidx/compose/ui/unit/Density;", "toAwtRectangleRounded", "Landroidx/compose/ui/geometry/Rect;", "toAwtColor", "Ljava/awt/Color;", "Landroidx/compose/ui/graphics/Color;", "toAwtColor-8_81llA", "(J)Ljava/awt/Color;", "getTransparentWindowBackground", "isWindowTransparent", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "value", "hasMacOsShadow", "Ljavax/swing/JComponent;", "getHasMacOsShadow", "(Ljavax/swing/JComponent;)Z", "setHasMacOsShadow", "(Ljavax/swing/JComponent;Z)V", "Ljavax/swing/JFrame;", "(Ljavax/swing/JFrame;)Z", "(Ljavax/swing/JFrame;Z)V", "Ljavax/swing/JDialog;", "(Ljavax/swing/JDialog;)Z", "(Ljavax/swing/JDialog;Z)V", "ui"})
public final class Utils_desktopKt {
    public static final boolean isParentOf(@NotNull Component $this$isParentOf, @Nullable Component component) {
        Container parent;
        Intrinsics.checkNotNullParameter((Object)$this$isParentOf, (String)"<this>");
        Component component2 = component;
        Container container2 = parent = component2 != null ? component2.getParent() : null;
        while (parent != null) {
            if (Intrinsics.areEqual((Object)parent, (Object)$this$isParentOf)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    @NotNull
    public static final Rectangle toAwtRectangle(float left, float top, float right, float bottom, float density) {
        int rleft = (int)Math.floor(left / density);
        int rtop = (int)Math.floor(top / density);
        int rright = (int)Math.ceil(right / density);
        int rbottom = (int)Math.ceil(bottom / density);
        int rwidth = rright - rleft;
        int rheight = rbottom - rtop;
        return new Rectangle(rleft, rtop, rwidth, rheight);
    }

    @NotNull
    public static final Rectangle toAwtRectangle(@NotNull IntRect $this$toAwtRectangle, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)$this$toAwtRectangle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return Utils_desktopKt.toAwtRectangle($this$toAwtRectangle.getLeft(), $this$toAwtRectangle.getTop(), $this$toAwtRectangle.getRight(), $this$toAwtRectangle.getBottom(), density.getDensity());
    }

    public static /* synthetic */ Rectangle toAwtRectangle$default(IntRect intRect, Density density, int n, Object object) {
        if ((n & 1) != 0) {
            density = DensityKt.Density$default((float)1.0f, (float)0.0f, (int)2, null);
        }
        return Utils_desktopKt.toAwtRectangle(intRect, density);
    }

    @NotNull
    public static final Rectangle toAwtRectangleRounded(@NotNull Rect $this$toAwtRectangleRounded, @NotNull Density density) {
        Intrinsics.checkNotNullParameter((Object)$this$toAwtRectangleRounded, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        float densityValue = density.getDensity();
        int left = MathKt.roundToInt((float)($this$toAwtRectangleRounded.getLeft() / densityValue));
        int top = MathKt.roundToInt((float)($this$toAwtRectangleRounded.getTop() / densityValue));
        int right = MathKt.roundToInt((float)($this$toAwtRectangleRounded.getRight() / densityValue));
        int bottom = MathKt.roundToInt((float)($this$toAwtRectangleRounded.getBottom() / densityValue));
        return new Rectangle(left, top, right - left, bottom - top);
    }

    @NotNull
    public static final java.awt.Color toAwtColor-8_81llA(long $this$toAwtColor_u2d8_81llA) {
        return new java.awt.Color(Color.getRed-impl((long)$this$toAwtColor_u2d8_81llA), Color.getGreen-impl((long)$this$toAwtColor_u2d8_81llA), Color.getBlue-impl((long)$this$toAwtColor_u2d8_81llA), Color.getAlpha-impl((long)$this$toAwtColor_u2d8_81llA));
    }

    @Nullable
    public static final java.awt.Color getTransparentWindowBackground(boolean isWindowTransparent, @NotNull GraphicsApi renderApi) {
        Intrinsics.checkNotNullParameter((Object)renderApi, (String)"renderApi");
        boolean skikoTransparentWindowHack = OsArch_jvmKt.getHostOs() == OS.Windows && renderApi != GraphicsApi.DIRECT3D;
        return isWindowTransparent && !skikoTransparentWindowHack ? new java.awt.Color(0, 0, 0, 0) : null;
    }

    private static final boolean getHasMacOsShadow(JComponent $this$hasMacOsShadow) {
        Object object = $this$hasMacOsShadow.getClientProperty("Window.shadow");
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        return bl != null ? bl : false;
    }

    private static final void setHasMacOsShadow(JComponent $this$hasMacOsShadow, boolean value) {
        $this$hasMacOsShadow.putClientProperty("Window.shadow", value);
    }

    public static final boolean getHasMacOsShadow(@NotNull JFrame $this$hasMacOsShadow) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMacOsShadow, (String)"<this>");
        JRootPane jRootPane = $this$hasMacOsShadow.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return Utils_desktopKt.getHasMacOsShadow(jRootPane);
    }

    public static final void setHasMacOsShadow(@NotNull JFrame $this$hasMacOsShadow, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMacOsShadow, (String)"<this>");
        JRootPane jRootPane = $this$hasMacOsShadow.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        Utils_desktopKt.setHasMacOsShadow(jRootPane, value);
    }

    public static final boolean getHasMacOsShadow(@NotNull JDialog $this$hasMacOsShadow) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMacOsShadow, (String)"<this>");
        JRootPane jRootPane = $this$hasMacOsShadow.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        return Utils_desktopKt.getHasMacOsShadow(jRootPane);
    }

    public static final void setHasMacOsShadow(@NotNull JDialog $this$hasMacOsShadow, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMacOsShadow, (String)"<this>");
        JRootPane jRootPane = $this$hasMacOsShadow.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"getRootPane(...)");
        Utils_desktopKt.setHasMacOsShadow(jRootPane, value);
    }
}

