/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.MonoSplineKt;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0011J \u0010\u0014\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J \u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0011J\u0018\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0011H\u0002R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/compose/animation/core/MonoSpline;", "", "time", "", "y", "", "periodicBias", "", "<init>", "([F[[FF)V", "timePoints", "values", "[[F", "tangents", "slopeTemp", "makeFloatArray", "a", "", "b", "(II)[[F", "getPos", "t", "j", "", "v", "Landroidx/compose/animation/core/AnimationVector;", "index", "getSlope", "animation-core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMonoSpline.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonoSpline.kt\nandroidx/compose/animation/core/MonoSpline\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,303:1\n65#2,10:304\n65#2,10:314\n*S KotlinDebug\n*F\n+ 1 MonoSpline.kt\nandroidx/compose/animation/core/MonoSpline\n*L\n176#1:304,10\n244#1:314,10\n*E\n"})
public final class MonoSpline {
    @NotNull
    private final float[] timePoints;
    @NotNull
    private final float[][] values;
    @NotNull
    private final float[][] tangents;
    @NotNull
    private final float[] slopeTemp;
    public static final int $stable = 8;

    public MonoSpline(@NotNull float[] time2, @NotNull float[][] y2, float periodicBias) {
        int j;
        Intrinsics.checkNotNullParameter(time2, "time");
        Intrinsics.checkNotNullParameter(y2, "y");
        int n = time2.length;
        int dim = y2[0].length;
        this.slopeTemp = new float[dim];
        float[][] slope = this.makeFloatArray(n - 1, dim);
        float[][] tangent = this.makeFloatArray(n, dim);
        for (j = 0; j < dim; ++j) {
            int n2 = n - 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                float dt2 = time2[i2 + 1] - time2[i2];
                slope[i2][j] = (y2[i2 + 1][j] - y2[i2][j]) / dt2;
                tangent[i2][j] = i2 == 0 ? slope[i2][j] : (slope[i2 - 1][j] + slope[i2][j]) * 0.5f;
            }
            tangent[n - 1][j] = slope[n - 2][j];
        }
        if (!Float.isNaN(periodicBias)) {
            for (j = 0; j < dim; ++j) {
                float adjustedSlope;
                slope[0][j] = adjustedSlope = slope[n - 2][j] * (1.0f - periodicBias) + slope[0][j] * periodicBias;
                slope[n - 2][j] = adjustedSlope;
                tangent[n - 1][j] = adjustedSlope;
                tangent[0][j] = adjustedSlope;
            }
        }
        int n3 = n - 1;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int j2 = 0; j2 < dim; ++j2) {
                if (slope[i3][j2] == 0.0f) {
                    tangent[i3][j2] = 0.0f;
                    tangent[i3 + 1][j2] = 0.0f;
                    continue;
                }
                float a2 = tangent[i3][j2] / slope[i3][j2];
                float b2 = tangent[i3 + 1][j2] / slope[i3][j2];
                float h = (float)Math.hypot(a2, b2);
                if (!((double)h > 9.0)) continue;
                float t = 3.0f / h;
                tangent[i3][j2] = t * a2 * slope[i3][j2];
                tangent[i3 + 1][j2] = t * b2 * slope[i3][j2];
            }
        }
        this.timePoints = time2;
        this.values = y2;
        this.tangents = tangent;
    }

    private final float[][] makeFloatArray(int a2, int b2) {
        int n = 0;
        float[][] fArrayArray = new float[a2][];
        while (n < a2) {
            int n2 = n++;
            fArrayArray[n2] = new float[b2];
        }
        return fArrayArray;
    }

    public final float getPos(float t, int j) {
        float[][] values2 = this.values;
        float[][] tangents = this.tangents;
        int n = this.timePoints.length;
        int index2 = t <= this.timePoints[0] ? 0 : (t >= this.timePoints[n - 1] ? n - 1 : -1);
        if (index2 != -1) {
            return values2[index2][j] + (t - this.timePoints[index2]) * this.getSlope(this.timePoints[index2], j);
        }
        int n2 = n - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (t == this.timePoints[i2]) {
                return values2[i2][j];
            }
            if (!(t < this.timePoints[i2 + 1])) continue;
            float h = this.timePoints[i2 + 1] - this.timePoints[i2];
            float x2 = (t - this.timePoints[i2]) / h;
            float y1 = values2[i2][j];
            float y2 = values2[i2 + 1][j];
            float t1 = tangents[i2][j];
            float t2 = tangents[i2 + 1][j];
            return MonoSplineKt.hermiteInterpolate(h, x2, y1, y2, t1, t2);
        }
        return 0.0f;
    }

    public final void getPos(float time2, @NotNull AnimationVector v, int index2) {
        Intrinsics.checkNotNullParameter(v, "v");
        int n = this.timePoints.length;
        int dim = this.values[0].length;
        int k = time2 <= this.timePoints[0] ? 0 : (time2 >= this.timePoints[n - 1] ? n - 1 : -1);
        if (k != -1) {
            this.getSlope(this.timePoints[k], this.slopeTemp);
            for (int j = 0; j < dim; ++j) {
                v.set$animation_core(j, this.values[k][j] + (time2 - this.timePoints[k]) * this.slopeTemp[j]);
            }
            return;
        }
        int n2 = n - 1;
        for (int i2 = index2; i2 < n2; ++i2) {
            if (time2 == this.timePoints[i2]) {
                for (int j = 0; j < dim; ++j) {
                    v.set$animation_core(j, this.values[i2][j]);
                }
                return;
            }
            if (!(time2 < this.timePoints[i2 + 1])) continue;
            float h = this.timePoints[i2 + 1] - this.timePoints[i2];
            float x2 = (time2 - this.timePoints[i2]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values[i2][j];
                float y2 = this.values[i2 + 1][j];
                float t1 = this.tangents[i2][j];
                float t2 = this.tangents[i2 + 1][j];
                v.set$animation_core(j, MonoSplineKt.hermiteInterpolate(h, x2, y1, y2, t1, t2));
            }
            return;
        }
    }

    public static /* synthetic */ void getPos$default(MonoSpline monoSpline, float f, AnimationVector animationVector, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        monoSpline.getPos(f, animationVector, n);
    }

    /*
     * WARNING - void declaration
     */
    private final void getSlope(float time2, float[] v) {
        void $this$fastCoerceAtMost$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        int dim = this.values[0].length;
        int n = this.timePoints.length;
        float f = time2;
        float f2 = this.timePoints[0];
        float maximumValue$iv = this.timePoints[n - 1];
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float t = $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
        if (v.length < dim) {
            return;
        }
        int n2 = n - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(t <= this.timePoints[i2 + 1])) continue;
            float h = this.timePoints[i2 + 1] - this.timePoints[i2];
            float x2 = (t - this.timePoints[i2]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = this.values[i2][j];
                float y2 = this.values[i2 + 1][j];
                float t1 = this.tangents[i2][j];
                float t2 = this.tangents[i2 + 1][j];
                v[j] = MonoSplineKt.hermiteDifferential(h, x2, y1, y2, t1, t2) / h;
            }
            break;
        }
    }

    public final void getSlope(float time2, @NotNull AnimationVector v, int index2) {
        int tangentIndex;
        Intrinsics.checkNotNullParameter(v, "v");
        float[] timePoints = this.timePoints;
        float[][] values2 = this.values;
        float[][] tangents = this.tangents;
        int n = timePoints.length;
        int dim = values2[0].length;
        int n2 = time2 <= timePoints[0] ? 0 : (tangentIndex = time2 >= timePoints[n - 1] ? n - 1 : -1);
        if (tangentIndex != -1) {
            float[] tangent = tangents[tangentIndex];
            if (tangent.length < dim) {
                return;
            }
            for (int j = 0; j < dim; ++j) {
                v.set$animation_core(j, tangent[j]);
            }
            return;
        }
        int n3 = n - 1;
        for (int i2 = index2; i2 < n3; ++i2) {
            if (!(time2 <= timePoints[i2 + 1])) continue;
            float h = timePoints[i2 + 1] - timePoints[i2];
            float x2 = (time2 - timePoints[i2]) / h;
            for (int j = 0; j < dim; ++j) {
                float y1 = values2[i2][j];
                float y2 = values2[i2 + 1][j];
                float t1 = tangents[i2][j];
                float t2 = tangents[i2 + 1][j];
                v.set$animation_core(j, MonoSplineKt.hermiteDifferential(h, x2, y1, y2, t1, t2) / h);
            }
            break;
        }
    }

    public static /* synthetic */ void getSlope$default(MonoSpline monoSpline, float f, AnimationVector animationVector, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        monoSpline.getSlope(f, animationVector, n);
    }

    /*
     * WARNING - void declaration
     */
    private final float getSlope(float time2, int j) {
        void $this$fastCoerceAtMost$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        float[] timePoints = this.timePoints;
        float[][] values2 = this.values;
        float[][] tangents = this.tangents;
        int n = timePoints.length;
        float f = time2;
        float f2 = timePoints[0];
        float maximumValue$iv = timePoints[n - 1];
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float t = $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
        int n2 = n - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(t <= timePoints[i2 + 1])) continue;
            float y1 = values2[i2][j];
            float y2 = values2[i2 + 1][j];
            float t1 = tangents[i2][j];
            float t2 = tangents[i2 + 1][j];
            float h = timePoints[i2 + 1] - timePoints[i2];
            float x2 = (t - timePoints[i2]) / h;
            return MonoSplineKt.hermiteDifferential(h, x2, y1, y2, t1, t2) / h;
        }
        return 0.0f;
    }
}

