/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.gestures.BringIntoViewSpec;
import androidx.compose.foundation.pager.PagerState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Landroidx/compose/foundation/pager/PagerBringIntoViewSpec;", "Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "pagerState", "Landroidx/compose/foundation/pager/PagerState;", "defaultBringIntoViewSpec", "<init>", "(Landroidx/compose/foundation/pager/PagerState;Landroidx/compose/foundation/gestures/BringIntoViewSpec;)V", "getPagerState", "()Landroidx/compose/foundation/pager/PagerState;", "getDefaultBringIntoViewSpec", "()Landroidx/compose/foundation/gestures/BringIntoViewSpec;", "calculateScrollDistance", "", "offset", "size", "containerSize", "overrideProposedOffsetMove", "proposedOffsetMove", "foundation"})
final class PagerBringIntoViewSpec
implements BringIntoViewSpec {
    @NotNull
    private final PagerState pagerState;
    @NotNull
    private final BringIntoViewSpec defaultBringIntoViewSpec;

    public PagerBringIntoViewSpec(@NotNull PagerState pagerState, @NotNull BringIntoViewSpec defaultBringIntoViewSpec) {
        Intrinsics.checkNotNullParameter(pagerState, "pagerState");
        Intrinsics.checkNotNullParameter(defaultBringIntoViewSpec, "defaultBringIntoViewSpec");
        this.pagerState = pagerState;
        this.defaultBringIntoViewSpec = defaultBringIntoViewSpec;
    }

    @NotNull
    public final PagerState getPagerState() {
        return this.pagerState;
    }

    @NotNull
    public final BringIntoViewSpec getDefaultBringIntoViewSpec() {
        return this.defaultBringIntoViewSpec;
    }

    @Override
    public float calculateScrollDistance(float offset, float size2, float containerSize2) {
        float f;
        boolean isItemOutView;
        float proposedOffsetMove = this.defaultBringIntoViewSpec.calculateScrollDistance(offset, size2, containerSize2);
        boolean bl = offset > 0.0f ? offset + size2 > containerSize2 : (isItemOutView = offset + size2 <= 0.0f);
        if (!(Math.abs(proposedOffsetMove) == 0.0f) && isItemOutView) {
            f = this.overrideProposedOffsetMove(proposedOffsetMove);
        } else if ((double)Math.abs(this.pagerState.getFirstVisiblePageOffset$foundation()) < 1.0E-6) {
            f = 0.0f;
        } else {
            float reversedFirstPageScroll = (float)this.pagerState.getFirstVisiblePageOffset$foundation() * -1.0f;
            f = RangesKt.coerceIn(this.pagerState.getLastScrolledForward() ? reversedFirstPageScroll + (float)this.pagerState.getPageSizeWithSpacing$foundation() : reversedFirstPageScroll, -containerSize2, containerSize2);
        }
        float finalOffset = f;
        return finalOffset;
    }

    private final float overrideProposedOffsetMove(float proposedOffsetMove) {
        float correctedOffset;
        for (correctedOffset = (float)this.pagerState.getFirstVisiblePageOffset$foundation() * (float)-1; proposedOffsetMove > 0.0f && correctedOffset < proposedOffsetMove; correctedOffset += (float)this.pagerState.getPageSizeWithSpacing$foundation()) {
        }
        while (proposedOffsetMove < 0.0f && correctedOffset > proposedOffsetMove) {
            correctedOffset -= (float)this.pagerState.getPageSizeWithSpacing$foundation();
        }
        return correctedOffset;
    }
}

