/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text.input;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.AnnotatedStringKt;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.input.BackspaceCommand;
import androidx.compose.ui.text.input.CommitTextCommand;
import androidx.compose.ui.text.input.DeleteAllCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextCommand;
import androidx.compose.ui.text.input.DeleteSurroundingTextInCodePointsCommand;
import androidx.compose.ui.text.input.EditCommand;
import androidx.compose.ui.text.input.EditingBuffer;
import androidx.compose.ui.text.input.FinishComposingTextCommand;
import androidx.compose.ui.text.input.MoveCursorCommand;
import androidx.compose.ui.text.input.SetComposingRegionCommand;
import androidx.compose.ui.text.input.SetComposingTextCommand;
import androidx.compose.ui.text.input.SetSelectionCommand;
import androidx.compose.ui.text.input.TextFieldValue;
import androidx.compose.ui.text.input.TextInputSession;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0014\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0006\u0010\u0015\u001a\u00020\u0005J \u0010\u0016\u001a\u00020\u00172\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002J\f\u0010\u0019\u001a\u00020\u0017*\u00020\u0014H\u0002R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\t@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Landroidx/compose/ui/text/input/EditProcessor;", "", "<init>", "()V", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "mBufferState", "getMBufferState$ui_text", "()Landroidx/compose/ui/text/input/TextFieldValue;", "Landroidx/compose/ui/text/input/EditingBuffer;", "mBuffer", "getMBuffer$ui_text", "()Landroidx/compose/ui/text/input/EditingBuffer;", "reset", "", "textInputSession", "Landroidx/compose/ui/text/input/TextInputSession;", "apply", "editCommands", "", "Landroidx/compose/ui/text/input/EditCommand;", "toTextFieldValue", "generateBatchErrorMessage", "", "failedCommand", "toStringForLog", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEditProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditProcessor.kt\nandroidx/compose/ui/text/input/EditProcessor\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n35#2,5:170\n1#3:175\n*S KotlinDebug\n*F\n+ 1 EditProcessor.kt\nandroidx/compose/ui/text/input/EditProcessor\n*L\n101#1:170,5\n*E\n"})
public final class EditProcessor {
    @NotNull
    private TextFieldValue mBufferState = new TextFieldValue(AnnotatedStringKt.emptyAnnotatedString(), TextRange.Companion.getZero-d9O1mEE(), null, null);
    @NotNull
    private EditingBuffer mBuffer = new EditingBuffer(this.mBufferState.getAnnotatedString(), this.mBufferState.getSelection-d9O1mEE(), null);
    public static final int $stable = 8;

    @NotNull
    public final TextFieldValue getMBufferState$ui_text() {
        return this.mBufferState;
    }

    @NotNull
    public final EditingBuffer getMBuffer$ui_text() {
        return this.mBuffer;
    }

    public final void reset(@NotNull TextFieldValue value, @Nullable TextInputSession textInputSession2) {
        block8: {
            TextFieldValue textFieldValue;
            boolean compositionChanged;
            Intrinsics.checkNotNullParameter(value, "value");
            boolean textChanged = false;
            boolean selectionChanged = false;
            boolean bl = compositionChanged = !Intrinsics.areEqual(value.getComposition-MzsxiRA(), this.mBuffer.getComposition-MzsxiRA$ui_text());
            if (!Intrinsics.areEqual(this.mBufferState.getAnnotatedString().getText(), value.getAnnotatedString().getText())) {
                this.mBuffer = new EditingBuffer(value.getAnnotatedString(), value.getSelection-d9O1mEE(), null);
                textChanged = true;
            } else if (!TextRange.equals-impl0(this.mBufferState.getSelection-d9O1mEE(), value.getSelection-d9O1mEE())) {
                this.mBuffer.setSelection$ui_text(TextRange.getMin-impl(value.getSelection-d9O1mEE()), TextRange.getMax-impl(value.getSelection-d9O1mEE()));
                selectionChanged = true;
            }
            if (value.getComposition-MzsxiRA() == null) {
                this.mBuffer.commitComposition$ui_text();
            } else if (!TextRange.getCollapsed-impl(value.getComposition-MzsxiRA().unbox-impl())) {
                this.mBuffer.setComposition$ui_text(TextRange.getMin-impl(value.getComposition-MzsxiRA().unbox-impl()), TextRange.getMax-impl(value.getComposition-MzsxiRA().unbox-impl()));
            }
            if (textChanged || !selectionChanged && compositionChanged) {
                this.mBuffer.commitComposition$ui_text();
                textFieldValue = TextFieldValue.copy-3r_uNRQ$default(value, null, 0L, null, 3, null);
            } else {
                textFieldValue = value;
            }
            TextFieldValue newValue = textFieldValue;
            TextFieldValue oldValue = this.mBufferState;
            this.mBufferState = newValue;
            TextInputSession textInputSession3 = textInputSession2;
            if (textInputSession3 == null) break block8;
            textInputSession3.updateState(oldValue, newValue);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextFieldValue apply(@NotNull List<? extends EditCommand> editCommands) {
        TextFieldValue newState;
        void $this$apply_u24lambda_u242;
        Intrinsics.checkNotNullParameter(editCommands, "editCommands");
        EditCommand lastCommand = null;
        try {
            List<? extends EditCommand> $this$fastForEach$iv = editCommands;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                EditCommand item$iv;
                EditCommand it = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                lastCommand = it;
                it.applyTo(this.mBuffer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(this.generateBatchErrorMessage(editCommands, lastCommand), e);
        }
        long index$iv = this.mBuffer.getSelection-d9O1mEE$ui_text();
        AnnotatedString annotatedString = this.mBuffer.toAnnotatedString$ui_text();
        boolean bl = false;
        TextRange textRange = TextRange.box-impl((long)$this$apply_u24lambda_u242);
        long it = textRange.unbox-impl();
        boolean bl2 = false;
        TextRange textRange2 = !TextRange.getReversed-impl(this.mBufferState.getSelection-d9O1mEE()) ? textRange : null;
        long l = textRange2 != null ? textRange2.unbox-impl() : TextRangeKt.TextRange(TextRange.getMax-impl((long)$this$apply_u24lambda_u242), TextRange.getMin-impl((long)$this$apply_u24lambda_u242));
        DefaultConstructorMarker defaultConstructorMarker = null;
        TextRange textRange3 = this.mBuffer.getComposition-MzsxiRA$ui_text();
        long l2 = l;
        AnnotatedString annotatedString2 = annotatedString;
        this.mBufferState = newState = new TextFieldValue(annotatedString2, l2, textRange3, defaultConstructorMarker);
        return newState;
    }

    @NotNull
    public final TextFieldValue toTextFieldValue() {
        return this.mBufferState;
    }

    private final String generateBatchErrorMessage(List<? extends EditCommand> editCommands, EditCommand failedCommand) {
        StringBuilder stringBuilder;
        StringBuilder $this$generateBatchErrorMessage_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateBatchErrorMessage_u24lambda_u244.append("Error while applying EditCommand batch to buffer (length=" + this.mBuffer.getLength$ui_text() + ", composition=" + this.mBuffer.getComposition-MzsxiRA$ui_text() + ", selection=" + TextRange.toString-impl(this.mBuffer.getSelection-d9O1mEE$ui_text()) + "):").append('\n');
        CollectionsKt.joinTo$default(editCommands, $this$generateBatchErrorMessage_u24lambda_u244, "\n", null, null, 0, null, arg_0 -> EditProcessor.generateBatchErrorMessage$lambda$4$lambda$3(failedCommand, this, arg_0), 60, null);
        return stringBuilder.toString();
    }

    private final String toStringForLog(EditCommand $this$toStringForLog) {
        Object object;
        EditCommand editCommand = $this$toStringForLog;
        if (editCommand instanceof CommitTextCommand) {
            object = "CommitTextCommand(text.length=" + ((CommitTextCommand)$this$toStringForLog).getText().length() + ", newCursorPosition=" + ((CommitTextCommand)$this$toStringForLog).getNewCursorPosition() + ")";
        } else if (editCommand instanceof SetComposingTextCommand) {
            object = "SetComposingTextCommand(text.length=" + ((SetComposingTextCommand)$this$toStringForLog).getText().length() + ", newCursorPosition=" + ((SetComposingTextCommand)$this$toStringForLog).getNewCursorPosition() + ")";
        } else if (editCommand instanceof SetComposingRegionCommand) {
            object = ((SetComposingRegionCommand)$this$toStringForLog).toString();
        } else if (editCommand instanceof DeleteSurroundingTextCommand) {
            object = ((DeleteSurroundingTextCommand)$this$toStringForLog).toString();
        } else if (editCommand instanceof DeleteSurroundingTextInCodePointsCommand) {
            object = ((DeleteSurroundingTextInCodePointsCommand)$this$toStringForLog).toString();
        } else if (editCommand instanceof SetSelectionCommand) {
            object = ((SetSelectionCommand)$this$toStringForLog).toString();
        } else if (editCommand instanceof FinishComposingTextCommand) {
            object = ((FinishComposingTextCommand)$this$toStringForLog).toString();
        } else if (editCommand instanceof BackspaceCommand) {
            object = ((BackspaceCommand)$this$toStringForLog).toString();
        } else if (editCommand instanceof MoveCursorCommand) {
            object = ((MoveCursorCommand)$this$toStringForLog).toString();
        } else if (editCommand instanceof DeleteAllCommand) {
            object = ((DeleteAllCommand)$this$toStringForLog).toString();
        } else {
            String string2 = Reflection.getOrCreateKotlinClass($this$toStringForLog.getClass()).getSimpleName();
            if (string2 == null) {
                string2 = "{anonymous EditCommand}";
            }
            object = "Unknown EditCommand: " + string2;
        }
        return object;
    }

    private static final CharSequence generateBatchErrorMessage$lambda$4$lambda$3(EditCommand $failedCommand, EditProcessor this$0, EditCommand it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String prefix = $failedCommand == it ? " > " : "   ";
        return prefix + this$0.toStringForLog(it);
    }
}

