/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class AtomicIntegerDeserializer
extends StdScalarDeserializer<AtomicInteger> {
    private static final long serialVersionUID = 1L;

    public AtomicIntegerDeserializer() {
        super(AtomicInteger.class);
    }

    @Override
    public AtomicInteger deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.isExpectedNumberIntToken()) {
            return new AtomicInteger(p2.getIntValue());
        }
        Integer I2 = this._parseInteger(p2, ctxt, AtomicInteger.class);
        return I2 == null ? null : new AtomicInteger(I2);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return new AtomicInteger();
    }
}

