/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.DiscriminatorContext;
import com.networknt.schema.DiscriminatorValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.SetView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(OneOfValidator.class);
    private final List<JsonSchema> schemas;
    private Boolean canShortCircuit = null;

    public OneOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ONE_OF, validationContext);
        if (!schemaNode.isArray()) {
            JsonType nodeType = TypeFactory.getValueNodeType(schemaNode, this.validationContext.getConfig());
            throw new JsonSchemaException(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(schemaNode)).instanceLocation(schemaLocation.getFragment())).messageKey("type")).arguments(nodeType.toString(), "array")).build());
        }
        int size2 = schemaNode.size();
        this.schemas = new ArrayList<JsonSchema>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            JsonNode childNode = schemaNode.get(i2);
            this.schemas.add(validationContext.newSchema(schemaLocation.append(i2), evaluationPath.append(i2), childNode, parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        return this.validate(executionContext, node2, rootNode, instanceLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean walk) {
        Set<ValidationMessage> errors = null;
        OneOfValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        int numberOfValidSchema = 0;
        int index2 = 0;
        SetView<Object> childErrors = null;
        ArrayList<String> indexes = null;
        boolean failFast = executionContext.isFailFast();
        try {
            DiscriminatorValidator discriminator = null;
            if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) {
                DiscriminatorContext discriminatorContext = new DiscriminatorContext();
                executionContext.enterDiscriminatorContext(discriminatorContext, instanceLocation);
                discriminator = this.getParentSchema().getValidators().stream().filter(v -> "discriminator".equals(v.getKeyword())).findFirst().orElse(null);
                if (discriminator != null) {
                    discriminatorContext.registerDiscriminator(discriminator.getSchemaLocation(), (ObjectNode)discriminator.getSchemaNode());
                }
            }
            executionContext.setFailFast(false);
            for (JsonSchema schema : this.schemas) {
                Set<Object> schemaErrors = Collections.emptySet();
                schemaErrors = !walk ? schema.validate(executionContext, node2, rootNode, instanceLocation) : schema.walk(executionContext, node2, rootNode, instanceLocation, true);
                if (schemaErrors.isEmpty()) {
                    ++numberOfValidSchema;
                    if (indexes == null) {
                        indexes = new ArrayList<String>();
                    }
                    indexes.add(Integer.toString(index2));
                }
                if (numberOfValidSchema > 1 && this.canShortCircuit()) break;
                if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) {
                    DiscriminatorContext currentDiscriminatorContext;
                    if (discriminator != null && !discriminator.getPropertyName().isEmpty()) {
                        JsonNode discriminatorPropertyNode = node2.get(discriminator.getPropertyName());
                        if (discriminatorPropertyNode != null) {
                            String ref;
                            String discriminatorPropertyValue = discriminatorPropertyNode.asText();
                            discriminatorPropertyValue = discriminator.getMapping().getOrDefault(discriminatorPropertyValue, discriminatorPropertyValue);
                            JsonNode refNode = schema.getSchemaNode().get("$ref");
                            if (refNode != null && ((ref = refNode.asText()).equals(discriminatorPropertyValue) || ref.endsWith("/" + discriminatorPropertyValue))) {
                                executionContext.getCurrentDiscriminatorContext().markMatch();
                            }
                        } else {
                            executionContext.getCurrentDiscriminatorContext().markIgnore();
                        }
                    }
                    if ((currentDiscriminatorContext = executionContext.getCurrentDiscriminatorContext()).isDiscriminatorMatchFound() && childErrors == null) {
                        childErrors = new SetView();
                        childErrors.union(schemaErrors);
                    } else if (currentDiscriminatorContext.isDiscriminatorIgnore() || !currentDiscriminatorContext.isActive()) {
                        if (childErrors == null) {
                            childErrors = new SetView();
                        }
                        childErrors.union(schemaErrors);
                    }
                } else if (!schemaErrors.isEmpty() && this.reportChildErrors(executionContext)) {
                    if (childErrors == null) {
                        childErrors = new SetView<Object>();
                    }
                    childErrors.union(schemaErrors);
                }
                ++index2;
            }
            if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled() && (discriminator != null || executionContext.getCurrentDiscriminatorContext().isActive()) && !executionContext.getCurrentDiscriminatorContext().isDiscriminatorMatchFound() && !executionContext.getCurrentDiscriminatorContext().isDiscriminatorIgnore()) {
                errors = Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node2)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments("based on the provided discriminator. No alternative could be chosen based on the discriminator property")).build());
            }
        }
        finally {
            executionContext.setFailFast(failFast);
            if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) {
                executionContext.leaveDiscriminatorContextImmediately(instanceLocation);
            }
        }
        if (numberOfValidSchema != 1 && errors == null) {
            ValidationMessage message = ((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node2)).instanceLocation(instanceLocation)).messageKey(numberOfValidSchema > 1 ? "oneOf.indexes" : "oneOf")).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(Integer.toString(numberOfValidSchema), numberOfValidSchema > 1 ? String.join((CharSequence)", ", indexes) : "")).build();
            errors = childErrors != null ? new SetView<ValidationMessage>().union(Collections.singleton(message)).union(childErrors) : Collections.singleton(message);
        }
        return errors != null ? errors : Collections.emptySet();
    }

    protected boolean reportChildErrors(ExecutionContext executionContext) {
        return !executionContext.getExecutionConfig().isFailFast();
    }

    protected boolean canShortCircuit() {
        if (this.canShortCircuit == null) {
            boolean canShortCircuit = true;
            for (JsonValidator validator : this.getEvaluationParentSchema().getValidators()) {
                if (!"unevaluatedProperties".equals(validator.getKeyword()) && !"unevaluatedItems".equals(validator.getKeyword())) continue;
                canShortCircuit = false;
            }
            this.canShortCircuit = canShortCircuit;
        }
        return this.canShortCircuit;
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (shouldValidateSchema && node2 != null) {
            validationMessages.addAll(this.validate(executionContext, node2, rootNode, instanceLocation, true));
        } else {
            for (JsonSchema schema : this.schemas) {
                schema.walk(executionContext, node2, rootNode, instanceLocation, false);
            }
        }
        return validationMessages;
    }

    @Override
    public void preloadJsonSchema() {
        for (JsonSchema schema : this.schemas) {
            schema.initializeValidators();
        }
        this.canShortCircuit();
    }
}

