/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.networknt.schema.JsonType;
import com.networknt.schema.SchemaValidatorsConfig;

public class TypeFactory {
    public static JsonType getSchemaNodeType(JsonNode node2) {
        if (node2.isTextual()) {
            String type2 = node2.textValue();
            if ("object".equals(type2)) {
                return JsonType.OBJECT;
            }
            if ("array".equals(type2)) {
                return JsonType.ARRAY;
            }
            if ("string".equals(type2)) {
                return JsonType.STRING;
            }
            if ("number".equals(type2)) {
                return JsonType.NUMBER;
            }
            if ("integer".equals(type2)) {
                return JsonType.INTEGER;
            }
            if ("boolean".equals(type2)) {
                return JsonType.BOOLEAN;
            }
            if ("any".equals(type2)) {
                return JsonType.ANY;
            }
            if ("null".equals(type2)) {
                return JsonType.NULL;
            }
        }
        if (node2.isArray()) {
            return JsonType.UNION;
        }
        return JsonType.UNKNOWN;
    }

    public static JsonType getValueNodeType(JsonNode node2, SchemaValidatorsConfig config2) {
        if (node2 == null) {
            return JsonType.UNKNOWN;
        }
        JsonNodeType type2 = node2.getNodeType();
        switch (type2) {
            case OBJECT: {
                return JsonType.OBJECT;
            }
            case ARRAY: {
                return JsonType.ARRAY;
            }
            case STRING: 
            case BINARY: {
                return JsonType.STRING;
            }
            case NUMBER: {
                if (node2.isIntegralNumber()) {
                    return JsonType.INTEGER;
                }
                if (config2 != null && (config2.isJavaSemantics() || config2.isLosslessNarrowing()) && node2.canConvertToExactIntegral()) {
                    return JsonType.INTEGER;
                }
                return JsonType.NUMBER;
            }
            case BOOLEAN: {
                return JsonType.BOOLEAN;
            }
            case NULL: {
                return JsonType.NULL;
            }
        }
        return JsonType.UNKNOWN;
    }
}

