/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueItemsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UniqueItemsValidator.class);
    private final boolean unique;

    public UniqueItemsValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.UNIQUE_ITEMS, validationContext);
        this.unique = schemaNode.isBoolean() ? schemaNode.booleanValue() : false;
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        UniqueItemsValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        if (this.unique) {
            HashSet<JsonNode> set2 = new HashSet<JsonNode>();
            for (JsonNode n : node2) {
                if (set2.add(n)) continue;
                return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node2)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).build());
            }
        }
        return Collections.emptySet();
    }
}

