/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data;

import java.util.Arrays;
import java.util.Objects;

public enum AttachmentHint {
    INTERNAL(1L, "internal"),
    EXTERNAL(2L, "external"),
    WIRED(4L, "wired"),
    WIRELESS(8L, "wireless"),
    NFC(16L, "nfc"),
    BLUETOOTH(32L, "bluetooth"),
    NETWORK(64L, "network"),
    READY(128L, "ready"),
    WIFI_DIRECT(256L, "wifi_direct");

    private static final String VALUE_OUT_OF_RANGE_TEMPLATE = "value %s is out of range";
    private final long value;
    private final String string;

    private AttachmentHint(long value, String string3) {
        this.value = value;
        this.string = string3;
    }

    public static AttachmentHint create(long value) {
        if (value > 65535L || value < 0L) {
            throw new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value));
        }
        return Arrays.stream(AttachmentHint.values()).filter(item2 -> item2.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public static AttachmentHint create(String value) {
        return Arrays.stream(AttachmentHint.values()).filter(item2 -> Objects.equals(item2.string, value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(VALUE_OUT_OF_RANGE_TEMPLATE, value)));
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return this.string;
    }
}

