/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionAuthenticatorOutput;
import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreAuthenticationObject {
    private final byte[] credentialId;
    private final AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData;
    private final byte[] authenticatorDataBytes;
    private final byte[] clientDataHash;
    private final CoreServerProperty serverProperty;
    private final CoreAuthenticator authenticator;

    public CoreAuthenticationObject(@NotNull byte[] credentialId, @NotNull AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> authenticatorData, @NotNull byte[] authenticatorDataBytes, @NotNull byte[] clientDataHash, @NotNull CoreServerProperty serverProperty, @NotNull CoreAuthenticator authenticator) {
        AssertUtil.notNull(credentialId, "credentialId must not be null");
        AssertUtil.notNull(authenticatorData, "authenticatorData must not be null");
        AssertUtil.notNull(authenticatorDataBytes, "authenticatorDataBytes must not be null");
        AssertUtil.notNull(clientDataHash, "clientDataHash must not be null");
        AssertUtil.notNull(serverProperty, "serverProperty must not be null");
        AssertUtil.notNull(authenticator, "authenticator must not be null");
        this.credentialId = ArrayUtil.clone(credentialId);
        this.authenticatorData = authenticatorData;
        this.authenticatorDataBytes = ArrayUtil.clone(authenticatorDataBytes);
        this.clientDataHash = ArrayUtil.clone(clientDataHash);
        this.serverProperty = serverProperty;
        this.authenticator = authenticator;
    }

    @NotNull
    public byte[] getCredentialId() {
        return ArrayUtil.clone(this.credentialId);
    }

    @NotNull
    public AuthenticatorData<AuthenticationExtensionAuthenticatorOutput> getAuthenticatorData() {
        return this.authenticatorData;
    }

    @NotNull
    public byte[] getAuthenticatorDataBytes() {
        return ArrayUtil.clone(this.authenticatorDataBytes);
    }

    @NotNull
    public byte[] getClientDataHash() {
        return ArrayUtil.clone(this.clientDataHash);
    }

    @NotNull
    public CoreServerProperty getServerProperty() {
        return this.serverProperty;
    }

    @NotNull
    public CoreAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreAuthenticationObject that = (CoreAuthenticationObject)o;
        return Arrays.equals(this.credentialId, that.credentialId) && Objects.equals(this.authenticatorData, that.authenticatorData) && Arrays.equals(this.authenticatorDataBytes, that.authenticatorDataBytes) && Arrays.equals(this.clientDataHash, that.clientDataHash) && Objects.equals(this.serverProperty, that.serverProperty) && Objects.equals(this.authenticator, that.authenticator);
    }

    public int hashCode() {
        int result2 = Objects.hash(this.authenticatorData, this.serverProperty, this.authenticator);
        result2 = 31 * result2 + Arrays.hashCode(this.credentialId);
        result2 = 31 * result2 + Arrays.hashCode(this.authenticatorDataBytes);
        result2 = 31 * result2 + Arrays.hashCode(this.clientDataHash);
        return result2;
    }
}

