/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier;

import com.webauthn4j.data.AuthenticatorTransport;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.RegistrationExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.util.ArrayUtil;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CollectionUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.verifier.CoreRegistrationObject;
import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistrationObject
extends CoreRegistrationObject {
    private final CollectedClientData collectedClientData;
    private final byte[] collectedClientDataBytes;
    private final AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions;
    private final Set<AuthenticatorTransport> transports;

    public RegistrationObject(@NotNull AttestationObject attestationObject, @NotNull byte[] attestationObjectBytes, @NotNull CollectedClientData collectedClientData, @NotNull byte[] collectedClientDataBytes, @Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, @Nullable Set<AuthenticatorTransport> transports, @NotNull ServerProperty serverProperty, @NotNull Instant timestamp) {
        super(attestationObject, attestationObjectBytes, MessageDigestUtil.createSHA256().digest(collectedClientDataBytes), serverProperty, timestamp);
        AssertUtil.notNull(collectedClientData, "collectedClientData must not be null");
        AssertUtil.notNull(collectedClientDataBytes, "collectedClientDataBytes must not be null");
        this.collectedClientData = collectedClientData;
        this.collectedClientDataBytes = ArrayUtil.clone(collectedClientDataBytes);
        this.clientExtensions = clientExtensions;
        this.transports = CollectionUtil.unmodifiableSet(transports);
    }

    public RegistrationObject(@NotNull AttestationObject attestationObject, @NotNull byte[] attestationObjectBytes, @NotNull CollectedClientData collectedClientData, @NotNull byte[] collectedClientDataBytes, @Nullable AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> clientExtensions, @Nullable Set<AuthenticatorTransport> transports, @NotNull ServerProperty serverProperty) {
        this(attestationObject, attestationObjectBytes, collectedClientData, collectedClientDataBytes, clientExtensions, transports, serverProperty, Instant.now());
    }

    @NotNull
    public CollectedClientData getCollectedClientData() {
        return this.collectedClientData;
    }

    @NotNull
    public byte[] getCollectedClientDataBytes() {
        return ArrayUtil.clone(this.collectedClientDataBytes);
    }

    @Nullable
    public AuthenticationExtensionsClientOutputs<RegistrationExtensionClientOutput> getClientExtensions() {
        return this.clientExtensions;
    }

    @Nullable
    public Set<AuthenticatorTransport> getTransports() {
        return this.transports;
    }

    @Override
    @NotNull
    public ServerProperty getServerProperty() {
        return (ServerProperty)super.getServerProperty();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RegistrationObject that = (RegistrationObject)o;
        return Objects.equals(this.collectedClientData, that.collectedClientData) && Arrays.equals(this.collectedClientDataBytes, that.collectedClientDataBytes) && Objects.equals(this.clientExtensions, that.clientExtensions) && Objects.equals(this.transports, that.transports);
    }

    @Override
    public int hashCode() {
        int result2 = Objects.hash(super.hashCode(), this.collectedClientData, this.clientExtensions, this.transports);
        result2 = 31 * result2 + Arrays.hashCode(this.collectedClientDataBytes);
        return result2;
    }
}

