/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.AssertUtil;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import org.jetbrains.annotations.NotNull;

public class SignatureUtil {
    private SignatureUtil() {
    }

    @NotNull
    public static Signature createRS256() {
        return SignatureUtil.createSignature("SHA256withRSA");
    }

    @NotNull
    public static Signature createES256() {
        return SignatureUtil.createSignature("SHA256withECDSA");
    }

    @NotNull
    public static Signature createSignature(@NotNull String algorithm) {
        AssertUtil.notNull(algorithm, "algorithm is required; it must not be null");
        try {
            return Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

