/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.window.Geometry_desktopKt;
import androidx.compose.ui.window.WindowLocationTracker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\n\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Landroidx/compose/ui/window/WindowLocationTracker;", "", "<init>", "()V", "cascadeOffset", "Ljava/awt/Point;", "lastFocusedWindows", "", "Ljava/awt/Window;", "focusListener", "androidx/compose/ui/window/WindowLocationTracker$focusListener$1", "Landroidx/compose/ui/window/WindowLocationTracker$focusListener$1;", "onWindowCreated", "", "window", "onWindowDisposed", "lastActiveGraphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "getLastActiveGraphicsConfiguration", "()Ljava/awt/GraphicsConfiguration;", "getCascadeLocationFor", "ui"})
@StabilityInferred(parameters=0)
public final class WindowLocationTracker {
    @NotNull
    public static final WindowLocationTracker INSTANCE = new WindowLocationTracker();
    @NotNull
    private static final Point cascadeOffset = new Point(48, 48);
    @NotNull
    private static Set<Window> lastFocusedWindows = new LinkedHashSet();
    @NotNull
    private static final focusListener.1 focusListener = new WindowFocusListener(){

        public void windowGainedFocus(WindowEvent e) {
            Intrinsics.checkNotNullParameter(e, "e");
            WindowLocationTracker.access$getLastFocusedWindows$p().remove(e.getWindow());
            Set set2 = WindowLocationTracker.access$getLastFocusedWindows$p();
            Window window = e.getWindow();
            Intrinsics.checkNotNullExpressionValue(window, "getWindow(...)");
            set2.add(window);
        }

        public void windowLostFocus(WindowEvent e) {
            Intrinsics.checkNotNullParameter(e, "e");
        }
    };
    public static final int $stable = 8;

    private WindowLocationTracker() {
    }

    public final void onWindowCreated(@NotNull Window window) {
        Intrinsics.checkNotNullParameter(window, "window");
        window.addWindowFocusListener(focusListener);
    }

    public final void onWindowDisposed(@NotNull Window window) {
        Intrinsics.checkNotNullParameter(window, "window");
        window.removeWindowFocusListener(focusListener);
        lastFocusedWindows.remove(window);
    }

    @Nullable
    public final GraphicsConfiguration getLastActiveGraphicsConfiguration() {
        Window window = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        return window != null ? window.getGraphicsConfiguration() : null;
    }

    @NotNull
    public final Point getCascadeLocationFor(@NotNull Window window) {
        Point point;
        Object graphicsConfiguration;
        Intrinsics.checkNotNullParameter(window, "window");
        Window lastWindow = (Window)CollectionsKt.lastOrNull((Iterable)lastFocusedWindows);
        Object object = lastWindow;
        if (object == null || (object = ((Component)object).getGraphicsConfiguration()) == null) {
            GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            object = graphicsDevice != null ? graphicsDevice.getDefaultConfiguration() : null;
        }
        if ((graphicsConfiguration = object) != null) {
            Rectangle screenBounds = ((GraphicsConfiguration)graphicsConfiguration).getBounds();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)graphicsConfiguration);
            Intrinsics.checkNotNull(screenBounds);
            Point screenLeftTop = Geometry_desktopKt.plus(Geometry_desktopKt.getLeftTop(screenBounds), new Point(screenInsets.left, screenInsets.top));
            Point screenRightBottom = Geometry_desktopKt.minus(Geometry_desktopKt.getRightBottom(screenBounds), new Point(screenInsets.right, screenInsets.bottom));
            Serializable serializable = lastWindow;
            if (serializable == null || (serializable = serializable.getLocation()) == null) {
                serializable = screenLeftTop;
            }
            Serializable lastLocation = serializable;
            Point location = Geometry_desktopKt.plus((Point)lastLocation, cascadeOffset);
            Dimension dimension = window.getSize();
            Intrinsics.checkNotNullExpressionValue(dimension, "getSize(...)");
            Point rightBottom = Geometry_desktopKt.plus(location, Geometry_desktopKt.getRightBottom(dimension));
            if (rightBottom.x > screenRightBottom.x || rightBottom.y > screenRightBottom.y) {
                location = Geometry_desktopKt.plus(screenLeftTop, cascadeOffset);
            }
            point = location;
        } else {
            point = cascadeOffset;
        }
        return point;
    }

    public static final /* synthetic */ Set access$getLastFocusedWindows$p() {
        return lastFocusedWindows;
    }
}

